/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

public class P2IndexImpl
implements P2Index {
    public static final P2IndexImpl INSTANCE = new P2IndexImpl();
    private static final String INDEX_BASE = "https://download.eclipse.org/oomph/index/";
    private long timeStamp;
    private Map<Integer, RepositoryImpl> repositories;
    private P2Index.Repository[] repositoriesArray;
    private Map<String, Set<String>> capabilitiesMap;
    private File repositoriesCacheFile;
    private File capabilitiesCacheFile;
    private int capabilitiesRefreshHours = -1;
    private int repositoriesRefreshHours = -1;

    private P2IndexImpl() {
    }

    private synchronized void initCapabilities() {
        block17: {
            if (this.capabilitiesMap == null || this.capabilitiesCacheFile.lastModified() + (long)(this.capabilitiesRefreshHours * 60 * 60 * 1000) < System.currentTimeMillis()) {
                this.capabilitiesMap = new LinkedHashMap<String, Set<String>>();
                ZipFile zipFile = null;
                InputStream inputStream = null;
                try {
                    try {
                        this.initCapabilitiesCacheFile();
                        zipFile = new ZipFile(this.capabilitiesCacheFile);
                        ZipEntry zipEntry = zipFile.getEntry("capabilities");
                        inputStream = zipFile.getInputStream(zipEntry);
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                        options.put("DATA_CONVERTER", Boolean.TRUE);
                        options.put("BUFFER_CAPACITY", 8192);
                        BinaryResourceImpl.EObjectInputStream stream = new BinaryResourceImpl.EObjectInputStream(inputStream, options);
                        this.capabilitiesRefreshHours = stream.readInt();
                        int mapSize = stream.readCompressedInt();
                        int i = 0;
                        while (i < mapSize) {
                            String key = stream.readSegmentedString();
                            int valuesSize = stream.readCompressedInt();
                            int j = 0;
                            while (j < valuesSize) {
                                String value = stream.readSegmentedString();
                                CollectionUtil.add(this.capabilitiesMap, (Object)key, (Object)value);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        P2CorePlugin.INSTANCE.log(ex, 2);
                        IOUtil.closeSilent(inputStream);
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException ex2) {
                                P2CorePlugin.INSTANCE.log(ex2, 2);
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(inputStream);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException ex) {
                            P2CorePlugin.INSTANCE.log(ex, 2);
                        }
                    }
                    throw throwable;
                }
                IOUtil.closeSilent((Closeable)inputStream);
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ex) {
                        P2CorePlugin.INSTANCE.log(ex, 2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void initRepositories(boolean force) {
        block21: {
            if (this.repositories == null || force || this.repositoriesCacheFile.lastModified() + (long)(this.repositoriesRefreshHours * 60 * 60 * 1000) < System.currentTimeMillis()) {
                this.repositories = new HashMap<Integer, RepositoryImpl>();
                ZipFile zipFile = null;
                InputStream inputStream = null;
                try {
                    try {
                        void var9_11;
                        this.initRepositoriesCacheFile();
                        zipFile = new ZipFile(this.repositoriesCacheFile);
                        ZipEntry zipEntry = zipFile.getEntry("repositories");
                        inputStream = zipFile.getInputStream(zipEntry);
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                        options.put("DATA_CONVERTER", Boolean.TRUE);
                        options.put("BUFFER_CAPACITY", 8192);
                        BinaryResourceImpl.EObjectInputStream stream = new BinaryResourceImpl.EObjectInputStream(inputStream, options);
                        this.timeStamp = stream.readLong();
                        this.repositoriesRefreshHours = stream.readInt();
                        int repositoryCount = stream.readInt();
                        HashMap<RepositoryImpl, List<Integer>> composedRepositories = new HashMap<RepositoryImpl, List<Integer>>();
                        boolean bl = true;
                        while (var9_11 <= repositoryCount) {
                            RepositoryImpl repository = new RepositoryImpl(stream, (int)var9_11, composedRepositories);
                            this.repositories.put((int)var9_11, repository);
                            ++var9_11;
                        }
                        for (Map.Entry entry : composedRepositories.entrySet()) {
                            RepositoryImpl repository = (RepositoryImpl)entry.getKey();
                            Iterator iterator = ((List)entry.getValue()).iterator();
                            while (iterator.hasNext()) {
                                int compositeID = (Integer)iterator.next();
                                RepositoryImpl composite = this.repositories.get(compositeID);
                                if (composite == null) continue;
                                composite.addChild(repository);
                                repository.addComposite(composite);
                            }
                        }
                        try {
                            int n = stream.readInt();
                            int i = 0;
                            while (i < n) {
                                int id2 = stream.readInt();
                                int unresolvedChildren = stream.readInt();
                                RepositoryImpl repository = this.repositories.get(id2);
                                repository.unresolvedChildren = unresolvedChildren;
                                ++i;
                            }
                        }
                        catch (Exception exception) {
                            P2CorePlugin.INSTANCE.log(exception, 2);
                        }
                        this.repositoriesArray = this.repositories.values().toArray(new P2Index.Repository[this.repositories.size()]);
                    }
                    catch (Exception ex) {
                        P2CorePlugin.INSTANCE.log(ex, 2);
                        IOUtil.close(inputStream);
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException ex2) {
                                P2CorePlugin.INSTANCE.log(ex2, 2);
                            }
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(inputStream);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException ex) {
                            P2CorePlugin.INSTANCE.log(ex, 2);
                        }
                    }
                    throw throwable;
                }
                IOUtil.close((Closeable)inputStream);
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ex) {
                        P2CorePlugin.INSTANCE.log(ex, 2);
                    }
                }
            }
        }
    }

    private boolean initRepositoriesCacheFile() throws Exception {
        if (this.repositoriesCacheFile == null) {
            IPath stateLocation = P2CorePlugin.INSTANCE.isOSGiRunning() ? P2CorePlugin.INSTANCE.getStateLocation() : new Path(".");
            this.repositoriesCacheFile = new File(stateLocation.toOSString(), "repositories");
        }
        P2IndexImpl.downloadIfModifiedSince(new URL("https://download.eclipse.org/oomph/index/repositories"), this.repositoriesCacheFile);
        return true;
    }

    private boolean initCapabilitiesCacheFile() throws Exception {
        if (this.capabilitiesCacheFile == null) {
            IPath stateLocation = P2CorePlugin.INSTANCE.isOSGiRunning() ? P2CorePlugin.INSTANCE.getStateLocation() : new Path(".");
            this.capabilitiesCacheFile = new File(stateLocation.toOSString(), "capabilities");
        }
        P2IndexImpl.downloadIfModifiedSince(new URL("https://download.eclipse.org/oomph/index/capabilities"), this.capabilitiesCacheFile);
        return true;
    }

    @Override
    public P2Index.Repository[] getRepositories() {
        this.initRepositories(false);
        return this.repositoriesArray;
    }

    @Override
    public Map<String, Set<String>> getCapabilities() {
        this.initCapabilities();
        return Collections.unmodifiableMap(this.capabilitiesMap);
    }

    @Override
    public Map<P2Index.Repository, Set<Version>> lookupCapabilities(String namespace, String name) {
        HashMap<P2Index.Repository, Set<Version>> capabilities;
        block12: {
            capabilities = new HashMap<P2Index.Repository, Set<Version>>();
            if (!StringUtil.isEmpty((String)namespace) && !StringUtil.isEmpty((String)name)) {
                String line;
                BufferedReader reader;
                block11: {
                    namespace = URI.encodeSegment((String)namespace, (boolean)false);
                    name = URI.encodeSegment((String)name, (boolean)false);
                    reader = null;
                    InputStream inputStream = new URL(INDEX_BASE + namespace + "/" + name).openStream();
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                    line = reader.readLine();
                    if (line != null) break block11;
                    HashMap<P2Index.Repository, Set<Version>> hashMap = capabilities;
                    IOUtil.close((Closeable)reader);
                    return hashMap;
                }
                try {
                    long timeStamp = Long.parseLong(line);
                    this.initRepositories(timeStamp != this.timeStamp);
                    while ((line = reader.readLine()) != null) {
                        String[] tokens = line.split(",");
                        int repositoryID = Integer.parseInt(tokens[0]);
                        P2Index.Repository repository = this.repositories.get(repositoryID);
                        if (repository == null) continue;
                        HashSet<Version> versions = new HashSet<Version>();
                        int i = 1;
                        while (i < tokens.length) {
                            versions.add(Version.parseVersion((String)tokens[i]));
                            ++i;
                        }
                        capabilities.put(repository, versions);
                    }
                }
                catch (FileNotFoundException inputStream) {
                    IOUtil.close(reader);
                    break block12;
                }
                catch (Exception ex) {
                    try {
                        P2CorePlugin.INSTANCE.log(ex, 2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtil.close(reader);
                    }
                }
                IOUtil.close((Closeable)reader);
            }
        }
        return capabilities;
    }

    @Override
    public Map<P2Index.Repository, Set<Version>> generateCapabilitiesFromComposedRepositories(Map<P2Index.Repository, Set<Version>> capabilitiesFromSimpleRepositories) {
        HashMap<P2Index.Repository, Set<Version>> capabilities = new HashMap<P2Index.Repository, Set<Version>>();
        for (Map.Entry<P2Index.Repository, Set<Version>> entry : capabilitiesFromSimpleRepositories.entrySet()) {
            P2Index.Repository repository = entry.getKey();
            Set<Version> versions = entry.getValue();
            this.recurseComposedRepositories(capabilities, repository, versions);
        }
        return capabilities;
    }

    private void recurseComposedRepositories(Map<P2Index.Repository, Set<Version>> capabilities, P2Index.Repository repository, Set<Version> versions) {
        P2Index.Repository[] repositoryArray = repository.getComposites();
        int n = repositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            P2Index.Repository composite = repositoryArray[n2];
            Set<Version> set = capabilities.get(composite);
            if (set == null) {
                set = new HashSet<Version>();
                capabilities.put(composite, set);
            }
            set.addAll(versions);
            this.recurseComposedRepositories(capabilities, composite, versions);
            ++n2;
        }
    }

    private static void downloadIfModifiedSince(URL url, File file) throws IOException {
        HttpURLConnection connection;
        FileOutputStream outputStream;
        InputStream inputStream;
        block5: {
            long lastModified = -1L;
            if (file.isFile()) {
                lastModified = file.lastModified();
            }
            inputStream = null;
            outputStream = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                if (lastModified != -1L) {
                    connection.setIfModifiedSince(lastModified);
                }
                connection.connect();
                inputStream = connection.getInputStream();
                if (connection.getResponseCode() != 304) break block5;
            }
            catch (Throwable throwable) {
                IOUtil.close(outputStream);
                IOUtil.close(inputStream);
                throw throwable;
            }
            IOUtil.close(outputStream);
            IOUtil.close((Closeable)inputStream);
            return;
        }
        outputStream = new FileOutputStream(file);
        IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
        file.setLastModified(connection.getLastModified());
        IOUtil.close((Closeable)outputStream);
        IOUtil.close((Closeable)inputStream);
    }

    public static final class RepositoryImpl
    implements P2Index.Repository {
        public static final int UNINITIALIZED = -1;
        private static final P2Index.Repository[] NO_REPOSITORIES = new P2Index.Repository[0];
        private final URI location;
        private final int id;
        private final boolean composed;
        private final boolean compressed;
        private final long timestamp;
        private int capabilityCount;
        private int unresolvedChildren;
        private P2Index.Repository[] children;
        private P2Index.Repository[] composites;

        public RepositoryImpl(BinaryResourceImpl.EObjectInputStream stream, int id, Map<RepositoryImpl, List<Integer>> composedRepositories) throws IOException {
            this.id = id;
            this.location = stream.readURI();
            this.composed = stream.readBoolean();
            this.compressed = stream.readBoolean();
            this.timestamp = stream.readLong();
            this.capabilityCount = this.composed ? -1 : stream.readInt();
            ArrayList<Integer> composites = null;
            while (stream.readBoolean()) {
                if (composites == null) {
                    composites = new ArrayList<Integer>();
                    composedRepositories.put(this, composites);
                }
                int composite = stream.readInt();
                composites.add(composite);
            }
        }

        @Override
        public URI getLocation() {
            return this.location;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public boolean isComposed() {
            return this.composed;
        }

        @Override
        public boolean isCompressed() {
            return this.compressed;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getCapabilityCount() {
            if (this.composed && this.capabilityCount == -1) {
                this.capabilityCount = 0;
                P2Index.Repository[] repositoryArray = this.getChildren();
                int n = repositoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    P2Index.Repository child = repositoryArray[n2];
                    this.capabilityCount += child.getCapabilityCount();
                    ++n2;
                }
            }
            return this.capabilityCount;
        }

        @Override
        public int getUnresolvedChildren() {
            return this.unresolvedChildren;
        }

        @Override
        public P2Index.Repository[] getChildren() {
            if (this.children == null) {
                return NO_REPOSITORIES;
            }
            return this.children;
        }

        @Override
        public P2Index.Repository[] getComposites() {
            if (this.composites == null) {
                return NO_REPOSITORIES;
            }
            return this.composites;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RepositoryImpl other = (RepositoryImpl)obj;
            return this.id == other.id;
        }

        @Override
        public int compareTo(P2Index.Repository o) {
            return this.location.toString().compareTo(o.getLocation().toString());
        }

        public String toString() {
            return this.location.toString();
        }

        public void addChild(P2Index.Repository child) {
            this.children = this.addRepository(this.children, child);
        }

        public void addComposite(P2Index.Repository composite) {
            this.composites = this.addRepository(this.composites, composite);
        }

        private P2Index.Repository[] addRepository(P2Index.Repository[] repositories, P2Index.Repository repository) {
            if (repositories == null) {
                return new P2Index.Repository[]{repository};
            }
            int length = repositories.length;
            P2Index.Repository[] newRepositories = new P2Index.Repository[length + 1];
            System.arraycopy(repositories, 0, newRepositories, 0, length);
            newRepositories[length] = repository;
            return newRepositories;
        }
    }
}

