/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.TarEntry;
import org.eclipse.equinox.internal.p2.core.helpers.TarException;
import org.eclipse.equinox.internal.p2.core.helpers.TarFile;
import org.eclipse.osgi.util.NLS;

public class FileUtils {
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private static final Set<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"));

    private static File[] untarFile(File source, File outputDir) throws IOException, TarException {
        ArrayList<File> untarredFiles = new ArrayList<File>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (TarFile tarFile = new TarFile(source);){
            for (TarEntry entry : tarFile.entries()) {
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (InputStream input = tarFile.getInputStream(entry);){
                    File outFile = FileUtils.createSubPathFile(outputDir, entry.getName());
                    untarredFiles.add(outFile);
                    if (entry.getFileType() == 53) {
                        outFile.mkdirs();
                        continue;
                    }
                    if (outFile.exists()) {
                        outFile.delete();
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    try {
                        FileUtils.copyStream(input, false, new FileOutputStream(outFile), true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    outFile.setLastModified(entry.getTime());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return untarredFiles.toArray(new File[untarredFiles.size()]);
    }

    public static File[] unzipFile(File zipFile, File outputDir) throws IOException {
        if (zipFile.getName().toLowerCase().endsWith(".tar.gz")) {
            try {
                return FileUtils.untarFile(zipFile, outputDir);
            }
            catch (TarException e) {
                IOException ioException22 = new IOException(e.getMessage());
                ioException22.initCause(e);
                throw ioException22;
            }
        }
        try {
            Throwable e = null;
            Object ioException22 = null;
            try (FileInputStream in = new FileInputStream(zipFile);){
                return FileUtils.unzipStream(in, zipFile.length(), outputDir, null, null);
            }
            catch (Throwable ioException22) {
                if (e == null) {
                    e = ioException22;
                } else if (e != ioException22) {
                    e.addSuppressed(ioException22);
                }
                throw e;
            }
        }
        catch (IOException e) {
            IOException ioException = new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()));
            ioException.initCause(e);
            throw ioException;
        }
    }

    public static File[] unzipFile(File zipFile, File outputDir, String taskName, IProgressMonitor monitor) throws IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(zipFile);){
                return FileUtils.unzipStream(in, zipFile.length(), outputDir, taskName, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            IOException ioException = new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()));
            ioException.initCause(e);
            throw ioException;
        }
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, String taskName, IProgressMonitor monitor) throws IOException {
        InputStream is = monitor == null ? stream : stream;
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        Throwable throwable = null;
        Object var9_9 = null;
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));){
            ZipEntry ze = in.getNextEntry();
            if (ze == null) {
                in.close();
                throw new IOException(Messages.Util_Invalid_Zip_File_Format);
            }
            do {
                File outFile = FileUtils.createSubPathFile(outputDir, ze.getName());
                unzippedFiles.add(outFile);
                if (ze.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    if (outFile.exists()) {
                        outFile.delete();
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    try {
                        FileUtils.copyStream(in, false, new FileOutputStream(outFile), true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    outFile.setLastModified(ze.getTime());
                }
                in.closeEntry();
            } while ((ze = in.getNextEntry()) != null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return unzippedFiles.toArray(new File[unzippedFiles.size()]);
    }

    public static boolean isReservedFileName(File file) {
        if (!IS_WINDOWS) {
            return false;
        }
        String fileName = file.getName();
        int dot = fileName.indexOf(46);
        String basename = dot == -1 ? fileName : fileName.substring(0, dot);
        return RESERVED_NAMES.contains(basename.toLowerCase());
    }

    private static File createSubPathFile(File root, String subPath) throws IOException {
        Path rootBaseNormalized;
        Path resultNormalized;
        File result = new File(root, subPath);
        if (subPath.contains("..") && !(resultNormalized = result.toPath().normalize()).startsWith(rootBaseNormalized = root.toPath().normalize())) {
            throw new IOException("Invalid path: " + subPath);
        }
        if (FileUtils.isReservedFileName(result)) {
            throw new IOException("Invalid filename: " + subPath);
        }
        return result;
    }

    public static void deleteEmptyDirs(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtils.deleteEmptyDirs(file);
                ++n2;
            }
            dir.getCanonicalFile().delete();
        }
    }

    public static void deleteAll(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtils.deleteAll(f);
                ++n2;
            }
        }
        file.delete();
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File source, File destination, File root, boolean overwrite) throws IOException {
        File sourceFile = new File(source, root.getPath());
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("Source: " + String.valueOf(sourceFile) + " does not exist");
        }
        File destinationFile = new File(destination, root.getPath());
        if (destinationFile.exists()) {
            if (!overwrite) throw new IOException("Destination: " + String.valueOf(destinationFile) + " already exists");
            FileUtils.deleteAll(destinationFile);
        }
        if (sourceFile.isDirectory()) {
            File[] list;
            destinationFile.mkdirs();
            File[] fileArray = list = sourceFile.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtils.copy(source, destination, new File(root, file.getName()), false);
                ++n2;
            }
            return;
        }
        destinationFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var7_15 = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
            try {
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destinationFile));){
                    FileUtils.copyStream(in, false, out, false);
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File[] inclusions, File[] exclusions, File destinationArchive, IPathComputer pathComputer) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fileOutput = new FileOutputStream(destinationArchive);
            try {
                try (ZipOutputStream output = new ZipOutputStream(fileOutput);){
                    HashSet<File> exclusionSet = exclusions == null ? new HashSet<File>() : new HashSet<File>(Arrays.asList(exclusions));
                    HashSet<IPath> directoryEntries = new HashSet<IPath>();
                    File[] fileArray = inclusions;
                    int n = inclusions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File inclusion = fileArray[n2];
                        pathComputer.reset();
                        FileUtils.zip(output, inclusion, exclusionSet, pathComputer, directoryEntries);
                        ++n2;
                    }
                }
                if (fileOutput == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileOutput == null) throw throwable;
                fileOutput.close();
                throw throwable;
            }
            fileOutput.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void zip(ZipOutputStream output, File source, Set<File> exclusions, IPathComputer pathComputer) throws IOException {
        FileUtils.zip(output, source, exclusions, pathComputer, new HashSet<IPath>());
    }

    public static void zip(ZipOutputStream output, File source, Set<File> exclusions, IPathComputer pathComputer, Set<IPath> directoryEntries) throws IOException {
        if (exclusions.contains(source)) {
            return;
        }
        if (source.isDirectory()) {
            FileUtils.zipDir(output, source, exclusions, pathComputer, directoryEntries);
        } else {
            FileUtils.zipFile(output, source, pathComputer, directoryEntries);
        }
    }

    private static void zipDirectoryEntry(ZipOutputStream output, IPath entry, long time, Set<IPath> directoryEntries) throws IOException {
        block13: {
            if (!directoryEntries.contains(entry = entry.addTrailingSeparator())) {
                if (entry.segmentCount() > 1) {
                    FileUtils.zipDirectoryEntry(output, entry.removeLastSegments(1), time, directoryEntries);
                }
                try {
                    try {
                        ZipEntry dirEntry = new ZipEntry(entry.toString());
                        dirEntry.setTime(time);
                        output.putNextEntry(dirEntry);
                        directoryEntries.add(entry);
                    }
                    catch (ZipException zipException) {
                        try {
                            output.closeEntry();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        output.closeEntry();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    output.closeEntry();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void zipDir(ZipOutputStream output, File source, Set<File> exclusions, IPathComputer pathComputer, Set<IPath> directoryEntries) throws IOException {
        File[] files = source.listFiles();
        if (files.length == 0) {
            FileUtils.zipDirectoryEntry(output, pathComputer.computePath(source), source.lastModified(), directoryEntries);
        }
        Arrays.sort(files, (arg0, arg1) -> {
            IPath a = IPath.fromOSString((String)arg0.getAbsolutePath());
            IPath b = IPath.fromOSString((String)arg1.getAbsolutePath());
            if (a.segmentCount() == b.segmentCount()) {
                if (arg0.isDirectory() && arg1.isFile()) {
                    return 1;
                }
                if (arg0.isDirectory() && arg1.isDirectory()) {
                    return 0;
                }
                if (arg0.isFile() && arg1.isDirectory()) {
                    return -1;
                }
                return 0;
            }
            return a.segmentCount() - b.segmentCount();
        });
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            FileUtils.zip(output, file, exclusions, pathComputer, directoryEntries);
            ++n2;
        }
    }

    private static void zipFile(ZipOutputStream output, File source, IPathComputer pathComputer, Set<IPath> directoryEntries) throws IOException {
        boolean isManifest;
        block24: {
            isManifest = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));){
                        IPath entryPath = pathComputer.computePath(source);
                        if (entryPath.isAbsolute()) {
                            throw new IOException(Messages.Util_Absolute_Entry);
                        }
                        if (entryPath.segmentCount() == 0) {
                            throw new IOException(Messages.Util_Empty_Zip_Entry);
                        }
                        if (entryPath.segmentCount() > 1 && !(isManifest = "META-INF/MANIFEST.MF".equals(entryPath.toString()))) {
                            FileUtils.zipDirectoryEntry(output, entryPath.removeLastSegments(1), source.lastModified(), directoryEntries);
                        }
                        ZipEntry zipEntry = new ZipEntry(entryPath.toString());
                        zipEntry.setTime(source.lastModified());
                        output.putNextEntry(zipEntry);
                        FileUtils.copyStream(input, true, output, false);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (ZipException zipException) {
                    try {
                        output.closeEntry();
                    }
                    catch (IOException iOException) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.closeEntry();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                output.closeEntry();
            }
            catch (IOException iOException) {}
        }
        if (isManifest) {
            FileUtils.zipDirectoryEntry(output, IPath.fromOSString((String)"META-INF"), source.lastModified(), directoryEntries);
        }
    }

    public static IPathComputer createRootPathComputer(final File root) {
        return new IPathComputer(){

            @Override
            public IPath computePath(File source) {
                IPath result = IPath.fromOSString((String)source.getAbsolutePath());
                IPath rootPath = IPath.fromOSString((String)root.getAbsolutePath());
                result = result.removeFirstSegments(rootPath.matchingFirstSegments(result));
                return result.setDevice(null);
            }

            @Override
            public void reset() {
            }
        };
    }

    public static IPathComputer createDynamicPathComputer(final int segmentsToKeep) {
        return new IPathComputer(){
            IPathComputer computer = null;

            @Override
            public IPath computePath(File source) {
                if (this.computer == null) {
                    IPath sourcePath = IPath.fromOSString((String)source.getAbsolutePath());
                    sourcePath = sourcePath.removeLastSegments(segmentsToKeep);
                    this.computer = FileUtils.createRootPathComputer(sourcePath.toFile());
                }
                return this.computer.computePath(source);
            }

            @Override
            public void reset() {
                this.computer = null;
            }
        };
    }

    public static IPathComputer createParentPrefixComputer(final int segmentsToKeep) {
        return new IPathComputer(){

            @Override
            public IPath computePath(File source) {
                IPath sourcePath = IPath.fromOSString((String)source.getAbsolutePath());
                sourcePath = sourcePath.removeFirstSegments(Math.max(0, sourcePath.segmentCount() - segmentsToKeep));
                return sourcePath.setDevice(null);
            }

            @Override
            public void reset() {
            }
        };
    }

    public static interface IPathComputer {
        public IPath computePath(File var1);

        public void reset();
    }
}

