/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class ZipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map<ZipEntry, List<ZipEntry>> children;
    private Map<IPath, ZipEntry> directoryEntryCache = new HashMap<IPath, ZipEntry>();
    private int stripLevel;
    private Set<String> invalidEntries = new HashSet<String>();

    public ZipLeveledStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
        this.stripLevel = 0;
    }

    protected ZipEntry createContainer(IPath pathname) {
        ZipEntry existingEntry = this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        if (pathname.segmentCount() == 0) {
            return null;
        }
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        ZipEntry newEntry = new ZipEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List<ZipEntry> parentChildList = this.children.get(parent);
        parentChildList.add(newEntry);
        return newEntry;
    }

    protected void createFile(ZipEntry entry) {
        IPath pathname = IPath.fromOSString((String)entry.getName());
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List<ZipEntry> childList = this.children.get(parent);
        childList.add(entry);
    }

    @Override
    public List<?> getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    @Override
    public InputStream getContents(Object element) {
        try {
            if (this.invalidEntries.contains(((ZipEntry)element).getName())) {
                throw new IOException("Cannot get content of Entry as it is outside of the target dir: " + ((ZipEntry)element).getName());
            }
            return this.zipFile.getInputStream((ZipEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private String stripPath(String path) {
        String pathOrig = path;
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    @Override
    public String getFullPath(Object element) {
        return this.stripPath(((ZipEntry)element).getName());
    }

    @Override
    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((ZipEntry)element).getName();
        }
        return this.stripPath(IPath.fromOSString((String)((ZipEntry)element).getName()).lastSegment());
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public boolean closeArchive() {
        try {
            this.getZipFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(DataTransferMessages.ZipImport_couldNotClose + this.getZipFile().getName(), e);
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.closeArchive();
    }

    protected void initialize() {
        this.children = new HashMap<ZipEntry, List<ZipEntry>>(1000);
        IPath zipFileDirPath = IPath.fromOSString((String)this.zipFile.getName()).removeLastSegments(1);
        Object canonicalDestinationDirPath = zipFileDirPath.toString();
        File zipDestinationDir = new File(zipFileDirPath.toString());
        try {
            canonicalDestinationDirPath = zipDestinationDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        this.children.put(this.root, new ArrayList());
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        if (!((String)canonicalDestinationDirPath).endsWith(File.separator)) {
            canonicalDestinationDirPath = (String)canonicalDestinationDirPath + File.separator;
        }
        while (entries.hasMoreElements()) {
            try {
                ZipEntry entry = entries.nextElement();
                File destinationfile = new File(zipDestinationDir, entry.getName());
                String canonicalDestinationFile = destinationfile.getCanonicalPath();
                if (!canonicalDestinationFile.startsWith((String)canonicalDestinationDirPath)) {
                    this.invalidEntries.add(entry.getName());
                    throw new IOException("Entry is outside of the target dir: " + entry.getName());
                }
                IPath path = IPath.fromOSString((String)entry.getName()).addTrailingSeparator();
                if (entry.isDirectory()) {
                    this.createContainer(path);
                    continue;
                }
                int pathSegmentCount = path.segmentCount();
                if (pathSegmentCount > 1) {
                    this.createContainer(path.uptoSegment(pathSegmentCount - 1));
                }
                this.createFile(entry);
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public boolean isFolder(Object element) {
        return ((ZipEntry)element).isDirectory();
    }

    @Override
    public void setStrip(int level) {
        this.stripLevel = level;
    }

    @Override
    public int getStrip() {
        return this.stripLevel;
    }
}

