/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    final boolean isOnModulePath;
    protected static final Map<String, PackageCacheEntry> packageCache = new ConcurrentHashMap<String, PackageCacheEntry>();
    final String zipFilename;
    final IFile resource;
    protected volatile ZipFile zipFile;
    volatile long lastModified;
    volatile long fileSize;
    private volatile Set<String> knownPackageNames;
    String compliance;

    protected static void addToPackageSet(Set<String> packageSet, String fileName, boolean endsWithSep) {
        int last = endsWithSep ? fileName.length() : fileName.lastIndexOf(47);
        while (last > 0) {
            String packageName = fileName.substring(0, last);
            if (!packageSet.add(packageName)) {
                return;
            }
            last = packageName.lastIndexOf(47);
        }
    }

    private Set<String> getCachedPackageNames() {
        PackageCacheEntry entry = packageCache.compute(this.zipFilename, (zipFileName, cacheEntry) -> {
            if (cacheEntry != null && cacheEntry.zipFile.get() == this.zipFile) {
                return cacheEntry;
            }
            long timestamp = this.lastModified();
            if (cacheEntry != null && cacheEntry.lastModified == timestamp && cacheEntry.fileSize == this.fileSize) {
                return new PackageCacheEntry(new WeakReference<ZipFile>(this.zipFile), cacheEntry.lastModified, cacheEntry.fileSize, cacheEntry.packageSet);
            }
            return new PackageCacheEntry(new WeakReference<ZipFile>(this.zipFile), timestamp, this.fileSize, Set.copyOf(this.readPackageNames()));
        });
        return entry.packageSet;
    }

    protected Set<String> readPackageNames() {
        HashSet<String> packageSet = new HashSet<String>();
        packageSet.add("");
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            if (fileName.startsWith("META-INF/")) continue;
            ClasspathJar.addToPackageSet(packageSet, fileName, false);
        }
        return packageSet;
    }

    IModule initializeModule() {
        IBinaryModule mod = null;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile file = new ZipFile(this.zipFilename);){
                ClassFileReader classfile;
                block15: {
                    String releasePath = "META-INF/versions/" + this.compliance + "/module-info.class";
                    classfile = null;
                    try {
                        classfile = ClassFileReader.read((ZipFile)file, (String)releasePath);
                    }
                    catch (Exception e) {
                        if (!JavaModelManager.VERBOSE) break block15;
                        JavaModelManager.trace("", e);
                    }
                }
                if (classfile == null) {
                    classfile = ClassFileReader.read((ZipFile)file, (String)"module-info.class");
                }
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException throwable) {}
        return mod;
    }

    ClasspathJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        String filename;
        this.resource = resource;
        try {
            URI location = resource.getLocationURI();
            if (location == null) {
                filename = "";
            } else {
                File localFile = Util.toLocalFile(location, null);
                filename = localFile.getPath();
            }
        }
        catch (CoreException coreException) {
            filename = "";
        }
        this.zipFilename = filename;
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.isOnModulePath = isOnModulePath;
    }

    ClasspathJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this.resource = null;
        this.zipFilename = zipFilename;
        this.lastModified = lastModified;
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.isOnModulePath = isOnModulePath;
    }

    public ClasspathJar(ZipFile zipFile, AccessRuleSet accessRuleSet, boolean isOnModulePath) {
        this(zipFile.getName(), 0L, accessRuleSet, null, isOnModulePath);
        this.zipFile = zipFile;
    }

    @Override
    public void cleanup() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [ClasspathJar.cleanup()] Closed ZipFile on " + this.zipFilename);
                }
            }
            catch (IOException e) {
                JavaCore.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error closing " + this.zipFile.getName(), (Throwable)e));
            }
            this.zipFile = null;
        }
        if (this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [ClasspathJar.cleanup()] Closed Annotation ZipFile on " + this.zipFilename);
                }
            }
            catch (IOException e) {
                JavaCore.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error closing " + this.annotationZipFile.getName(), (Throwable)e));
            }
            this.annotationZipFile = null;
        }
        this.module = null;
        this.knownPackageNames = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        ClasspathJar jar = (ClasspathJar)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals((Object)jar.accessRuleSet))) {
            return false;
        }
        if (!Util.equalOrNull(this.compliance, jar.compliance)) {
            return false;
        }
        return this.zipFilename.equals(jar.zipFilename) && this.lastModified() == jar.lastModified() && this.isOnModulePath == jar.isOnModulePath && this.areAllModuleOptionsEqual(jar);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
            if (reader != null) {
                char[] modName;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, modName);
            }
        }
        catch (IOException | ClassFormatException throwable) {}
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public int hashCode() {
        return this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return false;
        }
        if (this.knownPackageNames == null) {
            this.readKnownPackageNames();
        }
        return this.knownPackageNames.contains(qualifiedPackageName);
    }

    @Override
    public boolean hasCompilationUnit(String pkgName, String moduleName) {
        if (this.readKnownPackageNames()) {
            if (!this.knownPackageNames.contains(pkgName)) {
                return false;
            }
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                String fileName = e.nextElement().getName();
                if (!fileName.startsWith(pkgName) || !fileName.toLowerCase().endsWith(".class") || fileName.indexOf(47, pkgName.length() + 1) != -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean readKnownPackageNames() {
        try {
            if (this.zipFile == null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [ClasspathJar.isPackage(String)] Creating ZipFile on " + this.zipFilename);
                }
                this.zipFile = new ZipFile(this.zipFilename);
            }
            this.knownPackageNames = this.getCachedPackageNames();
            return true;
        }
        catch (Exception exception) {
            this.knownPackageNames = Set.of();
            return false;
        }
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            long lastMod = -1L;
            long size = -1L;
            try {
                BasicFileAttributes attributes = Files.readAttributes(Path.of(this.zipFilename, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
                lastMod = attributes.lastModifiedTime().toMillis();
                size = attributes.size();
            }
            catch (IOException iOException) {}
            this.lastModified = lastMod;
            this.fileSize = size;
        }
        return this.lastModified;
    }

    public String toString() {
        String start = "Classpath jar file " + this.zipFilename;
        if (this.accessRuleSet == null) {
            return start;
        }
        return start + " with " + String.valueOf(this.accessRuleSet);
    }

    @Override
    public String debugPathString() {
        long time = this.lastModified();
        if (time == 0L) {
            return this.zipFilename;
        }
        return this.zipFilename + "(" + String.valueOf(new Date(time)) + " : " + time + ")";
    }

    @Override
    public IModule getModule() {
        if (this.knownPackageNames == null) {
            this.readKnownPackageNames();
        }
        return this.module;
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false, null);
    }

    public Manifest getManifest() {
        if (!this.readKnownPackageNames()) {
            return null;
        }
        ZipEntry entry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = this.zipFile.getInputStream(entry);){
                return new Manifest(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public char[][] listPackages() {
        if (!this.readKnownPackageNames()) {
            return null;
        }
        char[][] result = new char[this.knownPackageNames.size() - 1][];
        int count = 0;
        for (String string : this.knownPackageNames) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string.replace('/', '.').toCharArray();
        }
        if (count < result.length) {
            return (char[][])Arrays.copyOf(result, count);
        }
        return result;
    }

    @Override
    protected IBinaryType decorateWithExternalAnnotations(IBinaryType reader, String fileNameWithoutExtension) {
        String qualifiedBinaryFileName;
        ZipEntry entry;
        if (this.readKnownPackageNames() && (entry = this.zipFile.getEntry(qualifiedBinaryFileName = fileNameWithoutExtension + ".eea")) != null) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream is = this.zipFile.getInputStream(entry);){
                    return new ExternalAnnotationDecorator(reader, new ExternalAnnotationProvider(is, fileNameWithoutExtension));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return reader;
    }

    private static final class PackageCacheEntry
    extends Record {
        private final WeakReference<ZipFile> zipFile;
        private final long lastModified;
        private final long fileSize;
        private final Set<String> packageSet;

        public WeakReference<ZipFile> zipFile() {
            return this.zipFile;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public Set<String> packageSet() {
            return this.packageSet;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackageCacheEntry.class, "zipFile;lastModified;fileSize;packageSet", "zipFile", "lastModified", "fileSize", "packageSet"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackageCacheEntry.class, "zipFile;lastModified;fileSize;packageSet", "zipFile", "lastModified", "fileSize", "packageSet"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackageCacheEntry.class, "zipFile;lastModified;fileSize;packageSet", "zipFile", "lastModified", "fileSize", "packageSet"}, this, object);
        }

        private PackageCacheEntry(WeakReference<ZipFile> weakReference, long l, long l2, Set<String> set) {
            this.zipFile = weakReference;
            this.lastModified = l;
            this.fileSize = l2;
            this.packageSet = set;
        }
    }
}

