/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;

public class LineNumberProvider {
    private Hashtable<ReferenceBinding, Vector<LineInfo>> _sourceToLineInfos;
    private int _sourceEndLineNumber;
    private int _currentEndLineNumber;
    private ReferenceBinding _referenceBinding;
    HashMap<ReferenceBinding, HashMap<Integer, Integer>> remapped = new HashMap();

    public LineNumberProvider(ReferenceBinding referenceBinding, int sourceEndLineNumber) {
        this._referenceBinding = referenceBinding;
        this._sourceEndLineNumber = sourceEndLineNumber;
        this._currentEndLineNumber = sourceEndLineNumber;
        this._sourceToLineInfos = new Hashtable();
    }

    public LineInfo getRemappedLineNumber(ReferenceBinding copySrc, List<LineInfo> lineInfos, Integer inputStartLine, int repeatCount) {
        int remappedLineNumber;
        LineInfo lineInfo2;
        HashMap<Integer, Integer> srcRemapped = this.remapped.get(copySrc);
        if (srcRemapped != null) {
            Integer exist = srcRemapped.get(inputStartLine);
            if (exist != null) {
                for (LineInfo lineInfo2 : lineInfos) {
                    if (lineInfo2.getOutputStartLine() != exist.intValue() || lineInfo2.getRepeatCount() < repeatCount) continue;
                    return lineInfo2;
                }
            }
        } else {
            srcRemapped = new HashMap();
            this.remapped.put(copySrc, srcRemapped);
        }
        this._currentEndLineNumber = remappedLineNumber = this._currentEndLineNumber + 1;
        if (repeatCount > 1) {
            this._currentEndLineNumber += repeatCount - 1;
        }
        srcRemapped.put(inputStartLine, remappedLineNumber);
        lineInfo2 = new LineInfo(inputStartLine, remappedLineNumber);
        if (repeatCount > -1) {
            lineInfo2.setRepeatCount(repeatCount);
        }
        lineInfos.add(lineInfo2);
        return lineInfo2;
    }

    public LineInfo addLineInfo(ReferenceBinding copySrc, int inputStartLine, int repeatCount, boolean isSynthetic) {
        boolean generateSynthetic;
        if (!this._sourceToLineInfos.containsKey(copySrc)) {
            this._sourceToLineInfos.put(copySrc, new Vector());
        }
        List lineInfos = this._sourceToLineInfos.get(copySrc);
        boolean bl = generateSynthetic = isSynthetic || TypeBinding.notEquals(copySrc, this._referenceBinding);
        if (generateSynthetic && inputStartLine < 65533) {
            return this.getRemappedLineNumber(copySrc, lineInfos, inputStartLine, repeatCount);
        }
        int outputStartLine = inputStartLine;
        LineInfo lineInfo = new LineInfo(inputStartLine, outputStartLine);
        if (repeatCount > -1) {
            lineInfo.setRepeatCount(repeatCount);
        }
        lineInfos.add(lineInfo);
        return lineInfo;
    }

    public Hashtable<ReferenceBinding, Vector<LineInfo>> getLineInfos() {
        return this._sourceToLineInfos;
    }

    public List<LineInfo> getLineInfosForType(Object key) {
        return this._sourceToLineInfos.get(key);
    }

    public int getSourceEndLineNumber() {
        return this._sourceEndLineNumber;
    }

    public boolean containsLineInfos() {
        return this._sourceToLineInfos.size() > 0;
    }

    public void setRepeatCount(LineInfo lineInfo, int count) {
        lineInfo.setRepeatCount(count);
        this._currentEndLineNumber = Math.max(this._currentEndLineNumber, lineInfo.getOutputStartLine() + count - 1);
    }
}

