/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.service.packageadmin.PackageAdmin;

@NonNullByDefault
public class BaseBundleLoadTrigger {
    private AspectBindingRegistry aspectBindingRegistry;
    private @Nullable PackageAdmin admin;
    private String baseBundleName;
    private @Nullable AspectBinding.BaseBundle baseBundle;
    private List<AspectBinding> aspectBindings = new ArrayList<AspectBinding>();

    public BaseBundleLoadTrigger(String bundleSymbolicName, @Nullable AspectBinding.BaseBundle baseBundle, AspectBindingRegistry aspectBindingRegistry, @Nullable PackageAdmin admin) {
        this.baseBundleName = bundleSymbolicName;
        this.baseBundle = baseBundle;
        this.aspectBindingRegistry = aspectBindingRegistry;
        this.admin = admin;
    }

    OTWeavingHook.WeavingScheme getWeavingScheme() {
        @NonNull OTWeavingHook.WeavingScheme scheme = OTWeavingHook.DEFAULT_WEAVING_SCHEME;
        for (AspectBinding aspectBinding : this.aspectBindings) {
            if (aspectBinding.weavingScheme == OTWeavingHook.WeavingScheme.Unknown) continue;
            scheme = aspectBinding.weavingScheme;
            if (OTWeavingHook.DEFAULT_WEAVING_SCHEME != OTWeavingHook.WeavingScheme.Unknown) break;
            OTWeavingHook.DEFAULT_WEAVING_SCHEME = scheme;
            TransformerPlugin.doLog(1, "Using weaving scheme " + String.valueOf((Object)scheme) + " as detected from aspect bundle " + aspectBinding.aspectPlugin);
            break;
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(WovenClass baseClass, Set<String> beingDefined, OTWeavingHook hook) {
        OTWeavingHook.WeavingScheme weavingScheme = this.getWeavingScheme();
        Object object = this;
        synchronized (object) {
            BaseBundleLoadTrigger.addOTREImport(this.baseBundleName, baseClass, weavingScheme == OTWeavingHook.WeavingScheme.OTDRE);
        }
        object = this.aspectBindings;
        synchronized (object) {
            if (this.aspectBindings.isEmpty()) {
                this.aspectBindings.addAll(this.aspectBindingRegistry.getAdaptingAspectBindings(this.baseBundleName));
            }
        }
        ArrayList<WaitingTeamRecord> deferredTeamClasses = new ArrayList<WaitingTeamRecord>();
        for (AspectBinding aspectBinding : this.aspectBindings) {
            PackageAdmin admin2;
            if (!aspectBinding.hasScannedTeams) {
                TransformerPlugin.log(1, "Preparing aspect binding for base bundle " + this.baseBundleName);
            }
            if ((admin2 = this.admin) == null) {
                TransformerPlugin.log(4, "Cannot find aspect bundle " + aspectBinding.aspectPlugin);
                continue;
            }
            Bundle aspectBundle = aspectBinding.aspectBundle;
            if (aspectBundle == null) {
                Bundle[] aspectBundles = admin2.getBundles(aspectBinding.aspectPlugin, null);
                if (aspectBundles == null || aspectBundles.length == 0) {
                    TransformerPlugin.log(4, "Cannot find aspect bundle " + aspectBinding.aspectPlugin);
                    continue;
                }
                aspectBundle = aspectBundles[0];
                assert (aspectBundle != null) : "Package admin should not return a null array element";
            }
            if (!aspectBinding.hasScannedTeams) {
                Collection<String> boundBases = aspectBinding.scanTeamClasses(aspectBundle, DelegatingTransformer.newTransformer(weavingScheme, hook, baseClass.getBundleWiring()));
                this.aspectBindingRegistry.addBoundBaseClasses(boundBases);
            }
            if (weavingScheme != OTWeavingHook.WeavingScheme.OTRE) continue;
            aspectBinding.addImports(baseClass);
        }
        TeamLoader loading = new TeamLoader(deferredTeamClasses, beingDefined, weavingScheme == OTWeavingHook.WeavingScheme.OTDRE);
        AspectBinding.BaseBundle baseBundle3 = this.baseBundle;
        if (baseBundle3 != null) {
            loading.loadTeamsForBase(baseBundle3, baseClass, hook.getAspectPermissionManager());
        }
        if (!deferredTeamClasses.isEmpty()) {
            hook.addDeferredTeamClasses(deferredTeamClasses);
        }
        for (AspectBinding aspectBinding : this.aspectBindings) {
            String baseClassName = baseClass.getClassName();
            assert (baseClassName != null) : "WovenClass.getClassName() should not answer null";
            aspectBinding.cleanUp(baseClassName);
        }
    }

    static void addOTREImport(String baseBundleName, WovenClass baseClass, boolean useDynamicWeaver) {
        TransformerPlugin.log(1, "Adding OTRE import to " + baseBundleName);
        List imports = baseClass.getDynamicImports();
        imports.add("org.objectteams");
        if (useDynamicWeaver) {
            imports.add("org.eclipse.objectteams.otredyn.runtime");
        }
    }

    public boolean isDone() {
        for (AspectBinding binding : this.aspectBindings) {
            if (binding.isDone()) continue;
            return false;
        }
        return true;
    }

    public boolean areAllAspectsDenied() {
        for (AspectBinding binding : this.aspectBindings) {
            if (binding.hasBeenDenied) continue;
            return false;
        }
        return true;
    }
}

