/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.IParallelizable;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class PatternSearchJob
implements IJob {
    protected final SearchPattern pattern;
    protected final IJavaSearchScope scope;
    protected final SearchParticipant participant;
    protected final IndexQueryRequestor requestor;
    protected final boolean resolveDocumentForJar;
    protected final boolean resolveDocumentForSourceFiles;
    protected volatile boolean areIndexesReady;
    protected final AtomicLong executionTime = new AtomicLong(0L);
    public static final String ENABLE_PARALLEL_SEARCH = "enableParallelJavaIndexSearch";
    public static final boolean ENABLE_PARALLEL_SEARCH_DEFAULT = true;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this(pattern, participant, scope, true, true, requestor);
    }

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentForJar, boolean resolveDocumentForSourceFiles, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
        this.resolveDocumentForJar = resolveDocumentForJar;
        this.resolveDocumentForSourceFiles = resolveDocumentForSourceFiles;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
        boolean isComplete = true;
        this.executionTime.set(0L);
        long startTime = System.currentTimeMillis();
        Index[] indexes = this.getIndexes((IProgressMonitor)subMonitor.split(1));
        try {
            int max = indexes.length;
            SubMonitor loopMonitor = subMonitor.split(2).setWorkRemaining(max);
            boolean parallel = this.canRunInParallel();
            if (parallel) {
                isComplete = this.performParallelSearch(indexes, loopMonitor);
            } else {
                int i = 0;
                while (i < max) {
                    isComplete &= this.search(indexes[i], this.requestor, (IProgressMonitor)loopMonitor.split(1), parallel);
                    ++i;
                }
            }
            if (JobManager.VERBOSE) {
                if (parallel) {
                    long wallClockTime = System.currentTimeMillis() - startTime;
                    JavaModelManager.trace("-> execution time: " + wallClockTime + "ms - " + String.valueOf(this));
                    JavaModelManager.trace("-> cumulative execution time (" + ForkJoinPool.getCommonPoolParallelism() + "): " + this.executionTime.get() + "ms - " + String.valueOf(this));
                } else {
                    JavaModelManager.trace("-> execution time: " + this.executionTime.get() + "ms - " + String.valueOf(this));
                }
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            SubMonitor.done((IProgressMonitor)progressMonitor);
        }
    }

    private boolean performParallelSearch(Index[] indexes, SubMonitor loopMonitor) {
        boolean isComplete = true;
        ArrayList<Future> futures = new ArrayList<Future>(indexes.length);
        ForkJoinPool commonPool = ForkJoinPool.commonPool();
        ParallelSearchMonitor monitor = new ParallelSearchMonitor((IProgressMonitor)loopMonitor);
        try {
            if (this.scope instanceof IParallelizable) {
                ((IParallelizable)((Object)this.scope)).initBeforeSearch((IProgressMonitor)monitor);
            }
            Index[] indexArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                Index index = indexArray[n2];
                futures.add(commonPool.submit(() -> this.search(index, (IProgressMonitor)monitor, true)));
                ++n2;
            }
            for (Future future : futures) {
                loopMonitor.split(1);
                try {
                    IndexResult result = (IndexResult)future.get();
                    isComplete &= result.complete;
                    result.matches.forEach(m -> {
                        boolean continueSearch = this.requestor.acceptIndexMatch(m.documentPath, m.indexRecord, this.participant, m.access);
                        if (!continueSearch) {
                            throw new OperationCanceledException();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new OperationCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        catch (JavaModelException e) {
            monitor.setCanceled(true);
            throw new RuntimeException("Error initializing scope: " + String.valueOf(this.scope), (Throwable)((Object)e));
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            throw e;
        }
        return isComplete;
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        int length;
        IndexLocation[] indexLocations;
        if (this.participant instanceof JavaSearchParticipant) {
            indexLocations = ((JavaSearchParticipant)this.participant).selectIndexURLs(this.pattern, this.scope);
            length = indexLocations.length;
        } else {
            IPath[] paths = this.participant.selectIndexes(this.pattern, this.scope);
            length = paths.length;
            indexLocations = new IndexLocation[paths.length];
            int i = 0;
            int len = paths.length;
            while (i < len) {
                indexLocations[i] = new FileIndexLocation(paths[i].toFile(), true);
                ++i;
            }
        }
        Index[] indexes = JavaModelManager.getIndexManager().getIndexes(indexLocations, progressMonitor);
        this.areIndexesReady = indexes.length == length;
        return indexes;
    }

    @Override
    public boolean waitNeeded() {
        return true;
    }

    @Override
    public String getJobFamily() {
        return "";
    }

    private IndexResult search(Index index, IProgressMonitor progressMonitor, boolean parallel) {
        ArrayList<IndexMatch> matches = new ArrayList<IndexMatch>();
        boolean complete = this.search(index, PatternSearchJob.collectTo(matches, progressMonitor), progressMonitor, parallel);
        return new IndexResult(complete, matches);
    }

    public boolean search(Index index, IndexQueryRequestor queryRequestor, IProgressMonitor progressMonitor, boolean parallel) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            boolean isFromJar;
            boolean resolveDocumentName;
            monitor.enterRead();
            long start = System.currentTimeMillis();
            SearchPattern searchPattern = this.pattern;
            IJavaSearchScope searchScope = this.scope;
            if (parallel) {
                searchPattern = PatternSearchJob.clone(searchPattern);
                searchScope = PatternSearchJob.clone(searchScope);
            }
            boolean bl = resolveDocumentName = (isFromJar = index.isIndexForJar()) && this.resolveDocumentForJar || !isFromJar && this.resolveDocumentForSourceFiles;
            if (resolveDocumentName) {
                MatchLocator.findIndexMatches(searchPattern, index, queryRequestor, this.participant, searchScope, progressMonitor);
            } else {
                MatchLocator.findIndexMatches(searchPattern, index, queryRequestor, this.participant, searchScope, false, progressMonitor);
            }
            this.executionTime.addAndGet(System.currentTimeMillis() - start);
            return true;
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                if (JavaModelManager.VERBOSE) {
                    JavaModelManager.trace("", e);
                }
            } else {
                Throwable cause = e.getCause();
                if (cause != null) {
                    Util.log(e, "Search failed for index " + String.valueOf(index));
                }
            }
            return false;
        }
        finally {
            monitor.exitRead();
        }
    }

    private static IJavaSearchScope clone(IJavaSearchScope searchScope) {
        if (searchScope instanceof AbstractSearchScope) {
            try {
                searchScope = ((AbstractSearchScope)searchScope).clone();
            }
            catch (CloneNotSupportedException e) {
                Util.log((IStatus)new Status(2, "org.eclipse.jdt.core", "PatternSearchJob could not clone " + String.valueOf(searchScope), (Throwable)e));
            }
        }
        return searchScope;
    }

    private static SearchPattern clone(SearchPattern searchPattern) {
        if (searchPattern instanceof Cloneable) {
            try {
                searchPattern = searchPattern.clone();
            }
            catch (CloneNotSupportedException e) {
                Util.log((IStatus)new Status(2, "org.eclipse.jdt.core", "PatternSearchJob could not clone " + String.valueOf(searchPattern), (Throwable)e));
            }
        }
        return searchPattern;
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }

    private boolean canRunInParallel() {
        return this.isParallelSearchEnabled() && IParallelizable.isParallelSearchSupported(this.scope) && IParallelizable.isParallelSearchSupported(this.participant) && IParallelizable.isParallelSearchSupported(this.pattern);
    }

    private boolean isParallelSearchEnabled() {
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService == null) {
            return true;
        }
        return preferenceService.getBoolean("org.eclipse.jdt.core", ENABLE_PARALLEL_SEARCH, true, null);
    }

    private static IndexQueryRequestor collectTo(final List<IndexMatch> collectTo, final IProgressMonitor monitor) {
        return new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                collectTo.add(new IndexMatch(documentPath, indexRecord, access));
                return !monitor.isCanceled();
            }
        };
    }

    static class IndexMatch {
        final String documentPath;
        final SearchPattern indexRecord;
        final AccessRuleSet access;

        IndexMatch(String documentPath, SearchPattern indexRecord, AccessRuleSet access) {
            this.documentPath = documentPath;
            this.indexRecord = indexRecord;
            this.access = access;
        }
    }

    static class IndexResult {
        final boolean complete;
        final List<IndexMatch> matches;

        IndexResult(boolean complete, List<IndexMatch> matches) {
            this.complete = complete;
            this.matches = matches;
        }
    }

    static class ParallelSearchMonitor
    extends NullProgressMonitor {
        private volatile boolean canceled;
        private final IProgressMonitor original;

        public ParallelSearchMonitor(IProgressMonitor original) {
            this.original = original;
        }

        public boolean isCanceled() {
            return this.canceled || this.original.isCanceled();
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }
}

