/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.FileInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SmapStratum;

public abstract class AbstractSmapGenerator {
    protected TypeDeclaration _type;
    protected List<SmapStratum> _strata;
    private String _defaultStratum;
    private static String DEFAULT_PACKAGE = "";

    public AbstractSmapGenerator(TypeDeclaration type) {
        this._type = type;
        this._strata = new ArrayList<SmapStratum>();
    }

    public void addStratum(String stratum) {
        this._strata.add(new SmapStratum(stratum));
    }

    public abstract char[] generate();

    public String getSMAP() {
        String generatedFileName = this.getClassFileNameForType(this._type);
        StringBuffer out = new StringBuffer();
        out.append("SMAP\n");
        out.append(generatedFileName + "\n");
        if (this._defaultStratum != null) {
            out.append(this._defaultStratum + "\n");
        } else {
            out.append("OTJ\n");
        }
        int idx = 0;
        while (idx < this._strata.size()) {
            SmapStratum stratum = this._strata.get(idx);
            if (stratum.hasFileInfos()) {
                stratum.optimize();
                out.append(stratum.getSmapAsString());
            }
            ++idx;
        }
        out.append("*E");
        return out.toString();
    }

    private String getClassFileNameForType(TypeDeclaration type) {
        String generatedFileName = String.valueOf(type.binding.getRealClass().constantPoolName()) + ".class";
        String[] tmp = generatedFileName.split("/");
        if (tmp.length > 0) {
            return tmp[tmp.length - 1];
        }
        return generatedFileName;
    }

    public List<SmapStratum> getStrata() {
        return this._strata;
    }

    public void setDefaultStratum(String defaultStratum) {
        this._defaultStratum = defaultStratum;
    }

    protected ReferenceBinding getCUType(ReferenceBinding type) {
        ReferenceBinding currentType = type;
        ReferenceBinding enclosingType = type.enclosingType();
        while (currentType.roleModel == null || !currentType.roleModel.isRoleFile()) {
            enclosingType = currentType.enclosingType();
            if (enclosingType == null) {
                return currentType;
            }
            currentType = enclosingType;
        }
        return currentType;
    }

    protected String getPackagePathFromRefBinding(ReferenceBinding toplevelBinding) {
        PackageBinding pkgBinding = null;
        if (toplevelBinding.enclosingType() != null) {
            pkgBinding = toplevelBinding.enclosingType().teamPackage;
        }
        if (pkgBinding == null) {
            pkgBinding = toplevelBinding.getPackage();
        }
        String pkgName = String.valueOf(pkgBinding.readableName());
        if ((pkgName = pkgName.replace('.', '/')) != null && pkgName.length() > 0) {
            return pkgName + "/";
        }
        return DEFAULT_PACKAGE;
    }

    protected FileInfo getOrCreateFileInfoForType(SmapStratum stratum, ReferenceBinding typeBinding) {
        String sourceName = String.valueOf(typeBinding.sourceName()) + ".java";
        String absoluteSourceName = this.getPackagePathFromRefBinding(typeBinding) + sourceName;
        return stratum.getOrCreateFileInfo(sourceName, absoluteSourceName);
    }
}

