/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TsuperReference
extends ThisReference {
    public TypeReference qualification;

    public TsuperReference(int pos, int sourceEnd) {
        super(pos, sourceEnd);
        this.sourceStart = pos;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public boolean isSuper() {
        return false;
    }

    @Override
    public boolean isThis() {
        return true;
    }

    public boolean checkAccess(MethodScope methodScope) {
        SourceTypeBinding roleType = methodScope.enclosingSourceType();
        return roleType.isDirectRole();
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        if (!this.isImplicitThis() && !this.checkAccess(scope.methodScope())) {
            return null;
        }
        SourceTypeBinding enclosingRole = scope.enclosingSourceType();
        if (this.qualification == null) {
            this.resolvedType = enclosingRole.roleModel.getTSuperRoleBinding();
            return this.resolvedType;
        }
        TypeBinding qualifyingType = this.qualification.resolveType(scope);
        if (qualifyingType != null && qualifyingType instanceof ReferenceBinding) {
            ReferenceBinding qualRef = (ReferenceBinding)qualifyingType;
            ReferenceBinding[] tsuperRoles = enclosingRole.roleModel.getTSuperRoleBindings();
            ReferenceBinding superRole = this.selectTSuper(qualRef, tsuperRoles);
            if (superRole == null) {
                scope.problemReporter().invalidQualifiedTSuper(this, qualRef.superclass(), enclosingRole);
                return null;
            }
            this.resolvedType = superRole;
            return this.resolvedType;
        }
        return null;
    }

    private ReferenceBinding selectTSuper(ReferenceBinding qualifyingType, ReferenceBinding[] tsupers) {
        ReferenceBinding superTeam = qualifyingType.getRealClass().superclass();
        int i = tsupers.length - 1;
        while (i >= 0) {
            if (this.contains(superTeam, tsupers[i])) {
                return tsupers[i];
            }
            --i;
        }
        return null;
    }

    private boolean contains(ReferenceBinding outer, ReferenceBinding inner) {
        ReferenceBinding current = inner.enclosingType();
        while (current != null) {
            if (TypeBinding.equalsEquals(current, outer)) {
                return true;
            }
            current = current.enclosingType();
        }
        return false;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        if (this.qualification != null) {
            this.qualification.printExpression(indent, output);
            output.append(".");
        }
        output.append("tsuper");
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

