/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MultiCatchExceptionLabel
extends ExceptionLabel {
    ExceptionLabel[] exceptionLabels;

    public MultiCatchExceptionLabel(CodeStream codeStream, TypeBinding exceptionType) {
        super(codeStream, exceptionType);
    }

    public void initialize(UnionTypeReference typeReference, Annotation[] annotations) {
        TypeReference[] typeReferences = typeReference.typeReferences;
        int length = typeReferences.length;
        this.exceptionLabels = new ExceptionLabel[length];
        int i = 0;
        while (i < length) {
            this.exceptionLabels[i] = new ExceptionLabel(this.codeStream, typeReferences[i].resolvedType, typeReferences[i], (Annotation[])(i == 0 ? annotations : null));
            ++i;
        }
    }

    @Override
    public void place() {
        ExceptionLabel[] exceptionLabelArray = this.exceptionLabels;
        int n = this.exceptionLabels.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n2];
            exceptionLabel.place();
            ++n2;
        }
    }

    @Override
    public void placeEnd() {
        ExceptionLabel[] exceptionLabelArray = this.exceptionLabels;
        int n = this.exceptionLabels.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n2];
            exceptionLabel.placeEnd();
            ++n2;
        }
    }

    @Override
    public void placeStart() {
        ExceptionLabel[] exceptionLabelArray = this.exceptionLabels;
        int n = this.exceptionLabels.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n2];
            exceptionLabel.placeStart();
            ++n2;
        }
    }

    @Override
    public int getCount() {
        int temp = 0;
        ExceptionLabel[] exceptionLabelArray = this.exceptionLabels;
        int n = this.exceptionLabels.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n2];
            temp += exceptionLabel.getCount();
            ++n2;
        }
        return temp;
    }

    public int getAllAnnotationContexts(int tableIndex, List allTypeAnnotationContexts) {
        int localCount = 0;
        int i = 0;
        int max = this.exceptionLabels.length;
        while (i < max) {
            ExceptionLabel exceptionLabel = this.exceptionLabels[i];
            if (exceptionLabel.exceptionTypeReference != null) {
                exceptionLabel.exceptionTypeReference.getAllAnnotationContexts(66, tableIndex + localCount, allTypeAnnotationContexts);
            }
            ++tableIndex;
            ++i;
        }
        return localCount;
    }
}

