/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseAllocationExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.InsertTypeAdjustmentsVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public TypeParameter[] typeParameters;
    private boolean isCodeAnalyzed = false;
    public boolean needsLifting = false;
    private ExceptionHandlingFlowContext prologueContext;
    private FlowInfo prologueInfo;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    FlowInfo getPrologueInfo() {
        if (this.prologueInfo != null) {
            return this.prologueInfo;
        }
        return new UnconditionalFlowInfo();
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode) {
        this.analyseCode(classScope, initializerFlowContext, flowInfo, initialReachMode, this.prologueInfo != null ? AnalysisMode.REST : AnalysisMode.ALL);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode, AnalysisMode mode) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isGenerated && this.statements == null) {
            return;
        }
        if (this.isCodeAnalyzed) {
            return;
        }
        this.isCodeAnalyzed = mode == AnalysisMode.ALL || mode == AnalysisMode.REST;
        SourceTypeBinding roleType = this.scope.enclosingSourceType();
        if (this.isCopied) {
            if (MethodModel.callsBaseCtor(this.binding.copyInheritanceSrc)) {
                MethodModel.setCallsBaseCtor(this);
            }
            if (this.arguments == null && !MethodModel.callsBaseCtor(this.binding) && roleType.baseclass() != null) {
                MethodModel.getModel((AbstractMethodDeclaration)this).problemDetail = MethodModel.ProblemDetail.IllegalDefaultCtor;
                this.isGenerated = true;
            }
            return;
        }
        if (roleType.baseclass() != null && this.constructorCall != null) {
            ReferenceBinding createdBase;
            ReferenceBinding requiredBase;
            MethodBinding selfCall = this.constructorCall.binding;
            if (TypeBinding.equalsEquals(selfCall.declaringClass, this.binding.declaringClass)) {
                ((ConstructorDeclaration)selfCall.sourceMethod()).analyseCode(classScope, initializerFlowContext, flowInfo.copy(), flowInfo.reachMode());
            }
            boolean calledHere = MethodModel.callsBaseCtor(this.binding);
            boolean calledIndirectly = MethodModel.callsBaseCtor(selfCall);
            if (calledIndirectly && TypeBinding.notEquals(requiredBase = roleType.baseclass(), createdBase = selfCall.declaringClass.baseclass())) {
                this.scope.problemReporter().callsCtorWithMismatchingBaseCtor(this.constructorCall, selfCall.declaringClass, requiredBase, createdBase);
            }
            calledIndirectly |= !Lifting.isLiftToConstructor(this.binding, this.binding.declaringClass) && Lifting.isLiftToConstructor(selfCall, selfCall.declaringClass);
            if (Lifting.isLiftToConstructor(this, this.binding.declaringClass)) {
                if (calledHere || calledIndirectly) {
                    this.scope.problemReporter().baseConstructorCallInLiftingConstructor(this);
                }
            } else {
                FieldBinding baseField;
                if (!(calledHere || calledIndirectly || Lifting.isLiftingCtor(selfCall))) {
                    if (!this.isDefaultConstructor() || roleType.roleModel == null || !roleType.roleModel.hasBaseclassProblem()) {
                        this.scope.problemReporter().missingCallToBaseConstructor(this, this.binding.declaringClass);
                    }
                } else if (calledHere && calledIndirectly) {
                    this.scope.problemReporter().tooManyCallsToBaseConstructor(this.statements[0], this.constructorCall);
                }
                if (!calledHere && (baseField = this.scope.enclosingSourceType().getField(IOTConstants._OT_BASE, true)) != null) {
                    flowInfo.markAsDefinitelyAssigned(baseField);
                }
            }
            if (calledIndirectly) {
                MethodModel.setCallsBaseCtor(this);
            }
        }
        try {
            Binding[] bindingArray;
            FieldBinding[] fields;
            ExceptionHandlingFlowContext constructorContext;
            int nonStaticFieldInfoReachMode;
            ExplicitConstructorCall lateConstructorCall;
            block57: {
                int size;
                List<TypeBinding> computedExceptions;
                Object declaringClass2;
                boolean hasArgumentNeedingAnalysis;
                block58: {
                    block59: {
                        MethodBinding methodBinding;
                        MethodBinding constructorBinding;
                        block56: {
                            lateConstructorCall = this.getLateConstructorCall();
                            boolean bl = hasArgumentNeedingAnalysis = this.constructorCall != null && this.constructorCall.hasArgumentNeedingAnalysis();
                            if (mode == AnalysisMode.PROLOGUE && lateConstructorCall == null && !hasArgumentNeedingAnalysis) {
                                return;
                            }
                            nonStaticFieldInfoReachMode = flowInfo.reachMode();
                            if (mode != AnalysisMode.REST) break block56;
                            constructorContext = this.prologueContext;
                            flowInfo = this.prologueInfo.addInitializationsFrom(flowInfo);
                            break block57;
                        }
                        flowInfo.setReachMode(initialReachMode);
                        if (classScope.referenceContext.isRole() && (!classScope.referenceContext.binding.isAnonymousType() || classScope.referenceContext.isPurelyCopied) || (constructorBinding = this.binding) == null || (this.bits & 0x80) != 0 || constructorBinding.isUsed() || (!constructorBinding.isPrivate() ? !constructorBinding.isOrEnclosedByPrivateType() : (this.binding.declaringClass.tagBits & 0x1000000000000000L) == 0L) || this.constructorCall == null) break block58;
                        if (this.constructorCall.accessMode == 3) break block59;
                        ReferenceBinding superClass = constructorBinding.declaringClass.superclass();
                        if (superClass == null || (methodBinding = superClass.getExactConstructor(Binding.NO_PARAMETERS)) == null || !methodBinding.canBeSeenBy(SuperReference.implicitSuperConstructorCall(), this.scope)) break block58;
                        declaringClass2 = constructorBinding.declaringClass;
                        if (constructorBinding.isPublic() && constructorBinding.parameters.length == 0 && ((ReferenceBinding)declaringClass2).isStatic() && ((TypeBinding)declaringClass2).findSuperTypeOriginatingFrom(56, false) != null) break block58;
                    }
                    if ((this.bits & 0x400) == 0) {
                        this.scope.problemReporter().unusedPrivateConstructor(this);
                    }
                }
                if (this.isRecursive(null)) {
                    this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
                }
                if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                    declaringClass2 = this.typeParameters;
                    int methodBinding = this.typeParameters.length;
                    int superClass = 0;
                    while (superClass < methodBinding) {
                        TypeParameter typeParameter = declaringClass2[superClass];
                        if ((typeParameter.binding.modifiers & 0x8000000) == 0) {
                            this.scope.problemReporter().unusedTypeParameter(typeParameter);
                        }
                        ++superClass;
                    }
                }
                constructorContext = new ExceptionHandlingFlowContext(initializerFlowContext.parent, this, this.binding.thrownExceptions, initializerFlowContext, this.scope, FlowInfo.DEAD_END);
                if (mode == AnalysisMode.PROLOGUE) {
                    this.prologueContext = constructorContext;
                }
                initializerFlowContext.checkInitializerExceptions(this.scope, constructorContext, flowInfo);
                if (this.binding.declaringClass.isAnonymousType() && (computedExceptions = constructorContext.extendedExceptions) != null && (size = computedExceptions.size()) > 0) {
                    ReferenceBinding[] actuallyThrownExceptions = new ReferenceBinding[size];
                    computedExceptions.toArray(actuallyThrownExceptions);
                    this.binding.thrownExceptions = actuallyThrownExceptions;
                }
                ConstructorDeclaration.analyseArguments(classScope.environment(), flowInfo, initializerFlowContext, this.arguments, this.binding);
                if (JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.matchesCompliance(this.scope.compilerOptions())) {
                    this.scope.enterEarlyConstructionContext();
                }
                if (this.constructorCall != null) {
                    flowInfo = this.constructorCall.analyseCode(this.scope, constructorContext, flowInfo);
                    if (mode == AnalysisMode.PROLOGUE && hasArgumentNeedingAnalysis) {
                        this.prologueInfo = flowInfo.copy();
                    }
                    if (this.constructorCall.accessMode == 3 && !TSuperHelper.isTSuper(this.constructorCall.binding)) {
                        fields = this.binding.declaringClass.fields();
                        bindingArray = fields;
                        int declaringClass2 = fields.length;
                        int actuallyThrownExceptions = 0;
                        while (actuallyThrownExceptions < declaringClass2) {
                            Binding field = bindingArray[actuallyThrownExceptions];
                            if (!((FieldBinding)field).isStatic()) {
                                flowInfo.markAsDefinitelyAssigned((FieldBinding)field);
                            }
                            ++actuallyThrownExceptions;
                        }
                    }
                }
                flowInfo.setReachMode(nonStaticFieldInfoReachMode);
            }
            if (this.statements != null) {
                CompilerOptions compilerOptions = this.scope.compilerOptions();
                boolean enableSyntacticNullAnalysisForFields = compilerOptions.enableSyntacticNullAnalysisForFields;
                int complaintLevel = (nonStaticFieldInfoReachMode & 3) == 0 ? 0 : 1;
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement stat = statementArray[n2];
                    if (mode == AnalysisMode.REST && lateConstructorCall != null) {
                        if (stat == lateConstructorCall) {
                            lateConstructorCall = null;
                        }
                    } else {
                        if ((complaintLevel = stat.complainIfUnreachable(flowInfo, this.scope, complaintLevel, true)) < 2) {
                            flowInfo = stat.analyseCode(this.scope, constructorContext, flowInfo);
                        }
                        if (enableSyntacticNullAnalysisForFields) {
                            constructorContext.expireNullCheckedFieldInfo();
                        }
                        if (compilerOptions.analyseResourceLeaks) {
                            FakedTrackingVariable.cleanUpUnassigned(this.scope, stat, flowInfo, false);
                        }
                        if (mode == AnalysisMode.PROLOGUE && stat == lateConstructorCall) break;
                    }
                    ++n2;
                }
                if (mode == AnalysisMode.PROLOGUE) {
                    if (this.prologueInfo == null) {
                        this.prologueInfo = flowInfo;
                    }
                    return;
                }
            }
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            if (this.isCompactConstructor()) {
                FieldBinding[] fieldBindingArray = this.binding.declaringClass.fields();
                int n = fieldBindingArray.length;
                int enableSyntacticNullAnalysisForFields = 0;
                while (enableSyntacticNullAnalysisForFields < n) {
                    FieldBinding field = fieldBindingArray[enableSyntacticNullAnalysisForFields];
                    if (!field.isStatic()) {
                        flowInfo.markAsDefinitelyAssigned(field);
                    }
                    ++enableSyntacticNullAnalysisForFields;
                }
            }
            if (this.constructorCall != null && !TSuperHelper.isTSuper(this.binding) && this.constructorCall.accessMode != 4 && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(constructorContext.initsOnReturn);
                fields = this.binding.declaringClass.fields();
                this.doFieldReachAnalysis(flowInfo, fields);
                if (roleType.isRole() && !TSuperHelper.isTSuper(this.binding) && this.constructorCall.accessMode != 4) {
                    bindingArray = roleType.roleModel.getTSuperRoleBindings();
                    int n = bindingArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ReferenceBinding tsuperRole = bindingArray[n3];
                        RoleModel tsuperModel = tsuperRole.roleModel;
                        if (tsuperModel != null && tsuperModel.hasFinalFieldInit()) {
                            classScope.problemReporter().needToCallTSuper(this.constructorCall, tsuperRole);
                            break;
                        }
                        ++n3;
                    }
                }
            }
            constructorContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
            this.scope.checkUnclosedCloseables(flowInfo, null, null, null);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected void doFieldReachAnalysis(FlowInfo flowInfo, FieldBinding[] fields) {
        FieldBinding[] fieldBindingArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldBinding field = fieldBindingArray[n2];
            if (!field.isStatic() && !flowInfo.isDefinitelyAssigned(field)) {
                FieldDeclaration fieldDecl;
                if (field.isFinal()) {
                    this.scope.problemReporter().uninitializedBlankFinalField(field, (this.bits & 0x80) != 0 ? this.scope.referenceType().declarationOf(field.original()) : this);
                } else if ((field.isNonNull() || field.type.isFreeTypeVariable()) && !this.isValueProvidedUsingAnnotation(fieldDecl = this.scope.referenceType().declarationOf(field.original()))) {
                    this.scope.problemReporter().uninitializedNonNullField(field, (this.bits & 0x80) != 0 ? fieldDecl : this);
                }
            }
            ++n2;
        }
    }

    boolean isValueProvidedUsingAnnotation(FieldDeclaration fieldDecl) {
        if (fieldDecl.annotations != null) {
            int length = fieldDecl.annotations.length;
            int i = 0;
            while (i < length) {
                MemberValuePair memberValuePair;
                int n;
                int n2;
                MemberValuePair[] memberValuePairArray;
                MemberValuePair[] memberValuePairs;
                Annotation annotation = fieldDecl.annotations[i];
                if (annotation.resolvedType.id == 80) {
                    return true;
                }
                if (annotation.resolvedType.id == 81) {
                    memberValuePairs = annotation.memberValuePairs();
                    if (memberValuePairs == Annotation.NoValuePairs) {
                        return true;
                    }
                    memberValuePairArray = memberValuePairs;
                    n2 = memberValuePairs.length;
                    n = 0;
                    while (n < n2) {
                        memberValuePair = memberValuePairArray[n];
                        if (CharOperation.equals(memberValuePair.name, TypeConstants.OPTIONAL)) {
                            return memberValuePair.value instanceof FalseLiteral;
                        }
                        ++n;
                    }
                } else if (annotation.resolvedType.id == 82) {
                    memberValuePairs = annotation.memberValuePairs();
                    if (memberValuePairs == Annotation.NoValuePairs) {
                        return true;
                    }
                    memberValuePairArray = memberValuePairs;
                    n2 = memberValuePairs.length;
                    n = 0;
                    while (n < n2) {
                        memberValuePair = memberValuePairArray[n];
                        if (CharOperation.equals(memberValuePair.name, TypeConstants.REQUIRED)) {
                            return memberValuePair.value instanceof TrueLiteral;
                        }
                        ++n;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        TypeDeclaration referenceContext;
        if (this.isRelevantCopied()) {
            new BytecodeTransformer().checkCopyMethodCode(classFile, this);
            if (this.binding.bytecodeMissing && !Config.getConfig().ignoreMissingBytecode) {
                CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
                int problemsLength = problems.length;
                CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
                System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
                classFile.addProblemConstructor(this, this.binding, problemsCopy);
            }
            return;
        }
        if (this.areStatementsMissing() && (this.bits & 0x280) == 0) {
            this.binding.bytecodeMissing = true;
            return;
        }
        int problemResetPC = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy);
            this.binding.bytecodeMissing = true;
            return;
        }
        boolean restart = false;
        boolean abort = false;
        CompilationResult unitResult = null;
        int problemCount = 0;
        if (classScope != null && (referenceContext = classScope.referenceContext) != null) {
            unitResult = referenceContext.compilationResult();
            problemCount = unitResult.problemCount;
        }
        do {
            try {
                problemResetPC = classFile.contentsOffset;
                this.internalGenerateCode(classScope, classFile);
                restart = false;
            }
            catch (AbortMethod e) {
                if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                if (e.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                restart = false;
                abort = true;
            }
        } while (restart);
        if (abort) {
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding declaringClass) {
        int n;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        SyntheticArgumentBinding[] syntheticArgs = declaringClass.valueParamSynthArgs();
        if (syntheticArgs != null) {
            int i = 0;
            int max = syntheticArgs.length;
            while (i < max) {
                SyntheticArgumentBinding syntheticArg = syntheticArgs[i];
                if (syntheticArg.matchingField != null) {
                    codeStream.record(syntheticArg);
                    syntheticArg.recordInitializationStartPC(codeStream.position);
                    codeStream.aload_0();
                    codeStream.load(syntheticArg);
                    codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, declaringClass);
                }
                ++i;
            }
        }
        if (!declaringClass.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)declaringClass;
        syntheticArgs = nestedType.syntheticEnclosingInstances();
        if (syntheticArgs != null) {
            syntheticArgumentBindingArray = syntheticArgs;
            n = syntheticArgs.length;
            int n2 = 0;
            while (n2 < n) {
                SyntheticArgumentBinding syntheticArg = syntheticArgumentBindingArray[n2];
                if (syntheticArg.matchingField != null) {
                    codeStream.aload_0();
                    codeStream.load(syntheticArg);
                    codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
                }
                ++n2;
            }
        }
        if ((syntheticArgs = nestedType.syntheticOuterLocalVariables()) != null) {
            syntheticArgumentBindingArray = syntheticArgs;
            n = syntheticArgs.length;
            int n3 = 0;
            while (n3 < n) {
                SyntheticArgumentBinding syntheticArg = syntheticArgumentBindingArray[n3];
                if (syntheticArg.matchingField != null) {
                    codeStream.aload_0();
                    codeStream.load(syntheticArg);
                    codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
                }
                ++n3;
            }
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttributes(this.binding);
        if (this.model != null) {
            attributeNumber += this.model.writeAttributes(classFile);
        }
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n;
            int n2;
            Statement[] statementArray;
            ExplicitConstructorCall lateConstructorCall;
            boolean needFieldInitializations;
            MethodScope initializerScope;
            CodeStream codeStream;
            int codeAttributeOffset;
            TypeDeclaration declaringType;
            block34: {
                boolean preInitSyntheticFields;
                declaringType = classScope.referenceContext;
                codeAttributeOffset = classFile.contentsOffset;
                classFile.generateCodeAttributeHeader();
                codeStream = classFile.codeStream;
                codeStream.reset(this, classFile);
                ReferenceBinding declaringClass = this.binding.declaringClass;
                int enumOffset = declaringClass.isEnum() ? 2 : 0;
                int argSlotSize = 1 + enumOffset;
                if (declaringClass.isNestedType()) {
                    this.scope.extraSyntheticArguments = declaringClass.syntheticOuterLocalVariables();
                    this.scope.computeLocalVariablePositions(declaringClass.getEnclosingInstancesSlotSize() + 1 + enumOffset, codeStream);
                    argSlotSize += declaringClass.getEnclosingInstancesSlotSize();
                    argSlotSize += declaringClass.getOuterLocalVariablesSlotSize();
                } else {
                    SyntheticArgumentBinding[] syntheticArguments = declaringClass.valueParamSynthArgs();
                    argSlotSize += syntheticArguments.length;
                    this.scope.computeLocalVariablePositions(1 + enumOffset + syntheticArguments.length, codeStream);
                }
                if (this.arguments != null) {
                    Argument[] argumentArray = this.arguments;
                    int n3 = this.arguments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Argument argument = argumentArray[n4];
                        LocalVariableBinding argBinding = argument.binding;
                        codeStream.addVisibleLocalVariable(argBinding);
                        argBinding.recordInitializationStartPC(0);
                        switch (argBinding.type.id) {
                            case 7: 
                            case 8: {
                                argSlotSize += 2;
                                break;
                            }
                            default: {
                                ++argSlotSize;
                            }
                        }
                        ++n4;
                    }
                }
                initializerScope = declaringType.initializerScope;
                initializerScope.computeLocalVariablePositions(argSlotSize, codeStream);
                codeStream.pushPatternAccessTrapScope(this.scope);
                boolean bl = needFieldInitializations = this.constructorCall == null || this.constructorCall.accessMode != 3;
                if (!needFieldInitializations && this.constructorCall != null && this.constructorCall.binding.model != null && this.constructorCall.binding.model.liftedParams != null) {
                    needFieldInitializations = true;
                }
                if (needFieldInitializations && TypeAnalyzer.isTopConfined(this.scope.enclosingReceiverType())) {
                    needFieldInitializations = false;
                }
                boolean bl2 = preInitSyntheticFields = this.scope.compilerOptions().targetJDK >= 0x300000L;
                if (needFieldInitializations && preInitSyntheticFields) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                    codeStream.recordPositionsFrom(0, this.bodyStart > 0 ? this.bodyStart : this.sourceStart);
                }
                if (JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.matchesCompliance(this.scope.compilerOptions())) {
                    this.scope.enterEarlyConstructionContext();
                }
                if (this.constructorCall != null) {
                    this.constructorCall.generateCode(this.scope, codeStream);
                }
                lateConstructorCall = this.getLateConstructorCall();
                if (needFieldInitializations) {
                    if (!preInitSyntheticFields) {
                        this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                    }
                    if (!this.isRoleUsingInitFields(declaringType, declaringClass)) {
                        if (lateConstructorCall == null) {
                            this.generateFieldInitializations(declaringType, codeStream, initializerScope);
                        }
                    } else {
                        MethodBinding[] initMethods = declaringType.binding.getMethods(IOTConstants.INIT_METHOD_NAME);
                        if (initMethods.length >= 1) {
                            int argCount = TSuperHelper.isTSuper(this.binding) ? 1 : 0;
                            int i = 0;
                            while (i < initMethods.length) {
                                if (initMethods[i].parameters.length == argCount) {
                                    codeStream.aload_0();
                                    codeStream.invoke((byte)-74, initMethods[i], declaringType.binding);
                                    break block34;
                                }
                                ++i;
                            }
                        }
                        assert (TypeModel.isIgnoreFurtherInvestigation(classScope.referenceContext) || RoleModel.hasTagBit(declaringClass, 2) || declaringClass.isTeam());
                    }
                }
            }
            if (this.statements != null) {
                statementArray = this.statements;
                n2 = this.statements.length;
                n = 0;
                while (n < n2) {
                    Statement statement = statementArray[n];
                    statement.generateCode(this.scope, codeStream);
                    if (!(this.compilationResult.hasErrors() || codeStream.stackDepth == 0 && codeStream.operandStack.size() == 0)) {
                        this.scope.problemReporter().operandStackSizeInappropriate(this);
                    }
                    if (lateConstructorCall == statement) {
                        this.generateFieldInitializations(declaringType, codeStream, initializerScope);
                    }
                    ++n;
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                if (this.isCompactConstructor()) {
                    statementArray = classScope.referenceContext.recordComponents;
                    n2 = classScope.referenceContext.recordComponents.length;
                    n = 0;
                    while (n < n2) {
                        Statement rc = statementArray[n];
                        LocalVariableBinding parameter = this.scope.findVariable(((RecordComponent)rc).name);
                        FieldBinding field = classScope.referenceContext.binding.getField(((RecordComponent)rc).name, true).original();
                        codeStream.aload_0();
                        codeStream.load(parameter);
                        codeStream.fieldAccess((byte)-75, field, classScope.referenceContext.binding);
                        ++n;
                    }
                }
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope, lvb -> !lvb.isParameter());
            codeStream.handleRecordAccessorExceptions(this.scope);
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd > 0 ? this.bodyEnd : this.sourceStart);
            try {
                classFile.completeCodeAttribute(codeAttributeOffset, this.scope);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            this.maybeRecordByteCode(classFile, methodAttributeOffset - 6);
            ++attributeNumber;
            if (codeStream instanceof StackMapFrameCodeStream && needFieldInitializations && declaringType.fields != null) {
                ((StackMapFrameCodeStream)codeStream).resetSecretLocals();
            }
        }
        classFile.completeMethodInfo(this.binding, methodAttributeOffset, attributeNumber);
    }

    private void generateFieldInitializations(TypeDeclaration declaringType, CodeStream codeStream, MethodScope initializerScope) {
        if (declaringType.fields != null) {
            FieldDeclaration[] fieldDeclarationArray = declaringType.fields;
            int n = declaringType.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (!field.isStatic()) {
                    field.generateCode(initializerScope, codeStream);
                }
                ++n2;
            }
        }
    }

    private boolean isRoleUsingInitFields(TypeDeclaration typeDecl, ReferenceBinding typeBinding) {
        int n;
        int n2;
        Object[] objectArray;
        if (!typeDecl.isRole() || typeBinding.enclosingType() != null && typeBinding.enclosingType().id == 126) {
            return false;
        }
        boolean hasInitialization = false;
        if (typeDecl.fields != null) {
            objectArray = typeDecl.fields;
            n2 = typeDecl.fields.length;
            n = 0;
            while (n < n2) {
                Object fieldDeclaration = objectArray[n];
                if (((FieldDeclaration)fieldDeclaration).initialization != null) {
                    if (((FieldDeclaration)fieldDeclaration).isFinal()) {
                        return false;
                    }
                    hasInitialization = true;
                }
                ++n;
            }
        }
        objectArray = typeDecl.getRoleModel().getTSuperRoleBindings();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object tsuperRole = objectArray[n];
            if (((TypeBinding)tsuperRole).fields() != Binding.NO_FIELDS && !((ReferenceBinding)tsuperRole).roleModel.hasFinalFieldInit()) {
                hasInitialization = true;
            }
            ++n;
        }
        return hasInitialization;
    }

    @Override
    protected AnnotationBinding[][] getPropagatedRecordComponentAnnotations() {
        if ((this.bits & 0x600) == 0) {
            return null;
        }
        if (this.binding == null) {
            return null;
        }
        AnnotationBinding[][] paramAnnotations = null;
        ReferenceBinding declaringClass = this.binding.declaringClass;
        if (declaringClass instanceof SourceTypeBinding) {
            assert (declaringClass.isRecord());
            RecordComponentBinding[] rcbs = ((SourceTypeBinding)declaringClass).components();
            int i = 0;
            int length = rcbs.length;
            while (i < length) {
                RecordComponentBinding rcb = rcbs[i];
                RecordComponent recordComponent = rcb.sourceRecordComponent();
                long rcMask = 0x20008000000000L;
                ArrayList<AnnotationBinding> relevantAnnotationBindings = new ArrayList<AnnotationBinding>();
                Annotation[] relevantAnnotations = ASTNode.getRelevantAnnotations(recordComponent.annotations, rcMask, relevantAnnotationBindings);
                if (relevantAnnotations != null) {
                    if (paramAnnotations == null) {
                        paramAnnotations = new AnnotationBinding[length][];
                        int j = 0;
                        while (j < i) {
                            paramAnnotations[j] = Binding.NO_ANNOTATIONS;
                            ++j;
                        }
                    }
                    this.binding.tagBits |= 0x400L;
                    paramAnnotations[i] = relevantAnnotationBindings.toArray(new AnnotationBinding[0]);
                } else if (paramAnnotations != null) {
                    paramAnnotations[i] = Binding.NO_ANNOTATIONS;
                }
                ++i;
            }
        }
        return paramAnnotations;
    }

    @Override
    public void maybeRecordByteCode(ClassFile classFile, int methodAttributeOffset) {
        RoleModel.maybeRecordByteCode(this, classFile, methodAttributeOffset);
        if (this.binding.declaringClass.isTeam()) {
            MethodModel methodModel = MethodModel.getModel(this);
            methodModel.recordByteCode(classFile, methodAttributeOffset);
        }
    }

    @Override
    public void getAllAnnotationContexts(int targetType, List allAnnotationContexts) {
        SingleTypeReference fakeReturnType = new SingleTypeReference(this.selector, 0L);
        fakeReturnType.resolvedType = this.binding.declaringClass;
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector(fakeReturnType, targetType, (List<AnnotationContext>)allAnnotationContexts);
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            annotation.traverse((ASTVisitor)collector, (BlockScope)null);
            ++n2;
        }
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isCanonicalConstructor() {
        return (this.bits & 0x200) != 0;
    }

    @Override
    public boolean isDefaultConstructor() {
        return (this.bits & 0x80) != 0;
    }

    @Override
    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList visited) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || this.constructorCall.isTsuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration targetConstructor = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (targetConstructor == null) {
            return false;
        }
        if (this == targetConstructor) {
            return true;
        }
        if (visited == null) {
            visited = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int index = visited.indexOf(this);
            if (index >= 0) {
                return index == 0;
            }
        }
        visited.add(this);
        return targetConstructor.isRecursive(visited);
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.isCompactConstructor()) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
        } else if ((this.bits & 0x80) != 0 && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        if (this.isCopied || this.isGenerated) {
            return;
        }
        parser.parse(this, unit, false);
    }

    void createExceptionStatements() {
        AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
        this.constructorCall = gen.explicitConstructorCall(2);
        this.statements = new Statement[]{gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(IOTConstants.ILLEGAL_ROLE_CREATION_EXCEPTION), null))};
        this.hasParsedStatements = true;
        this.isCopied = false;
        this.resolve(this.scope.classScope());
    }

    @Override
    public StringBuilder printBody(int indent, StringBuilder output) {
        output.append(" {");
        if (this.constructorCall != null) {
            output.append('\n');
            this.constructorCall.printStatement(indent, output);
        }
        if (this.statements != null) {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                output.append('\n');
                statement.printStatement(indent, output);
                ++n2;
            }
        } else if (this.isCopied && this.statements == null) {
            output.append("\n");
            ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output);
            output.append("     /* CopyInheritance */");
        }
        output.append('\n');
        ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    @Override
    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if ((this.bits & 0x80) == 0) {
            if ((this.bits & 0x400) != 0) {
                return;
            }
            if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
                int javadocVisibility = this.binding.modifiers & 7;
                ClassScope classScope = this.scope.classScope();
                ProblemReporter reporter = this.scope.problemReporter();
                int severity = reporter.computeSeverity(-1610612250);
                if (severity != 256) {
                    if (classScope != null) {
                        javadocVisibility = Util.computeOuterMostVisibility(classScope.referenceType(), javadocVisibility);
                    }
                    int javadocModifiers = this.binding.modifiers & 0xFFFFFFF8 | javadocVisibility;
                    reporter.javadocMissing(this.sourceStart, this.sourceEnd, severity, javadocModifiers);
                }
            }
        }
    }

    @Override
    public void resolveStatements() {
        SourceTypeBinding sourceType = this.scope.enclosingSourceType();
        if (!CharOperation.equals(sourceType.sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.isCopied) {
            return;
        }
        if (this.binding != null && !this.binding.isPrivate()) {
            sourceType.tagBits |= 0x1000000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceType.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else if (sourceType.isRecord() && !this.isCompactConstructor() && this.binding != null && !this.binding.isCanonicalConstructor() && this.constructorCall.accessMode != 3) {
                this.scope.problemReporter().recordMissingExplicitConstructorCallInNonCanonicalConstructor(this);
                this.constructorCall = null;
            } else {
                if (this.statements != null && this.statements.length > 0 && this.statements[0] instanceof BaseAllocationExpression) {
                    ((BaseAllocationExpression)this.statements[0]).checkGenerate(this.scope);
                }
                Config oldConfig = Config.createOrResetConfig(this);
                try {
                    ExplicitConstructorCall lateConstructorCall = null;
                    if (JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.matchesCompliance(this.scope.compilerOptions())) {
                        this.scope.enterEarlyConstructionContext();
                        lateConstructorCall = this.getLateConstructorCall();
                    }
                    if (lateConstructorCall != null) {
                        this.constructorCall = null;
                        this.scope.problemReporter().validateJavaFeatureSupport(JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES, lateConstructorCall.sourceStart, lateConstructorCall.sourceEnd);
                    } else {
                        this.constructorCall.resolve(this.scope);
                        if (Config.requireTypeAdjustment() && !this.scope.problemReporter().referenceContext.hasErrors()) {
                            this.constructorCall.traverse(new InsertTypeAdjustmentsVisitor(), this.scope);
                        }
                    }
                }
                finally {
                    Config.removeOrRestore(oldConfig, this);
                }
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    ExplicitConstructorCall getLateConstructorCall() {
        if (!JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.matchesCompliance(this.scope.compilerOptions())) {
            return null;
        }
        if (this.constructorCall != null && !this.constructorCall.isImplicitSuper()) {
            return null;
        }
        if (this.statements == null) {
            return null;
        }
        int i = 0;
        while (i < this.statements.length) {
            Statement statement = this.statements[i];
            if (statement instanceof ExplicitConstructorCall) {
                ExplicitConstructorCall ctorCall = (ExplicitConstructorCall)statement;
                return i > 0 ? ctorCall : null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.scope);
            }
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                i = 0;
                while (i < typeParametersLength) {
                    this.typeParameters[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(visitor, this.scope);
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }

    static enum AnalysisMode {
        ALL,
        PROLOGUE,
        REST;

    }
}

