/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;

public class SourceField
extends NamedMember
implements IField {
    protected SourceField(JavaElement parent, String name) {
        super(parent, name);
    }

    protected SourceField(JavaElement parent, String name, int occurrenceCount) {
        super(parent, name, occurrenceCount);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceField)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ASTNode findNode(org.eclipse.jdt.core.dom.CompilationUnit ast) {
        ASTNode node = super.findNode(ast);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 72) {
            return node;
        }
        return node.getParent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getConstant() throws JavaModelException {
        Integer constant = null;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        char[] constantSourceChars = info.initializationSource;
        if (constantSourceChars == null) {
            return null;
        }
        String constantSource = new String(constantSourceChars);
        String signature = info.getTypeSignature();
        try {
            if (signature.equals("I")) {
                return Integer.valueOf(constantSource);
            }
            if (signature.equals("S")) {
                return Short.valueOf(constantSource);
            }
            if (signature.equals("B")) {
                return Byte.valueOf(constantSource);
            }
            if (signature.equals("Z")) {
                return Boolean.valueOf(constantSource);
            }
            if (signature.equals("C")) {
                if (constantSourceChars.length == 3) return Character.valueOf(constantSourceChars[1]);
                return null;
            }
            if (signature.equals("D")) {
                return Double.valueOf(constantSource);
            }
            if (signature.equals("F")) {
                return Float.valueOf(constantSource);
            }
            if (signature.equals("J")) {
                if (!constantSource.endsWith("L") && !constantSource.endsWith("l")) {
                    return Long.valueOf(constantSource);
                }
                int index = constantSource.lastIndexOf("L");
                if (index == -1) return Long.valueOf(constantSource.substring(0, constantSource.lastIndexOf("l")));
                return Long.valueOf(constantSource.substring(0, index));
            }
            if (signature.equals("QString;")) {
                return constantSource;
            }
            if (!signature.equals("Qjava.lang.String;")) return constant;
            return constantSource;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public int getElementType() {
        return 8;
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '^';
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        JavaElement primaryParent = this.getParent().getPrimaryElement(false);
        return (JavaElement)((Object)((IType)((Object)primaryParent)).getField(this.name));
    }

    @Override
    public String getTypeSignature() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.getTypeSignature();
    }

    @Override
    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public ResolvedSourceField resolved(Binding binding) {
        return new ResolvedSourceField(this.getParent(), this.name, new String(binding.computeUniqueKey()), this.getOccurrenceCount());
    }

    @Override
    protected void toStringInfo(int tab, StringBuilder buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    public boolean isRecordComponent() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.isRecordComponent;
    }
}

