/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractExpressionWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.LiftingTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticBaseCallSurrogate;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.BaseCallProblemReporterWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.BlockScopeWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.ProblemReporterWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class BaseCallMessageSend
extends AbstractExpressionWrapper {
    public char[] sourceSelector;
    public Expression[] sourceArgs;
    protected MessageSend _sendOrig;
    BaseReference _receiver;
    public boolean isSuperAccess;
    private CompilerOptions.WeavingScheme _weavingScheme = CompilerOptions.WeavingScheme.OTRE;
    private MethodDeclaration enclosingCallinMethod;

    public BaseCallMessageSend(MessageSend wrappee, int baseEndPos) {
        super(wrappee, wrappee.sourceStart, wrappee.sourceEnd);
        this._receiver = new BaseReference(wrappee.sourceStart, baseEndPos);
        wrappee.receiver = this._receiver;
        this._sendOrig = wrappee;
        this.sourceSelector = wrappee.selector;
        this.sourceArgs = wrappee.arguments;
    }

    public void setSuperAccess(boolean isSuperAccess, ProblemReporter problemReporter) {
        this.isSuperAccess = isSuperAccess;
        if (isSuperAccess) {
            problemReporter.baseSuperCallDecapsulation(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void prepareSuperAccess(CompilerOptions.WeavingScheme weavingScheme, MethodDeclaration enclosingMethod, BlockScope scope) {
        block7: {
            block8: {
                block6: {
                    args = this._sendOrig.arguments;
                    this.sourceArgs = args;
                    len = 0;
                    v0 = extra = weavingScheme == CompilerOptions.WeavingScheme.OTRE ? 1 : 0;
                    if (args == null) {
                        args = new Expression[extra];
                    } else {
                        len = args.length;
                        v1 = args;
                        args = new Expression[len + extra];
                        System.arraycopy(v1, 0, args, extra, len);
                    }
                    if (weavingScheme != CompilerOptions.WeavingScheme.OTRE) break block6;
                    args[0] = new AstGenerator(this).booleanLiteral(this.isSuperAccess);
                    break block7;
                }
                gen = new AstGenerator(this);
                baseCallFlags = gen.intLiteral(this.isSuperAccess != false ? 2 : 1);
                if (args.length != 0) break block8;
                args = new Expression[]{gen.nullLiteral(), baseCallFlags};
                break block7;
            }
            enhLen = MethodSignatureEnhancer.getEnhancingArgLen(weavingScheme);
            if (enclosingMethod.arguments.length - enhLen != args.length) {
                scope.problemReporter().baseCallDoesntMatchRoleMethodSignature(this);
                return;
            }
            boxedArgs = new Expression[args.length];
            i = 0;
            while (i < args.length) {
                block10: {
                    block9: {
                        argument = enclosingMethod.arguments[i + enhLen];
                        argTypeBinding = argument.binding.type;
                        if (!argTypeBinding.isBaseType()) break block9;
                        boxedArgs[i] = gen.createBoxing(args[i], (BaseTypeBinding)argTypeBinding);
                        break block10;
                    }
                    if (!argument.type.isDeclaredLifting()) ** GOTO lbl-1000
                    ltr = (LiftingTypeReference)argument.type;
                    if (ltr.roleReference.resolvedType != null) {
                        teamThis = gen.qualifiedThisReference(enclosingMethod.binding.declaringClass.enclosingType());
                        boxedArgs[i] = new Lowering().lowerExpression(scope, args[i], ltr.roleReference.resolvedType, ltr.resolvedType, teamThis, true, true);
                    } else lbl-1000:
                    // 2 sources

                    {
                        boxedArgs[i] = args[i];
                    }
                }
                ++i;
            }
            args = new Expression[]{gen.arrayAllocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), 1, boxedArgs), baseCallFlags};
        }
        this._sendOrig.arguments = args;
        this._weavingScheme = weavingScheme;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        MethodModel methodModel;
        flowInfo = super.analyseCode(currentScope, flowContext, flowInfo);
        MethodDeclaration callinMethod = this.getEnclosingCallinMethod(currentScope);
        LocalVariableBinding trackingVariable = callinMethod.baseCallTrackingVariable.binding;
        if (flowInfo.isDefinitelyAssigned(callinMethod.baseCallTrackingVariable)) {
            currentScope.problemReporter().definitelyDuplicateBasecall(this._wrappee);
        } else if (flowInfo.isPotentiallyAssigned(trackingVariable)) {
            currentScope.problemReporter().potentiallyDuplicateBasecall(this._wrappee);
        } else {
            flowInfo.markAsDefinitelyAssigned(trackingVariable);
        }
        MethodScope methodScope = currentScope.methodScope();
        if (methodScope != null && (methodModel = callinMethod.binding.model) != null && methodModel._baseExceptions != null) {
            for (ReferenceBinding exceptionType : methodModel._baseExceptions) {
                flowContext.checkExceptionHandlers(exceptionType, (ASTNode)this, flowInfo, currentScope);
            }
        }
        if (this.isSuperAccess) {
            MethodModel.addCallinFlag(currentScope.methodScope().referenceMethod(), 32);
        }
        return flowInfo;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        return 1;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        CompilerOptions.WeavingScheme weavingScheme = scope.compilerOptions().weavingScheme;
        AstGenerator gen = new AstGenerator(this._wrappee.sourceStart, this._wrappee.sourceEnd);
        MessageSend wrappedSend = this._sendOrig;
        MethodDeclaration callinMethodDecl = this.getEnclosingCallinMethod(scope.methodScope());
        if (callinMethodDecl == null) {
            return null;
        }
        MethodBinding callinMethodBinding = callinMethodDecl.binding;
        if (callinMethodBinding == null) {
            return null;
        }
        boolean isStatic = scope.methodScope().isStatic;
        SourceTypeBinding roleType = scope.enclosingSourceType();
        this._receiver.adjustReceiver(roleType, isStatic, callinMethodDecl, gen, weavingScheme);
        boolean isCallinBound = SyntheticBaseCallSurrogate.isCallinMethodBoundIn(callinMethodBinding, callinMethodBinding.declaringClass);
        if (!isCallinBound && weavingScheme == CompilerOptions.WeavingScheme.OTRE) {
            this.resolveSyntheticBaseCallSurrogate(callinMethodDecl, scope, weavingScheme);
            return this.resolvedType;
        }
        wrappedSend.selector = weavingScheme == CompilerOptions.WeavingScheme.OTDRE ? CallinImplementorDyn.OT_CALL_NEXT : SyntheticBaseCallSurrogate.genSurrogateName(wrappedSend.selector, roleType.sourceName(), isStatic);
        TypeBinding returnType = MethodModel.getReturnType(callinMethodBinding);
        boolean resultTunneling = false;
        if (returnType != null) {
            if (returnType.isPrimitiveType()) {
                this._wrappee = gen.createUnboxing(this._wrappee, (BaseTypeBinding)returnType);
            } else if (TypeBinding.equalsEquals(returnType, TypeBinding.VOID) && callinMethodDecl == scope.methodScope().referenceMethod()) {
                this._wrappee = gen.assignment(gen.singleNameReference(IOTConstants.OT_RESULT), this._wrappee);
                resultTunneling = true;
            }
        }
        BlockScopeWrapper baseCallScope = new BlockScopeWrapper(scope, this);
        super.resolveType(baseCallScope);
        if (weavingScheme == CompilerOptions.WeavingScheme.OTDRE) {
            if (returnType != null && !returnType.isPrimitiveType() && !resultTunneling) {
                this.resolvedType = returnType;
                if (TypeBinding.notEquals(returnType, TypeBinding.VOID)) {
                    this._sendOrig.valueCast = returnType;
                }
            }
            Expression[] args = this.sourceArgs;
            callinMethodBinding.switchToSourceParamters();
            try {
                TypeBinding[] parameters = callinMethodBinding.parameters;
                if (args != null && args.length == parameters.length) {
                    TypeBinding[] argumentTypes = new TypeBinding[args.length];
                    boolean hasArgumentProblem = false;
                    int i = 0;
                    while (i < args.length) {
                        argumentTypes[i] = args[i].resolvedType;
                        if (argumentTypes[i] == null) {
                            TypeBinding typeBinding = this.resolvedType;
                            return typeBinding;
                        }
                        if (!hasArgumentProblem && !argumentTypes[i].isBoxingCompatibleWith(parameters[i], scope)) {
                            hasArgumentProblem = true;
                        }
                        ++i;
                    }
                    if (hasArgumentProblem) {
                        scope.problemReporter().baseCallArgumentMismatch(callinMethodBinding, argumentTypes, this._sendOrig);
                    }
                    this.checkInvocationArguments(scope, this._receiver, roleType, callinMethodBinding, args, argumentTypes, false, this._sendOrig);
                }
            }
            finally {
                callinMethodBinding.resetParameters();
            }
        }
        return this.resolvedType;
    }

    private void resolveSyntheticBaseCallSurrogate(MethodDeclaration callinMethodDecl, BlockScope scope, CompilerOptions.WeavingScheme weavingScheme) {
        TypeBinding[] methodParams;
        MethodBinding callinMethod = callinMethodDecl.binding;
        if (callinMethod == null) {
            if (callinMethodDecl.ignoreFurtherInvestigation) {
                return;
            }
            throw new InternalCompilerError("Unresolved method without an error");
        }
        if (!CharOperation.equals(this._sendOrig.selector, callinMethod.selector)) {
            scope.problemReporter().baseCallNotSameMethod(callinMethodDecl, this._sendOrig);
        }
        this._receiver.resolve(scope);
        int depth = 0;
        while (this._receiver.resolvedType.isLocalType()) {
            this._receiver.resolvedType = this._receiver.resolvedType.enclosingType();
            ++depth;
        }
        this._receiver.bits |= depth << 5;
        if (this._receiver.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding receiverType = (ReferenceBinding)this._receiver.resolvedType;
            this._receiver.resolvedType = receiverType.getRealClass();
        }
        TypeBinding[] sendparams = new TypeBinding[this._sendOrig.arguments.length];
        int i = 0;
        while (i < sendparams.length) {
            sendparams[i] = this._sendOrig.arguments[i].resolveType(scope);
            ++i;
        }
        int sourceArgsLen = 0;
        if (this.sourceArgs != null) {
            sourceArgsLen = this.sourceArgs.length;
        }
        if (sourceArgsLen != (methodParams = callinMethod.getSourceParameters()).length) {
            scope.problemReporter().baseCallDoesntMatchRoleMethodSignature(this);
        } else {
            int i2 = 0;
            while (i2 < sourceArgsLen) {
                TypeBinding srcArgType = this.sourceArgs[i2].resolvedType;
                if (srcArgType == null) {
                    if (!callinMethodDecl.hasErrors()) {
                        throw new InternalCompilerError("Unexpected: srcArgType should only ever be missing in declarations with reported errors");
                    }
                } else if (!srcArgType.isCompatibleWith(methodParams[i2])) {
                    if (this.isBoxingCompatible(srcArgType, methodParams[i2], this.sourceArgs[i2], scope)) {
                        int enhancedArgIdx = i2 + MethodSignatureEnhancer.getEnhancingArgLen(weavingScheme) + 1;
                        this._sendOrig.arguments[enhancedArgIdx].computeConversion(scope, methodParams[i2], srcArgType);
                    } else {
                        scope.problemReporter().baseCallDoesntMatchRoleMethodSignature(this);
                        break;
                    }
                }
                ++i2;
            }
        }
        MethodBinding surrogate = null;
        MethodModel model = callinMethod.model;
        if (model != null) {
            surrogate = model.getBaseCallSurrogate();
        }
        if (surrogate == null) {
            SourceTypeBinding receiverClass = (SourceTypeBinding)((ReferenceBinding)this._receiver.resolvedType).getRealClass();
            if (SyntheticBaseCallSurrogate.isBindingForCallinMethodInherited(callinMethod)) {
                ReferenceBinding currentRole = callinMethod.declaringClass;
                while (surrogate == null && (currentRole = currentRole.superclass()) != null) {
                    surrogate = receiverClass.getExactMethod(SyntheticBaseCallSurrogate.genSurrogateName(this.sourceSelector, currentRole.sourceName(), callinMethod.isStatic()), sendparams, null);
                }
            } else {
                surrogate = receiverClass.addSyntheticBaseCallSurrogate(callinMethod);
            }
        }
        this._sendOrig.binding = surrogate;
        this._sendOrig.actualReceiverType = this._receiver.resolvedType;
        this._sendOrig.constant = Constant.NotAConstant;
        this.resolvedType = this._sendOrig.resolvedType = MethodModel.getReturnType(this._sendOrig.binding);
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (this._sendOrig.binding instanceof SyntheticBaseCallSurrogate && this._sendOrig == this._wrappee && this.resolvedType.isBaseType() && this.resolvedType != TypeBinding.VOID) {
            ReferenceBinding boxType = (ReferenceBinding)scope.getType(AstGenerator.boxTypeName((BaseTypeBinding)this.resolvedType), 3);
            this._sendOrig.valueCast = boxType;
            compileTimeType = boxType;
        }
        super.computeConversion(scope, runtimeTimeType, compileTimeType);
    }

    private MethodDeclaration getEnclosingCallinMethod(Scope scope) {
        if (this.enclosingCallinMethod == null) {
            this.enclosingCallinMethod = BaseCallMessageSend.findEnclosingCallinMethod(scope, this);
        }
        return this.enclosingCallinMethod;
    }

    public static MethodDeclaration findEnclosingCallinMethod(Scope scope, ASTNode errorLocation) {
        AbstractMethodDeclaration methodDecl = null;
        MethodScope methodScope = scope.methodScope();
        while (methodScope != null) {
            if (methodScope.referenceContext() instanceof AbstractMethodDeclaration) {
                methodDecl = (AbstractMethodDeclaration)methodScope.referenceContext();
                if ((methodDecl.modifiers & Integer.MIN_VALUE) != 0) {
                    return (MethodDeclaration)methodDecl;
                }
            }
            methodScope = methodScope.parent.methodScope();
        }
        if (errorLocation != null) {
            if (methodDecl == null) {
                scope.problemReporter().baseCallOutsideMethod(errorLocation);
            } else {
                scope.problemReporter().basecallInRegularMethod(errorLocation, methodDecl);
            }
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this._wrappee.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public MessageSend getMessageSend() {
        return this._sendOrig;
    }

    @Override
    public ProblemReporterWrapper create(ProblemReporter wrappee) {
        return new BaseCallProblemReporterWrapper(wrappee, this);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        char[] selectorSave = "<missing>".toCharArray();
        Expression[] argsSave = null;
        try {
            if (this._sendOrig != null) {
                selectorSave = this._sendOrig.selector;
                this._sendOrig.selector = this.sourceSelector;
                argsSave = this._sendOrig.arguments;
                if (BaseCallMessageSend.hasBeenTransformed(this)) {
                    this._sendOrig.arguments = MethodSignatureEnhancer.retrenchBasecallArguments(argsSave, BaseCallMessageSend.hasBeenTransformed(this._sendOrig), this._weavingScheme);
                }
                StringBuilder stringBuilder = this._sendOrig.printExpression(indent, output);
                return stringBuilder;
            }
        }
        finally {
            if (selectorSave != null) {
                this._sendOrig.selector = selectorSave;
            }
            if (argsSave != null) {
                this._sendOrig.arguments = argsSave;
            }
        }
        return super.printExpression(indent, output);
    }

    private static boolean hasBeenTransformed(Expression expr) {
        return (expr.bits & 4) != 0;
    }

    @Override
    public boolean statementExpression() {
        return (this.bits & 0x1FE00000) == 0;
    }

    public static void lambdaCapture(final LambdaExpression lambda, BlockScope currentScope) {
        if (currentScope.compilerOptions().weavingScheme != CompilerOptions.WeavingScheme.OTDRE) {
            return;
        }
        MethodScope methodScope = currentScope.methodScope();
        if (methodScope == null || methodScope.extraSyntheticArguments == null) {
            return;
        }
        final SyntheticArgumentBinding[] extraSyntheticArguments = methodScope.extraSyntheticArguments;
        ASTVisitor findBaseCalls = new ASTVisitor(){

            @Override
            public boolean visit(BaseCallMessageSend messageSend, BlockScope scope) {
                TypeBinding receiverType = messageSend._receiver.resolvedType;
                if (receiverType != null && receiverType.isValidBinding()) {
                    SyntheticArgumentBinding[] syntheticArgumentBindingArray = extraSyntheticArguments;
                    int n = extraSyntheticArguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SyntheticArgumentBinding synthArg = syntheticArgumentBindingArray[n2];
                        if (TypeBinding.equalsEquals(synthArg.type, receiverType)) {
                            lambda.addSyntheticArgument(synthArg);
                        }
                        ++n2;
                    }
                }
                return super.visit(messageSend, scope);
            }
        };
        lambda.body.traverse(findBaseCalls, currentScope);
    }
}

