/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.IGenerateTypeCheck;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class TypePattern
extends Pattern
implements IGenerateTypeCheck {
    public LocalDeclaration local;
    private boolean isEitherOrPattern = false;

    public TypePattern(LocalDeclaration local) {
        this.local = local;
    }

    public static TypePattern createTypePattern(LocalDeclaration lokal) {
        if (lokal.name.length == 1 && lokal.name[0] == '_') {
            return new TypePattern(lokal){

                @Override
                public boolean isUnnamed() {
                    return true;
                }
            };
        }
        return new TypePattern(lokal);
    }

    @Override
    public TypeReference getType() {
        return this.local.type;
    }

    @Override
    public void setIsEitherOrPattern() {
        this.isEitherOrPattern = true;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] localVariableBindingArray;
        if (this.isUnnamed() || this.local.binding == null) {
            localVariableBindingArray = NO_VARIABLES;
        } else {
            LocalVariableBinding[] localVariableBindingArray2 = new LocalVariableBinding[1];
            localVariableBindingArray = localVariableBindingArray2;
            localVariableBindingArray2[0] = this.local.binding;
        }
        return localVariableBindingArray;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.local.analyseCode(currentScope, flowContext, flowInfo);
        FlowInfo patternInfo = flowInfo.copy();
        if (this.isUnnamed()) {
            return patternInfo;
        }
        patternInfo.markAsDefinitelyAssigned(this.local.binding);
        if (!this.isTotalTypeNode) {
            patternInfo.markAsDefinitelyNonNull(this.local.binding);
        } else if (flowContext.associatedNode instanceof SwitchStatement) {
            SwitchStatement swStmt = (SwitchStatement)flowContext.associatedNode;
            int nullStatus = swStmt.containsNull ? 4 : swStmt.expression.nullStatus(patternInfo, flowContext);
            patternInfo.markNullStatus(this.local.binding, nullStatus);
        }
        return patternInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, BranchLabel patternMatchLabel, BranchLabel matchFailLabel) {
        this.generateTestingConversion(currentScope, codeStream);
        if (this.isUnnamed()) {
            if (this.getEnclosingPattern() == null || this.isTotalTypeNode) {
                switch (this.local.binding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.pop2();
                        break;
                    }
                    default: {
                        codeStream.pop();
                        break;
                    }
                }
            }
        } else {
            if (!this.isTotalTypeNode) {
                boolean checkCast;
                boolean bl = JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(currentScope.compilerOptions()) ? !this.local.binding.type.isBaseType() : (checkCast = true);
                if (checkCast) {
                    codeStream.checkcast(this.local.binding.type);
                }
            }
            this.local.generateCode(currentScope, codeStream);
        }
    }

    public void generateTypeCheck(BlockScope scope, CodeStream codeStream, BranchLabel internalFalseLabel) {
        this.generateTypeCheck(this.outerExpressionType, this.getType(), scope, codeStream, internalFalseLabel, Pattern.findPrimitiveConversionRoute(this.resolvedType, this.accessorMethod.returnType, scope));
    }

    @Override
    public void setPatternIsTotalType() {
        this.isTotalTypeNode = true;
    }

    @Override
    public void generateTestingConversion(BlockScope scope, CodeStream codeStream) {
        TypeBinding provided = this.outerExpressionType;
        TypeBinding expected = this.resolvedType;
        Pattern.PrimitiveConversionRoute route = Pattern.findPrimitiveConversionRoute(expected, provided, scope);
        switch (route) {
            case IDENTITY_CONVERSION: {
                break;
            }
            case WIDENING_PRIMITIVE_CONVERSION: 
            case NARROWING_PRIMITVE_CONVERSION: 
            case WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION: {
                this.computeConversion(scope, expected, provided);
                codeStream.generateImplicitConversion(this.implicitConversion);
                break;
            }
            case BOXING_CONVERSION: 
            case BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION: {
                codeStream.generateBoxingConversion(provided.id);
                break;
            }
            case WIDENING_REFERENCE_AND_UNBOXING_COVERSION: {
                codeStream.generateUnboxingConversion(expected.id);
                break;
            }
            case WIDENING_REFERENCE_AND_UNBOXING_COVERSION_AND_WIDENING_PRIMITIVE_CONVERSION: {
                int rhsUnboxed = TypeIds.box2primitive(provided.superclass().id);
                codeStream.generateUnboxingConversion(rhsUnboxed);
                this.computeConversion(scope, expected, TypeBinding.wellKnownBaseType(rhsUnboxed));
                codeStream.generateImplicitConversion(this.implicitConversion);
                break;
            }
            case NARROWING_AND_UNBOXING_CONVERSION: {
                TypeBinding boxType = scope.environment().computeBoxingType(expected);
                codeStream.checkcast(boxType);
                codeStream.generateUnboxingConversion(expected.id);
                break;
            }
            case UNBOXING_CONVERSION: {
                codeStream.generateUnboxingConversion(expected.id);
                break;
            }
            case UNBOXING_AND_WIDENING_PRIMITIVE_CONVERSION: {
                this.computeConversion(scope, expected, provided);
                codeStream.generateImplicitConversion(this.implicitConversion);
                break;
            }
        }
    }

    @Override
    public boolean isUnconditional(TypeBinding t, Scope scope) {
        boolean bl;
        if (TypeBinding.equalsEquals(t, this.resolvedType)) {
            return true;
        }
        Pattern.PrimitiveConversionRoute route = TypePattern.findPrimitiveConversionRoute(this.resolvedType, t, scope);
        switch (route) {
            case IDENTITY_CONVERSION: 
            case BOXING_CONVERSION: 
            case BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION: {
                bl = true;
                break;
            }
            case WIDENING_PRIMITIVE_CONVERSION: {
                bl = BaseTypeBinding.isExactWidening(this.resolvedType.id, t.id);
                break;
            }
            case NO_CONVERSION_ROUTE: {
                if (!this.resolvedType.isPrimitiveOrBoxedPrimitiveType() || !t.isPrimitiveOrBoxedPrimitiveType()) {
                    bl = t.isCompatibleWith(this.resolvedType);
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean dominates(Pattern p) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (p.resolvedType == null || this.resolvedType == null) {
            return false;
        }
        if (p.resolvedType.isSubtypeOf(this.resolvedType, false)) {
            return true;
        }
        return p.resolvedType.erasure().findSuperTypeOriginatingFrom(this.resolvedType.erasure()) != null;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        RecordComponentBinding[] components;
        ReferenceBinding recType;
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Pattern enclosingPattern = this.getEnclosingPattern();
        if ((this.local.type == null || this.local.type.isTypeNameVar(scope)) && enclosingPattern instanceof RecordPattern && (recType = (ReferenceBinding)enclosingPattern.resolvedType) != null && (components = recType.components()).length > this.index) {
            RecordComponentBinding rcb = components[this.index];
            if (rcb.type != null && (rcb.tagBits & 0x80L) != 0L) {
                scope.problemReporter().invalidType(this, rcb.type);
            }
            TypeBinding[] mentionedTypeVariables = rcb.type != null ? rcb.type.syntheticTypeVariablesMentioned() : Binding.NO_TYPE_VARIABLES;
            TypeBinding typeBinding = this.resolvedType = mentionedTypeVariables.length > 0 ? rcb.type.upwardsProjection(scope, mentionedTypeVariables) : rcb.type;
            if (this.local.type != null) {
                this.local.type.resolvedType = this.resolvedType;
            }
        }
        this.local.resolve(scope, true);
        if (this.local.binding != null) {
            this.local.binding.modifiers |= 0x10000000;
            CompilerOptions compilerOptions = scope.compilerOptions();
            if (!JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(compilerOptions.sourceLevel, compilerOptions.enablePreviewFeatures) && enclosingPattern != null) {
                this.local.binding.useFlag = 1;
            }
            if (this.local.type != null) {
                this.resolvedType = this.local.binding.type;
            }
        }
        if (this.isEitherOrPattern && !this.isUnnamed()) {
            scope.problemReporter().namedPatternVariablesDisallowedHere(this.local);
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.local.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.local.printAsExpression(indent, output);
    }
}

