/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.bcel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassLoaderRepository;
import org.eclipse.objectteams.otre.ClassLoaderAccess;
import org.eclipse.objectteams.otre.bcel.DietClassParser;
import org.eclipse.objectteams.otre.bcel.DietJavaClass;

public class DietClassLoaderRepository
extends ClassLoaderRepository {
    Object dietClassLoaderRepository_loader;

    public DietClassLoaderRepository(Object loader) {
        super(loader instanceof ClassLoader ? (ClassLoader)loader : null);
        this.dietClassLoaderRepository_loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass c = this.findClass(className);
        if (c != null) {
            return c;
        }
        try {
            InputStream is = ClassLoaderAccess.getResourceAsStream(this.dietClassLoaderRepository_loader, classFile + ".class");
            if (is == null) {
                throw new ClassNotFoundException(className + " not found.");
            }
            DietClassParser parser = new DietClassParser(is, className);
            c = parser.parse();
            DietClassLoaderRepository dietClassLoaderRepository = this;
            synchronized (dietClassLoaderRepository) {
                this.storeClass(c);
            }
            return c;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClass loadClassFully(String className) throws ClassNotFoundException {
        JavaClass c = this.findClass(className);
        if (c != null) {
            if (!(c instanceof DietJavaClass)) {
                return c;
            }
            DietClassLoaderRepository dietClassLoaderRepository = this;
            synchronized (dietClassLoaderRepository) {
                this.removeClass(c);
            }
        }
        return super.loadClass(className);
    }
}

