/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.MethodBinding;

public class SubBoundBaseMethodRedefinition
extends ObjectTeamsTransformation {
    public SubBoundBaseMethodRedefinition(Object loader) {
        super(loader);
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        this.factory = new InstructionFactory(cg);
        this.checkReadClassAttributes(ce, cg, class_name, cpg);
        List<MethodBinding> mbsForClass = CallinBindingManager.getMethodBindingsForBaseClass(class_name);
        if (mbsForClass.isEmpty()) {
            return;
        }
        List<MethodBinding> inheritedBoundMethods = SubBoundBaseMethodRedefinition.getInheritedBoundMethods(mbsForClass, cg);
        this.addSubBoundMethodRedefinitions(inheritedBoundMethods, ce, cg);
    }

    private void addSubBoundMethodRedefinitions(List<MethodBinding> inheritedBoundMethods, ClassEnhancer ce, ClassGen cg) {
        LinkedList<CallSite> alreadyAddedRedefinitions = new LinkedList<CallSite>();
        for (MethodBinding mb : inheritedBoundMethods) {
            String baseMethodKey = mb.getBaseMethodName() + "." + mb.getBaseMethodSignature();
            if (alreadyAddedRedefinitions.contains(baseMethodKey)) continue;
            Method m = this.genMethodRedefinition(mb, cg);
            ce.addMethod(m, cg);
            if (logging) {
                SubBoundBaseMethodRedefinition.printLogMessage("Added " + baseMethodKey + " to " + cg.getClassName());
            }
            alreadyAddedRedefinitions.add((CallSite)((Object)baseMethodKey));
        }
    }

    private Method genMethodRedefinition(MethodBinding mb, ClassGen cg) {
        boolean staticMethod = mb.hasStaticBaseMethod();
        short invocationKind = staticMethod ? (short)184 : 183;
        String methodName = mb.getBaseMethodName();
        String methodSignature = mb.getBaseMethodSignature();
        String className = mb.getBaseClassName();
        Type returnType = Type.getReturnType((String)methodSignature);
        Type[] argTypes = Type.getArgumentTypes((String)methodSignature);
        InstructionList il = new InstructionList();
        int accFlags = 1;
        if (staticMethod) {
            accFlags |= 8;
        }
        MethodGen redefinition = new MethodGen(accFlags, returnType, argTypes, null, methodName, className, il, cg.getConstantPool());
        if (!staticMethod) {
            il.append(InstructionFactory.createThis());
        }
        int index = 1;
        int i = 0;
        while (i < argTypes.length) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)index));
            index += argTypes[i].getSize();
            ++i;
        }
        il.append((Instruction)this.factory.createInvoke(cg.getSuperclassName(), methodName, returnType, argTypes, invocationKind));
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        redefinition.removeNOPs();
        il.setPositions();
        redefinition.setMaxStack();
        redefinition.setMaxLocals();
        return redefinition.getMethod();
    }

    private static List<MethodBinding> getInheritedBoundMethods(List<MethodBinding> mbsForClass, ClassGen cg) {
        LinkedList<MethodBinding> inheritedBoundMethod = new LinkedList<MethodBinding>();
        for (MethodBinding mb : mbsForClass) {
            if (cg.containsMethod(mb.getBaseMethodName(), mb.getBaseMethodSignature()) != null) continue;
            inheritedBoundMethod.add(mb);
        }
        return inheritedBoundMethod;
    }
}

