/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelReconcileListener;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.BinaryRoleType;
import org.eclipse.objectteams.otdt.internal.core.CallinMapping;
import org.eclipse.objectteams.otdt.internal.core.CalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.CalloutToFieldMapping;
import org.eclipse.objectteams.otdt.internal.core.MappingElementInfo;
import org.eclipse.objectteams.otdt.internal.core.OTModel;
import org.eclipse.objectteams.otdt.internal.core.OTType;
import org.eclipse.objectteams.otdt.internal.core.RoleFileType;
import org.eclipse.objectteams.otdt.internal.core.RoleType;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class OTModelManager {
    public static final String EXTERNAL_PROJECT_NAME = " ";
    private static final OTModel MAPPING = OTModel.getSharedInstance();
    private static OTModelManager singleton;
    private OTModelReconcileListener reconcileListener;

    protected OTModelManager() {
        singleton = this;
        this.reconcileListener = new OTModelReconcileListener();
        JavaCore.addElementChangedListener(this.reconcileListener, 4);
    }

    public static OTModelManager getSharedInstance() {
        if (singleton == null) {
            new OTModelManager();
        }
        return singleton;
    }

    public static void dispose() {
        if (singleton != null) {
            JavaCore.removeElementChangedListener(OTModelManager.singleton.reconcileListener);
            OTModel.dispose();
        }
        singleton = null;
    }

    public void addUnopenedType(IType type) {
        MAPPING.addUnopenedType(type);
    }

    public IOTType addType(IType elem, int typeDeclFlags, String baseClassName, String baseClassAnchor, boolean isRoleFile) {
        IJavaElement parent = elem.getParent();
        OTType result = null;
        while (parent != null) {
            switch (parent.getElementType()) {
                case 5: 
                case 6: {
                    if (TypeHelper.isRole(typeDeclFlags)) {
                        if (elem.isBinary()) {
                            result = new BinaryRoleType(elem, parent, typeDeclFlags, baseClassName, baseClassAnchor);
                            MAPPING.addOTElement(result);
                        } else if (isRoleFile) {
                            result = new RoleFileType(elem, parent, typeDeclFlags, baseClassName, baseClassAnchor);
                            MAPPING.addOTElement(result);
                        } else {
                            result = new RoleType(elem, parent, typeDeclFlags, baseClassName, baseClassAnchor);
                            MAPPING.addOTElement(result);
                        }
                    } else if (TypeHelper.isTeam(typeDeclFlags)) {
                        result = new OTType(100, elem, null, typeDeclFlags);
                        MAPPING.addOTElement(result);
                    }
                    return result;
                }
                case 7: {
                    IType encType = (IType)parent;
                    IOTType otmParent = MAPPING.getOTElement(encType);
                    return this.maybeAddRoleType(elem, otmParent, typeDeclFlags, baseClassName, baseClassAnchor);
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    new Throwable("Warning: unexpected parent for OT element: " + String.valueOf(parent)).printStackTrace();
                    return result;
                }
            }
            parent = parent.getParent();
        }
        return result;
    }

    private IOTType maybeAddRoleType(IType elem, IOTType otmParent, int typeDeclFlags, String baseClassName, String baseClassAnchor) {
        RoleType result = null;
        if (otmParent != null && (TypeHelper.isTeam(otmParent.getFlags()) || TypeHelper.isRole(otmParent.getFlags()))) {
            result = new RoleType(elem, (IJavaElement)otmParent, typeDeclFlags, baseClassName, baseClassAnchor);
            MAPPING.addOTElement(result);
        }
        return result;
    }

    public ICallinMapping addCallinBinding(IType role, MappingElementInfo info) {
        IOTType otmRole = MAPPING.getOTElement(role);
        if (otmRole != null && otmRole instanceof IRoleType) {
            MethodData corrRoleMethData = info.getRoleMethod();
            IMethod correspondingRoleMethod = role.getMethod(corrRoleMethData.getSelector(), corrRoleMethData.getArgumentTypes());
            return new CallinMapping(info.getDeclarationSourceStart(), info.getSourceStart(), info.getSourceEnd(), info.getDeclarationSourceEnd(), (IRoleType)otmRole, correspondingRoleMethod, info.getCallinName(), info.getCallinKind(), info.getRoleMethod(), info.getBaseMethods(), info.hasSignature());
        }
        return null;
    }

    public ICalloutMapping addCalloutBinding(IType role, MappingElementInfo info) {
        IOTType otmRole = MAPPING.getOTElement(role);
        if (otmRole != null && otmRole instanceof IRoleType) {
            MethodData corrRoleMethData = info.getRoleMethod();
            IMethod correspondingRoleMethod = role.getMethod(corrRoleMethData.getSelector(), corrRoleMethData.getArgumentTypes());
            MethodData[] baseMethods = info.getBaseMethods();
            return new CalloutMapping(info.getDeclarationSourceStart(), info.getSourceStart(), info.getSourceEnd(), info.getDeclarationSourceEnd(), role, correspondingRoleMethod, info.getRoleMethod(), baseMethods == null ? null : baseMethods[0], info.hasSignature(), info.isOverride(), info.getDeclaredModifiers(), true);
        }
        return null;
    }

    public ICalloutToFieldMapping addCalloutToFieldBinding(IType role, MappingElementInfo info) {
        IOTType otmRole = MAPPING.getOTElement(role);
        if (otmRole != null && otmRole instanceof IRoleType) {
            MethodData corrRoleMethData = info.getRoleMethod();
            IMethod correspondingRoleMethod = role.getMethod(corrRoleMethData.getSelector(), corrRoleMethData.getArgumentTypes());
            return new CalloutToFieldMapping(info.getDeclarationSourceStart(), info.getSourceStart(), info.getSourceEnd(), info.getDeclarationSourceEnd(), role, correspondingRoleMethod, info.getRoleMethod(), info.getBaseField(), info.hasSignature(), info.isOverride(), info.getDeclaredModifiers(), true);
        }
        return null;
    }

    public void addOTElement(IOTType otType) {
        MAPPING.addOTElement(otType);
    }

    public static IOTType getOTElement(@Nullable IType type) {
        if (type != null) {
            type.exists();
            return MAPPING.getOTElement(type);
        }
        return null;
    }

    public static boolean hasOTElementFor(@Nullable IType type) {
        if (type != null) {
            type.exists();
            return MAPPING.hasOTElementFor(type);
        }
        return false;
    }

    public static void removeOTElement(IType type) {
        OTModelManager.removeOTElement(type, false);
    }

    public static void removeOTElement(IType type, boolean hasChanged) {
        MAPPING.removeOTElement(type, hasChanged);
    }

    public static boolean isRole(IType type) {
        IOTType ottype = OTModelManager.getOTElement(type);
        return ottype != null && ottype.isRole();
    }

    public static boolean isTeam(IType type) {
        if (OTModelManager.hasOTElementFor(type)) {
            IOTType ottype = OTModelManager.getOTElement(type);
            return ottype.isTeam();
        }
        try {
            return type.exists() && Flags.isTeam(type.getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean belongsToRole(IMember member) {
        IType enclosing = member.getDeclaringType();
        if (enclosing != null) {
            IOTType otType = OTModelManager.getOTElement(enclosing);
            return otType != null && otType.isRole();
        }
        return false;
    }
}

