/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class WithinStatement
extends Block
implements IOTConstants {
    private static final String SAVE_VAR_PREFIX = "_OT$save";
    private static final String TEAM_VAR_PREFIX = "_OT$team$";
    public static final char[] ACTIVATE_NAME = "activate".toCharArray();
    public static final char[] DEACTIVATE_NAME = "deactivate".toCharArray();
    public static final char[] SAVE_STATE_NAME = "_OT$saveActivationState".toCharArray();
    public static final char[] RESTORE_ACTIVATION_NAME = "_OT$restoreActivationState".toCharArray();
    private char[] teamVarName;
    private LocalDeclaration teamVarDecl;
    private Statement body;

    public WithinStatement(Expression teamExpr, Statement action, int s, int e) {
        super(2);
        Block actionBlock;
        this.sourceStart = s;
        this.sourceEnd = e;
        AstGenerator gen = new AstGenerator(s, e);
        this.teamVarName = (TEAM_VAR_PREFIX + s).toCharArray();
        char[] saveVarName = (SAVE_VAR_PREFIX + s).toCharArray();
        this.teamVarDecl = gen.localVariable(this.teamVarName, gen.qualifiedTypeReference(ORG_OBJECTTEAMS_ITEAM), teamExpr);
        LocalDeclaration saveVarDecl = gen.localVariable(saveVarName, gen.singleTypeReference(TypeBinding.INT), (Expression)this.teamMethodInvocation(SAVE_STATE_NAME, gen, null));
        MessageSend activateSend = this.teamMethodInvocation(ACTIVATE_NAME, gen, null);
        this.body = action;
        if (action instanceof Block) {
            actionBlock = (Block)action;
        } else {
            actionBlock = new Block(0);
            actionBlock.statements = new Statement[]{action};
            actionBlock.sourceStart = action.sourceStart;
            actionBlock.sourceEnd = action.sourceEnd;
        }
        Block deactivateBlock = new Block(0);
        deactivateBlock.sourceStart = s;
        deactivateBlock.sourceEnd = e;
        deactivateBlock.statements = new Statement[]{this.teamMethodInvocation(RESTORE_ACTIVATION_NAME, gen, gen.singleNameReference(saveVarName))};
        TryStatement tryStatement = new TryStatement();
        tryStatement.sourceStart = s;
        tryStatement.sourceEnd = e;
        tryStatement.tryBlock = actionBlock;
        tryStatement.finallyBlock = deactivateBlock;
        this.statements = new Statement[]{this.teamVarDecl, saveVarDecl, activateSend, tryStatement};
    }

    private MessageSend teamMethodInvocation(char[] methodName, AstGenerator gen, Expression arg) {
        Expression[] expressionArray;
        SubstitutedReference substitutedReference = new SubstitutedReference(this.teamVarName, gen.pos);
        if (arg == null) {
            expressionArray = new Expression[]{};
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = arg;
        }
        return gen.messageSend(substitutedReference, methodName, expressionArray);
    }

    @Override
    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope, this.explicitDeclarations);
        Expression teamExpr = this.teamVarDecl.initialization;
        teamExpr.resolve(this.scope);
        TypeBinding tb = teamExpr.resolvedType;
        if (!(tb instanceof ReferenceBinding) || !((ReferenceBinding)tb).isTeam()) {
            this.scope.problemReporter().withinStatementNeedsTeamInstance(teamExpr);
            return;
        }
        this.teamVarDecl.initialization = null;
        this.teamVarDecl.resolve(this.scope);
        this.teamVarDecl.initialization = teamExpr;
        int i = 1;
        while (i < this.statements.length) {
            this.statements[i].resolve(this.scope);
            ++i;
        }
    }

    public Expression getTeamExpression() {
        return this.teamVarDecl.initialization;
    }

    public Block getAction() {
        Statement tryAction = this.statements[3];
        if (tryAction instanceof TryStatement) {
            return ((TryStatement)tryAction).tryBlock;
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.getTeamExpression().traverse(visitor, blockScope);
            Block action = this.getAction();
            if (action != null) {
                ((ASTNode)action).traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public StringBuilder print(int indent, StringBuilder output) {
        WithinStatement.printIndent(indent, output);
        output.append("within (");
        this.teamVarDecl.initialization.printExpression(0, output).append(")\n");
        this.body.print(indent + 1, output).append(";");
        return output;
    }

    public class SubstitutedReference
    extends SingleNameReference {
        public SubstitutedReference(char[] teamVarName, long pos) {
            super(teamVarName, pos);
        }

        public Expression getExpression() {
            return WithinStatement.this.teamVarDecl.initialization;
        }
    }
}

