/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;
    ReferenceBinding[] typesPerToken;

    @Override
    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        super.setBaseclassDecapsulation(state);
        if (this.typeArguments != null) {
            TypeReference[][] typeReferenceArray = this.typeArguments;
            int n = this.typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference[] arguments = typeReferenceArray[n2];
                if (arguments != null) {
                    TypeReference[] typeReferenceArray2 = arguments;
                    int n3 = arguments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TypeReference argument = typeReferenceArray2[n4];
                        if (argument != null) {
                            argument.setBaseclassDecapsulation(state);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public ParameterizedQualifiedTypeReference(char[][] tokens, TypeReference[][] typeArguments, int dim, long[] positions) {
        super(tokens, dim, positions);
        this.typeArguments = typeArguments;
        int i = 0;
        int max = typeArguments.length;
        block0: while (i < max) {
            TypeReference[] typeArgumentsOnTypeComponent = typeArguments[i];
            if (typeArgumentsOnTypeComponent != null) {
                int j = 0;
                int max2 = typeArgumentsOnTypeComponent.length;
                while (j < max2) {
                    if ((typeArgumentsOnTypeComponent[j].bits & 0x100000) != 0) {
                        this.bits |= 0x100000;
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public ParameterizedQualifiedTypeReference(char[][] tokens, TypeReference[][] typeArguments, int dim, Annotation[][] annotationsOnDimensions, long[] positions) {
        this(tokens, typeArguments, dim, positions);
        this.setAnnotationsOnDimensions(annotationsOnDimensions);
        if (annotationsOnDimensions != null) {
            this.bits |= 0x100000;
        }
    }

    @Override
    public void checkBounds(Scope scope) {
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding type, Scope scope, int index) {
        ParameterizedTypeBinding parameterizedType;
        ReferenceBinding currentType;
        TypeVariableBinding[] typeVariables;
        ReferenceBinding enclosingType;
        if (index > 0 && (enclosingType = this.typesPerToken[index - 1]) != null) {
            this.checkBounds(enclosingType, scope, index - 1);
        }
        if (type.isParameterizedTypeWithActualArguments() && (typeVariables = (currentType = (parameterizedType = (ParameterizedTypeBinding)type).genericType()).typeVariables()) != null) {
            parameterizedType.boundCheck(scope, this.typeArguments[index]);
        }
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int additionalDimensions, Annotation[][] additionalAnnotations, boolean isVarargs) {
        int totalDimensions = this.dimensions() + additionalDimensions;
        Annotation[][] allAnnotations = this.getMergedAnnotationsOnDimensions(additionalDimensions, additionalAnnotations);
        ParameterizedQualifiedTypeReference pqtr = new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, totalDimensions, allAnnotations, this.sourcePositions);
        pqtr.annotations = this.annotations;
        pqtr.bits |= this.bits & 0x100000;
        if (!isVarargs) {
            pqtr.extendedDimensions = additionalDimensions;
        }
        return pqtr;
    }

    @Override
    public boolean isParameterizedTypeReference() {
        return true;
    }

    @Override
    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition position) {
        if (super.hasNullTypeAnnotation(position)) {
            return true;
        }
        if (position == TypeReference.AnnotationPosition.ANY) {
            if (this.resolvedType != null && !this.resolvedType.hasNullTypeAnnotations()) {
                return false;
            }
            if (this.typeArguments != null) {
                TypeReference[][] typeReferenceArray = this.typeArguments;
                int n = this.typeArguments.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeReference[] arguments = typeReferenceArray[n2];
                    if (arguments != null) {
                        TypeReference[] typeReferenceArray2 = arguments;
                        int n3 = arguments.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TypeReference argument = typeReferenceArray2[n4];
                            if (argument.hasNullTypeAnnotation(position)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int length = this.tokens.length;
        char[][] qParamName = new char[length][];
        int i = 0;
        while (i < length) {
            TypeReference[] arguments = this.typeArguments[i];
            if (arguments == null) {
                qParamName[i] = this.tokens[i];
            } else {
                StringBuilder buffer = new StringBuilder(5);
                buffer.append(this.tokens[i]);
                buffer.append('<');
                int j = 0;
                int argLength = arguments.length;
                while (j < argLength) {
                    if (j > 0) {
                        buffer.append(',');
                    }
                    buffer.append(CharOperation.concatWith(arguments[j].getParameterizedTypeName(), '.'));
                    ++j;
                }
                buffer.append('>');
                int nameLength = buffer.length();
                qParamName[i] = new char[nameLength];
                buffer.getChars(0, nameLength, qParamName[i], 0);
            }
            ++i;
        }
        int dim = this.dimensions;
        if (dim > 0) {
            char[] dimChars = new char[dim * 2];
            int i2 = 0;
            while (i2 < dim) {
                int index = i2 * 2;
                dimChars[index] = 91;
                dimChars[index + 1] = 93;
                ++i2;
            }
            qParamName[length - 1] = CharOperation.concat(qParamName[length - 1], dimChars);
        }
        return qParamName;
    }

    @Override
    public TypeReference[][] getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean checkBounds, int location) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding type = this.resolvedType.closestMatch();
                    return type;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding type = this.internalResolveLeafType(scope, checkBounds);
        this.createArrayType(scope);
        this.resolveAnnotations(scope, location);
        if (this.dimensions > 0) {
            this.resolvedType = ArrayTypeReference.maybeMarkArrayContentsNonNull(scope, this.resolvedType, this.sourceStart, this.dimensions, null);
        }
        if (this.typeArguments != null) {
            this.checkIllegalNullAnnotations(scope, this.typeArguments[this.typeArguments.length - 1]);
        }
        return type == null ? type : this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, boolean checkBounds) {
        boolean isClassScope = scope.kind == 3;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            int i = 0;
            int max = this.tokens.length;
            while (i < max) {
                TypeReference[] args = this.typeArguments[i];
                if (args != null) {
                    int argLength = args.length;
                    int j = 0;
                    while (j < argLength) {
                        TypeReference typeArgument = args[j];
                        if (isClassScope) {
                            typeArgument.resolveType((ClassScope)scope);
                        } else {
                            typeArgument.resolveType((BlockScope)scope, checkBounds);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        this.rejectAnnotationsOnPackageQualifiers(scope, packageBinding);
        boolean typeIsConsistent = true;
        ReferenceBinding qualifyingType = null;
        int max = this.tokens.length;
        this.typesPerToken = new ReferenceBinding[max];
        int i = packageBinding == null ? 0 : packageBinding.compoundName.length;
        while (i < max) {
            TypeReference[] args;
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                int j = i;
                while (j < max) {
                    args = this.typeArguments[j];
                    if (args != null) {
                        int argLength = args.length;
                        int k = 0;
                        while (k < argLength) {
                            TypeReference typeArgument = args[k];
                            if (isClassScope) {
                                typeArgument.resolveType((ClassScope)scope);
                            } else {
                                typeArgument.resolveType((BlockScope)scope);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                return null;
            }
            ReferenceBinding currentType = (ReferenceBinding)this.resolvedType;
            if (qualifyingType == null) {
                qualifyingType = currentType.enclosingType();
                if (qualifyingType != null && currentType.hasEnclosingInstanceContext()) {
                    qualifyingType = scope.environment().convertToParameterizedType(qualifyingType);
                }
            } else {
                ReferenceBinding enclosingType;
                if (this.annotations != null) {
                    ParameterizedQualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, currentType, this.annotations[i - 1]);
                }
                if (typeIsConsistent && currentType.isStatic() && (qualifyingType.isParameterizedTypeWithActualArguments() || qualifyingType.isGenericType())) {
                    scope.problemReporter().staticMemberOfParameterizedType(this, currentType, qualifyingType, i);
                    typeIsConsistent = false;
                    qualifyingType = qualifyingType.actualType();
                }
                if ((enclosingType = currentType.enclosingType()) != null && TypeBinding.notEquals(enclosingType.erasure(), qualifyingType.erasure())) {
                    qualifyingType = enclosingType;
                }
            }
            if ((args = this.typeArguments[i]) != null) {
                TypeVariableBinding[] typeVariables;
                int argLength;
                TypeReference keep = null;
                if (isClassScope) {
                    keep = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                boolean isDiamond = (argLength = args.length) == 0 && i == max - 1 && (this.bits & 0x80000) != 0;
                TypeBinding[] argTypes = new TypeBinding[argLength];
                boolean argHasError = false;
                ReferenceBinding currentOriginal = (ReferenceBinding)currentType.original();
                int j = 0;
                while (j < argLength) {
                    TypeReference arg = args[j];
                    if (arg instanceof TypeAnchorReference) {
                        scope.problemReporter().valueParamWrongPosition((TypeAnchorReference)arg);
                        argHasError = true;
                    } else {
                        TypeBinding argType;
                        TypeBinding typeBinding = argType = isClassScope ? arg.resolveTypeArgument((ClassScope)scope, currentOriginal, j) : arg.resolveTypeArgument((BlockScope)scope, currentOriginal, j);
                        if (argType == null) {
                            argHasError = true;
                        } else {
                            argTypes[j] = argType;
                        }
                    }
                    ++j;
                }
                if (argHasError) {
                    return null;
                }
                if (isClassScope) {
                    ((ClassScope)scope).superTypeReference = keep;
                    if (((ClassScope)scope).detectHierarchyCycle(currentOriginal, this)) {
                        return null;
                    }
                }
                if ((typeVariables = currentOriginal.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    if (scope.compilerOptions().originalSourceLevel >= 0x310000L) {
                        scope.problemReporter().nonGenericTypeCannotBeParameterized(i, this, currentType, argTypes);
                        return null;
                    }
                    this.resolvedType = qualifyingType != null && qualifyingType.isParameterizedType() ? scope.environment().createParameterizedType(currentOriginal, null, qualifyingType) : currentType;
                    return this.resolvedType;
                }
                if (argLength != typeVariables.length && !isDiamond) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, currentType, argTypes, i);
                    return null;
                }
                if (typeIsConsistent) {
                    if (!currentType.hasEnclosingInstanceContext()) {
                        if (qualifyingType != null && qualifyingType.isRawType()) {
                            this.typesPerToken[i - 1] = qualifyingType = qualifyingType.actualType();
                        }
                    } else {
                        ReferenceBinding actualEnclosing = currentType.enclosingType();
                        if (actualEnclosing != null && actualEnclosing.isRawType()) {
                            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(currentOriginal, actualEnclosing), argTypes);
                            typeIsConsistent = false;
                        }
                    }
                }
                ParameterizedTypeBinding parameterizedType = scope.environment().createParameterizedType(currentOriginal, argTypes, qualifyingType);
                if (!isDiamond) {
                    if (checkBounds) {
                        parameterizedType.boundCheck(scope, args);
                    } else {
                        scope.deferBoundCheck(this);
                    }
                } else {
                    parameterizedType.arguments = ParameterizedSingleTypeReference.DIAMOND_TYPE_ARGUMENTS;
                }
                qualifyingType = parameterizedType;
            } else {
                ReferenceBinding currentOriginal = (ReferenceBinding)currentType.original();
                if (isClassScope && ((ClassScope)scope).detectHierarchyCycle(currentOriginal, this)) {
                    return null;
                }
                if (currentOriginal.isGenericType()) {
                    if (typeIsConsistent && qualifyingType != null && qualifyingType.isParameterizedType() && currentOriginal.hasEnclosingInstanceContext()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType(currentOriginal, null, qualifyingType), i);
                        typeIsConsistent = false;
                    }
                    qualifyingType = scope.environment().createRawType(currentOriginal, qualifyingType);
                } else {
                    qualifyingType = scope.environment().maybeCreateParameterizedType(currentOriginal, qualifyingType);
                }
            }
            if (this.isTypeUseDeprecated(qualifyingType, scope)) {
                this.reportDeprecatedType(qualifyingType, scope, i);
            }
            this.resolvedType = qualifyingType;
            this.typesPerToken[i] = qualifyingType;
            this.recordResolution(scope.environment(), this.resolvedType);
            ++i;
        }
        return this.resolvedType;
    }

    private void createArrayType(Scope scope) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        int i;
        int length = this.tokens.length;
        int i2 = 0;
        while (i2 < length - 1) {
            if (this.annotations != null && this.annotations[i2] != null) {
                ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[i2], output);
                output.append(' ');
            }
            output.append(this.tokens[i2]);
            TypeReference[] typeArgument = this.typeArguments[i2];
            if (typeArgument != null) {
                output.append('<');
                int typeArgumentLength = typeArgument.length;
                if (typeArgumentLength > 0) {
                    int max = typeArgumentLength - 1;
                    int j = 0;
                    while (j < max) {
                        typeArgument[j].print(0, output);
                        output.append(", ");
                        ++j;
                    }
                    typeArgument[max].print(0, output);
                }
                output.append('>');
            }
            output.append('.');
            ++i2;
        }
        if (this.annotations != null && this.annotations[length - 1] != null) {
            output.append(" ");
            ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[length - 1], output);
            output.append(' ');
        }
        output.append(this.tokens[length - 1]);
        TypeReference[] typeArgument = this.typeArguments[length - 1];
        if (typeArgument != null) {
            output.append('<');
            int typeArgumentLength = typeArgument.length;
            if (typeArgumentLength > 0) {
                int max = typeArgumentLength - 1;
                int j = 0;
                while (j < max) {
                    typeArgument[j].print(0, output);
                    output.append(", ");
                    ++j;
                }
                typeArgument[max].print(0, output);
            }
            output.append('>');
        }
        Annotation[][] annotationsOnDimensions = this.getAnnotationsOnDimensions();
        if ((this.bits & 0x4000) != 0) {
            i = 0;
            while (i < this.dimensions - 1) {
                if (annotationsOnDimensions != null && annotationsOnDimensions[i] != null) {
                    output.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations(annotationsOnDimensions[i], output);
                    output.append(" ");
                }
                output.append("[]");
                ++i;
            }
            if (annotationsOnDimensions != null && annotationsOnDimensions[this.dimensions - 1] != null) {
                output.append(" ");
                ParameterizedQualifiedTypeReference.printAnnotations(annotationsOnDimensions[this.dimensions - 1], output);
                output.append(" ");
            }
            output.append("...");
        } else {
            i = 0;
            while (i < this.dimensions) {
                if (annotationsOnDimensions != null && annotationsOnDimensions[i] != null) {
                    output.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations(annotationsOnDimensions[i], output);
                    output.append(" ");
                }
                output.append("[]");
                ++i;
            }
        }
        return output;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope, boolean checkBounds, int location) {
        return this.internalResolveType(scope, checkBounds, location);
    }

    @Override
    public TypeBinding resolveType(ClassScope scope, int location) {
        return this.internalResolveType(scope, false, location);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int n;
            int n2;
            Object object;
            Annotation[][] annotationsOnDimensions;
            if (this.annotations != null) {
                int annotationsLevels = this.annotations.length;
                int i = 0;
                while (i < annotationsLevels) {
                    int annotationsLength = this.annotations[i] == null ? 0 : this.annotations[i].length;
                    int j = 0;
                    while (j < annotationsLength) {
                        this.annotations[i][j].traverse(visitor, scope);
                        ++j;
                    }
                    ++i;
                }
            }
            if ((annotationsOnDimensions = this.getAnnotationsOnDimensions(true)) != null) {
                object = annotationsOnDimensions;
                n2 = annotationsOnDimensions.length;
                n = 0;
                while (n < n2) {
                    Annotation[] annotationsOnDimension = object[n];
                    int j = 0;
                    int max2 = annotationsOnDimension == null ? 0 : annotationsOnDimension.length;
                    while (j < max2) {
                        Annotation annotation = annotationsOnDimension[j];
                        annotation.traverse(visitor, scope);
                        ++j;
                    }
                    ++n;
                }
            }
            object = this.typeArguments;
            n2 = this.typeArguments.length;
            n = 0;
            while (n < n2) {
                Annotation[] typeArgument = object[n];
                if (typeArgument != null) {
                    Annotation[] annotationArray = typeArgument;
                    int n3 = typeArgument.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation typeReference = annotationArray[n4];
                        ((TypeReference)((Object)typeReference)).traverse(visitor, scope);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int n;
            int n2;
            Object object;
            Annotation[][] annotationsOnDimensions;
            if (this.annotations != null) {
                int annotationsLevels = this.annotations.length;
                int i = 0;
                while (i < annotationsLevels) {
                    int annotationsLength = this.annotations[i] == null ? 0 : this.annotations[i].length;
                    int j = 0;
                    while (j < annotationsLength) {
                        this.annotations[i][j].traverse(visitor, scope);
                        ++j;
                    }
                    ++i;
                }
            }
            if ((annotationsOnDimensions = this.getAnnotationsOnDimensions(true)) != null) {
                object = annotationsOnDimensions;
                n2 = annotationsOnDimensions.length;
                n = 0;
                while (n < n2) {
                    Annotation[] annotationsOnDimension = object[n];
                    int j = 0;
                    int max2 = annotationsOnDimension == null ? 0 : annotationsOnDimension.length;
                    while (j < max2) {
                        Annotation annotation = annotationsOnDimension[j];
                        annotation.traverse(visitor, scope);
                        ++j;
                    }
                    ++n;
                }
            }
            object = this.typeArguments;
            n2 = this.typeArguments.length;
            n = 0;
            while (n < n2) {
                Annotation[] typeArgument = object[n];
                if (typeArgument != null) {
                    Annotation[] annotationArray = typeArgument;
                    int n3 = typeArgument.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation argument = annotationArray[n4];
                        ((TypeReference)((Object)argument)).traverse(visitor, scope);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void updateWithAnnotations(Scope scope, int location) {
        if (this.resolvedType != null) {
            TypeBinding updatedLeaf;
            int lastToken = this.tokens.length - 1;
            if (this.typesPerToken != null && this.typesPerToken[lastToken] != null) {
                int i = 0;
                while (i <= lastToken) {
                    this.typesPerToken[i] = (ReferenceBinding)this.updateParameterizedTypeWithAnnotations(scope, this.typesPerToken[i], this.typeArguments[i]);
                    ++i;
                }
                updatedLeaf = this.typesPerToken[lastToken];
            } else {
                updatedLeaf = this.updateParameterizedTypeWithAnnotations(scope, this.resolvedType, this.typeArguments[lastToken]);
            }
            if (updatedLeaf != this.resolvedType.leafComponentType()) {
                this.resolvedType = this.dimensions > 0 && this.dimensions <= 255 ? scope.createArrayType(updatedLeaf, this.dimensions) : updatedLeaf;
            }
        }
        this.resolveAnnotations(scope, location);
    }
}

