/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;

public class RoleFileHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getTeamOfRoleFile(CompilationUnitDeclaration roleUnit, TypeDeclaration roleType, LookupEnvironment environment) {
        int teamState;
        if (roleType.compilationUnit == null) {
            roleType.compilationUnit = roleUnit;
        }
        if (roleUnit.currentPackage == null) {
            if (roleUnit.ignoreFurtherInvestigation) return;
            ProblemReporter problemReporter = environment.problemReporter;
            problemReporter.referenceContext = roleType;
            try {
                problemReporter.roleFileMissingTeamDeclaration(roleUnit);
                return;
            }
            finally {
                problemReporter.referenceContext = null;
            }
        }
        boolean sourceTypeReqSave = Config.getSourceTypeRequired();
        Config.setSourceTypeRequired(true);
        char[][] tokens = roleUnit.currentPackage.tokens;
        ReferenceBinding teamBinding = RoleFileHelper.myGetType(environment, roleType, tokens, null);
        if (teamBinding != null && teamBinding.isRole()) {
            teamBinding = teamBinding.roleModel.getClassPartBinding();
        }
        Config.setSourceTypeRequired(sourceTypeReqSave);
        if (teamBinding == null) {
            environment.problemReporter.noEnclosingTeamForRoleFile(roleUnit, roleType);
            roleUnit.currentPackage.modifiers &= 0xFBFFFFFF;
            roleType.modifiers &= 0xFFFEFFFF;
            roleType.tagAsHavingErrors();
            return;
        }
        if (!teamBinding.isTeam()) {
            environment.problemReporter.missingTeamForRoleWithMembers((SourceTypeBinding)teamBinding, roleType);
            if (roleType.binding == null) return;
            roleType.binding.unrolify(roleType);
            return;
        }
        if (!(teamBinding instanceof SourceTypeBinding)) {
            environment.problemReporter.roleFileInBinaryTeam(roleType, teamBinding);
            if (teamBinding.getMemberType(roleType.name) == null) throw new InternalCompilerError("Source Role in Binary Team not yet implemented, please delete the classfile of " + new String(teamBinding.readableName()));
            throw new InternalCompilerError("Binary team " + new String(teamBinding.readableName()) + " already contains this role, yet compilation can't proceed");
        }
        SourceTypeBinding teamSource = (SourceTypeBinding)teamBinding;
        TypeDeclaration teamDecl = teamSource.scope != null ? teamSource.scope.referenceContext : teamSource.getTeamModel().getAst();
        char[][] packageName = roleUnit.currentPackage.tokens;
        if (!CharOperation.equals(packageName[packageName.length - 1], teamBinding.sourceName())) {
            environment.problemReporter.mismatchingPackageForRole(packageName, teamDecl.name, roleUnit.getFileName(), roleUnit.currentPackage.sourceStart, roleUnit.currentPackage.sourceEnd);
        }
        if (roleType.enclosingType == null) {
            AstEdit.addMemberTypeDeclaration(teamDecl, roleType);
        }
        if ((teamState = teamBinding.getTeamModel().getState()) <= 1) return;
        roleType.getRoleModel()._state.requestState(roleType, teamState);
    }

    private static ReferenceBinding myGetType(LookupEnvironment env, TypeDeclaration roleType, char[][] firstTypeName, char[] nestedTypeName) {
        ReferenceBinding firstType = nestedTypeName == null ? env.getTeamForRoFi(firstTypeName, roleType) : env.getType(firstTypeName);
        if (firstType == null && firstTypeName.length > 1) {
            char[][] parentTypeName = new char[firstTypeName.length - 1][];
            System.arraycopy(firstTypeName, 0, parentTypeName, 0, parentTypeName.length);
            firstType = RoleFileHelper.myGetType(env, roleType, parentTypeName, firstTypeName[firstTypeName.length - 1]);
        }
        if (firstType == null) {
            return null;
        }
        if (firstType.problemId() == 4) {
            firstType = ((ProblemReferenceBinding)firstType).closestReferenceMatch();
        }
        if (nestedTypeName == null) {
            return firstType;
        }
        if (firstType.isSynthInterface()) {
            firstType = firstType.getRealClass();
        }
        return firstType.getMemberType(nestedTypeName);
    }

    public static boolean compoundNameMatch(char[][] name1, char[][] name2) {
        char[][] splitName;
        char[][] longerName;
        int remainder;
        int common;
        if (CharOperation.equals(name1, name2)) {
            return true;
        }
        if (name1.length < name2.length) {
            common = name1.length - 1;
            remainder = name2.length - common;
            longerName = name2;
            splitName = CharOperation.splitOn('$', name1[common]);
        } else if (name1.length > name2.length) {
            common = name2.length - 1;
            remainder = name1.length - common;
            longerName = name1;
            splitName = CharOperation.splitOn('$', name2[common]);
        } else {
            return false;
        }
        if (splitName.length != remainder) {
            return false;
        }
        int i = 0;
        while (i < common) {
            if (!CharOperation.equals(name1[i], name2[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < remainder) {
            if (!(CharOperation.equals(splitName[i], longerName[common + i]) || CharOperation.prefixEquals(IOTConstants.OT_DELIM_NAME, splitName[i]) && CharOperation.equals(longerName[common + i], splitName[i], IOTConstants.OT_DELIM_LEN, splitName[i].length))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static CompilationUnitDeclaration getTeamUnit(CompilationUnitDeclaration unit) {
        if (unit.types != null && unit.types.length > 0) {
            CompilationUnitScope teamUnitScope;
            Scope teamTypeScope;
            TypeDeclaration firstType = unit.types[0];
            ClassScope roleScope = firstType.scope;
            if (roleScope != null && (teamTypeScope = roleScope.parent) != null && (teamUnitScope = teamTypeScope.compilationUnitScope()) != null) {
                return teamUnitScope.referenceCompilationUnit();
            }
        }
        return null;
    }
}

