/*******************************************************************************
 * Copyright (c) 2000, 2019 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Technical University Berlin - extended API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int 
		TokenNameNotAToken = 0,
	    TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	int
      TokenNameIdentifier = 17,
      TokenNameabstract = 56,
      TokenNameassert = 86,
      TokenNameboolean = 111,
      TokenNamebreak = 87,
      TokenNamebyte = 112,
      TokenNamecase = 113,
      TokenNamecatch = 114,
      TokenNamechar = 115,
      TokenNameclass = 72,
      TokenNamecontinue = 88,
      TokenNameconst = 147,
      TokenNamedefault = 81,
      TokenNamedo = 89,
      TokenNamedouble = 116,
      TokenNameelse = 128,
      TokenNameenum = 77,
      TokenNameextends = 96,
      TokenNamefalse = 39,
      TokenNamefinal = 57,
      TokenNamefinally = 124,
      TokenNamefloat = 117,
      TokenNamefor = 90,
      TokenNamegoto = 148,
      TokenNameif = 91,
      TokenNameimplements = 143,
      TokenNameimport = 118,
      TokenNameinstanceof = 18,
      TokenNameint = 119,
      TokenNameinterface = 76,
      TokenNamelong = 120,
      TokenNamenative = 58,
      TokenNamenew = 37,
      TokenNamenull = 40,
      TokenNamepackage = 97,
      TokenNameprivate = 59,
      TokenNameprotected = 60,
      TokenNamepublic = 61,
      TokenNamereturn = 92,
      TokenNameshort = 121,
      TokenNamestatic = 51,
      TokenNamestrictfp = 62,
      TokenNamesuper = 35,
      TokenNameswitch = 52,
      TokenNamesynchronized = 54,
      TokenNamethis = 36,
      TokenNamethrow = 83,
      TokenNamethrows = 129,
      TokenNametransient = 63,
      TokenNametrue = 41,
      TokenNametry = 93,
      TokenNamevoid = 122,
      TokenNamevolatile = 64,
      TokenNamewhile = 84,
      TokenNamemodule = 125,
      TokenNameopen = 126,
      TokenNamerequires = 130,
      TokenNametransitive = 136,
      TokenNameexports = 131,
      TokenNameopens = 132,
      TokenNameto = 144,
      TokenNameuses = 133,
      TokenNameprovides = 134,
      TokenNamewith = 98,
      TokenNameas = 137,
      TokenNamebase = 33,
      TokenNamecallin = 65,
      TokenNameplayedBy = 145,
      TokenNameprecedence = 127,
      TokenNameteam = 55,
      TokenNametsuper = 38,
      TokenNamewhen = 99,
      TokenNamewithin = 94,
      TokenNamereplace = 138,
      TokenNameafter = 135,
      TokenNamebefore = 139,
      TokenNameget = 140,
      TokenNameset = 141,
      TokenNameIntegerLiteral = 42,
      TokenNameLongLiteral = 43,
      TokenNameFloatingPointLiteral = 44,
      TokenNameDoubleLiteral = 45,
      TokenNameCharacterLiteral = 46,
      TokenNameStringLiteral = 47,
      TokenNameTextBlock = 48,
      TokenNamePLUS_PLUS = 2,
      TokenNameMINUS_MINUS = 3,
      TokenNameEQUAL_EQUAL = 21,
      TokenNameLESS_EQUAL = 14,
      TokenNameGREATER_EQUAL = 15,
      TokenNameNOT_EQUAL = 22,
      TokenNameLEFT_SHIFT = 19,
      TokenNameRIGHT_SHIFT = 13,
      TokenNameUNSIGNED_RIGHT_SHIFT = 16,
      TokenNamePLUS_EQUAL = 100,
      TokenNameMINUS_EQUAL = 101,
      TokenNameMULTIPLY_EQUAL = 102,
      TokenNameDIVIDE_EQUAL = 103,
      TokenNameAND_EQUAL = 104,
      TokenNameOR_EQUAL = 105,
      TokenNameXOR_EQUAL = 106,
      TokenNameREMAINDER_EQUAL = 107,
      TokenNameLEFT_SHIFT_EQUAL = 108,
      TokenNameRIGHT_SHIFT_EQUAL = 109,
      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 110,
      TokenNameOR_OR = 31,
      TokenNameAND_AND = 30,
      TokenNamePLUS = 4,
      TokenNameMINUS = 5,
      TokenNameNOT = 68,
      TokenNameREMAINDER = 10,
      TokenNameXOR = 26,
      TokenNameAND = 23,
      TokenNameMULTIPLY = 9,
      TokenNameOR = 28,
      TokenNameTWIDDLE = 69,
      TokenNameDIVIDE = 11,
      TokenNameGREATER = 12,
      TokenNameLESS = 8,
      TokenNameLPAREN = 20,
      TokenNameRPAREN = 24,
      TokenNameLBRACE = 53,
      TokenNameRBRACE = 34,
      TokenNameLBRACKET = 6,
      TokenNameRBRACKET = 71,
      TokenNameSEMICOLON = 25,
      TokenNameQUESTION = 29,
      TokenNameCOLON = 66,
      TokenNameCOMMA = 32,
      TokenNameDOT = 1,
      TokenNameEQUAL = 80,
      TokenNameAT = 50,
      TokenNameELLIPSIS = 142,
      TokenNameARROW = 78,
      TokenNameCOLON_COLON = 7,
      TokenNameBeginLambda = 49,
      TokenNameBeginIntersectionCast = 70,
      TokenNameBeginTypeArguments = 82,
      TokenNameElidedSemicolonAndRightBrace = 73,
      TokenNameAT308 = 27,
      TokenNameAT308DOTDOTDOT = 146,
      TokenNameBeginCaseExpr = 74,
      TokenNameRestrictedIdentifierYield = 85,
      TokenNameATOT = 123,
      TokenNameBINDIN = 79,
      TokenNameCALLOUT_OVERRIDE = 95,
      TokenNameSYNTHBINDOUT = 75,
      TokenNameEOF = 67,
      TokenNameERROR = 149;


	// This alias is statically inserted by generateOTParser.sh:
	int TokenNameBINDOUT = TokenNameARROW;
}

