/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class AbstractCreateDispatchCodeAdapter
extends AbstractTransformableClassNode {
    final int teamsAndCallinsSlot;
    private boolean isStatic;
    private Type[] args;

    public AbstractCreateDispatchCodeAdapter(boolean isStatic, int locals) {
        this.isStatic = isStatic;
        this.teamsAndCallinsSlot = locals;
    }

    protected InsnList getDispatchCode(MethodNode method, int joinPointId, int boundMethodId) {
        InsnList instructions = new InsnList();
        this.addLineNumber(instructions, 65534);
        instructions.add(this.createLoadIntConstant(joinPointId));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, ClassNames.TEAM_MANAGER_SLASH, ConstantMembers.getTeamsAndCallinIds.getName(), ConstantMembers.getTeamsAndCallinIds.getSignature(), false));
        instructions.add(this.createInstructionsToCheckTeams(method));
        instructions.add((AbstractInsnNode)new IntInsnNode(58, this.teamsAndCallinsSlot));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, this.teamsAndCallinsSlot));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        instructions.add((AbstractInsnNode)new TypeInsnNode(192, "[Lorg/objectteams/ITeam;"));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        instructions.add((AbstractInsnNode)new InsnNode(95));
        if (this.isStatic) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, ClassNames.I_BOUND_BASE_SLASH));
        }
        instructions.add((AbstractInsnNode)new InsnNode(95));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, this.teamsAndCallinsSlot));
        instructions.add((AbstractInsnNode)new InsnNode(4));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        instructions.add((AbstractInsnNode)new TypeInsnNode(192, "[I"));
        if (boundMethodId == -1) {
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        } else {
            instructions.add(this.createLoadIntConstant(boundMethodId));
        }
        this.args = Type.getArgumentTypes((String)method.desc);
        instructions.add(this.getBoxedArguments(this.args));
        this.addLineNumber(instructions, 65533);
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, ClassNames.ITEAM_SLASH, ConstantMembers.callAllBindingsTeam.getName(), ConstantMembers.callAllBindingsTeam.getSignature(), true));
        this.addLineNumber(instructions, 65534);
        Type returnType = Type.getReturnType((String)method.desc);
        instructions.add(this.getUnboxingInstructionsForReturnValue(returnType));
        return instructions;
    }

    protected void addLocals(MethodNode method) {
        String selector = "_OT$teamsAndCallinIds";
        for (Object lv : method.localVariables) {
            if (!((LocalVariableNode)lv).name.equals(selector)) continue;
            return;
        }
        method.visitLocalVariable(selector, "[Ljava/lang/Object;", null, new Label(), new Label(), this.teamsAndCallinsSlot);
    }

    protected InsnList createInstructionsToCheckTeams(MethodNode method) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new InsnNode(89));
        LabelNode label = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(199, label));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new JumpInsnNode(167, this.findBreakLabel(method.instructions)));
        instructions.add((AbstractInsnNode)label);
        return instructions;
    }

    private LabelNode findBreakLabel(InsnList instructions) {
        int i = instructions.size() - 2;
        while (i >= 0) {
            AbstractInsnNode node = instructions.get(i);
            if (node.getType() == 8) {
                return (LabelNode)node;
            }
            --i;
        }
        throw new RuntimeException("Can't find break label to create dispatch code");
    }

    protected abstract InsnList getBoxedArguments(Type[] var1);

    protected int getMaxLocals() {
        return this.teamsAndCallinsSlot + 1;
    }

    protected int getMaxStack() {
        return 10;
    }
}

