/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.launcher;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class LauncherLabel
extends Canvas {
    private String text;
    private Image image;
    private Font font;
    static final int GAP = 12;
    private static int DRAW_FLAGS = 15;
    private static final int DEFAULT_MARGIN = 5;
    private int leftMargin = 5;
    private int topMargin = 5;
    private int rightMargin = 5;
    private int bottomMargin = 5;
    private Point textSize;
    private static final int MAX_NUMBER_OF_STEPS = 10;
    private int animationStep = 0;

    LauncherLabel(Composite parent, int style) {
        super(parent, style | 0x800 | 0x20000000);
        this.font = parent.getFont();
        this.addPaintListener(event -> this.paintControl(event));
    }

    private void paintControl(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Image bufferImage = new Image((Device)this.getDisplay(), Math.max(1, rect.width), Math.max(1, rect.height));
        GC gc = new GC((Drawable)bufferImage);
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        gc.fillRectangle(rect);
        Point extent = this.getTotalSize(this.image.getBounds().width, this.image.getBounds().height);
        int xImage = (rect.width - this.image.getBounds().width) / 2;
        int yImage = (rect.height - extent.y) / 2;
        gc.drawImage(this.image, xImage, yImage);
        gc.setFont(this.font);
        int xText = (rect.width - this.textSize.x) / 2;
        int yText = yImage + this.image.getBounds().height + 12 - this.textSize.y / 2;
        gc.drawString(this.text, xText, yText);
        if (this.animationStep != 0) {
            float zoom = 1.0f + (float)(this.animationStep * (Math.max(extent.x, extent.y) - Math.max(this.image.getBounds().width, this.image.getBounds().height)) / 10) / 100.0f;
            int newSizeX = (int)((float)this.image.getBounds().width * zoom);
            int newSizeY = (int)((float)this.image.getBounds().height * zoom);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.setAlpha(255 - 25 * this.animationStep);
            Point extentZoomedImage = this.getTotalSize(newSizeX, newSizeY);
            int xZoomedImage = (rect.width - newSizeX) / 2;
            int yZoomedImage = (rect.height - extentZoomedImage.y) / 2;
            gc.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, xZoomedImage, yZoomedImage, (int)((float)this.image.getBounds().width * zoom), (int)((float)this.image.getBounds().height * zoom));
        }
        gc.dispose();
        event.gc.drawImage(bufferImage, 0, 0);
        bufferImage.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image.getBounds().width, this.image.getBounds().height);
        e.x = wHint == -1 ? (e.x += this.leftMargin + this.rightMargin) : wHint;
        e.y = hHint == -1 ? (e.y += this.topMargin + this.bottomMargin) : hHint;
        return e;
    }

    private Point getTotalSize(int imgWidth, int imgHeight) {
        Point size = new Point(0, 0);
        int textWidth = 0;
        int textHeight = 0;
        if (this.textSize == null) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.font);
            this.textSize = gc.textExtent(this.text, DRAW_FLAGS);
            gc.dispose();
        }
        textWidth = this.textSize.x;
        textHeight = this.textSize.y;
        size.x = Math.max(imgWidth, textWidth);
        size.y = imgHeight + 12 + textHeight;
        return size;
    }

    String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = text;
    }

    Image getImage() {
        return this.image;
    }

    void setImage(Image image) {
        this.image = image;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    boolean incrementAnimation() {
        boolean stopAnimation;
        ++this.animationStep;
        boolean bl = stopAnimation = this.animationStep > 10;
        if (stopAnimation) {
            this.animationStep = 0;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return !stopAnimation;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }
}

