/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.css;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.Win7RendererSupport;
import org.eclipse.nebula.widgets.grid.css.CSSEngineHelper;
import org.eclipse.nebula.widgets.grid.css.GridElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class GridPropertyHandler
implements ICSSPropertyHandler {
    private static final String FOOTER = "footer";
    private static final String HEADER = "header";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        int alignment;
        int width;
        Measure m;
        Color newColor;
        Grid grid = (Grid)((GridElement)((Object)element)).getNativeWidget();
        if ("grid-theme".equals(property) && value.getCssText() != null && value.getCssText().equals("win7")) {
            Win7RendererSupport.create((Grid)grid).decorate();
        }
        if ("grid-cell-header-selection-background-color".equals(property) && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)grid.getDisplay());
            grid.setCellHeaderSelectionBackground(newColor);
        }
        if ("grid-header-visible".equals(property)) {
            boolean headerVisible = value == null ? false : Boolean.parseBoolean(value.getCssText());
            grid.setHeaderVisible(headerVisible);
        }
        if ("grid-footer-visible".equals(property)) {
            boolean footerVisible = value == null ? false : Boolean.parseBoolean(value.getCssText());
            grid.setFooterVisible(footerVisible);
        }
        if ("grid-item-height".equals(property) && value.getCssValueType() == 1) {
            m = (Measure)value;
            width = Math.round(m.getFloatValue((short)0));
            grid.setItemHeight(width);
        }
        if ("grid-item-header-width".equals(property) && value.getCssValueType() == 1) {
            m = (Measure)value;
            width = Math.round(m.getFloatValue((short)0));
            grid.setItemHeaderWidth(width);
        }
        if ("grid-line-color".equals(property) && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)grid.getDisplay());
            grid.setLineColor(newColor);
        }
        if ("grid-lines-visible".equals(property)) {
            boolean linesVisible = value == null ? false : Boolean.parseBoolean(value.getCssText());
            grid.setLinesVisible(linesVisible);
        }
        if ("grid-tree-lines-visible".equals(property)) {
            boolean treeLinesVisible = value == null ? false : Boolean.parseBoolean(value.getCssText());
            grid.setTreeLinesVisible(treeLinesVisible);
        }
        if ("grid-columns-alignment".equals(property) && grid.getColumns() != null && ((alignment = "left".equals(value.getCssText()) ? 16384 : ("right".equals(value.getCssText()) ? 131072 : ("center".equals(value.getCssText()) ? 0x1000000 : 0))) == 16384 || alignment == 0x1000000 || alignment == 131072)) {
            GridColumn[] gridColumnArray = grid.getColumns();
            int n = gridColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridColumn col = gridColumnArray[n2];
                col.setAlignment(alignment);
                ++n2;
            }
        }
        if ("grid-columns-header-font".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyFont(element, grid, value, HEADER);
        }
        if ("grid-columns-header-font-style".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyStyle(element, grid, value, HEADER);
        }
        if ("grid-columns-header-font-size".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertySize(element, grid, value, HEADER);
        }
        if ("grid-columns-header-font-weight".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyWeight(element, grid, value, HEADER);
        }
        if ("grid-columns-header-font-family".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyFamily(element, grid, value, HEADER);
        }
        if ("grid-columns-footer-font".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyFont(element, grid, value, FOOTER);
        }
        if ("grid-columns-footer-font-style".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyStyle(element, grid, value, FOOTER);
        }
        if ("grid-columns-footer-font-size".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertySize(element, grid, value, FOOTER);
        }
        if ("grid-columns-footer-font-weight".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyWeight(element, grid, value, FOOTER);
        }
        if ("grid-columns-footer-font-family".equals(property) && grid.getColumns() != null) {
            this.applyCSSPropertyFamily(element, grid, value, FOOTER);
        }
        return true;
    }

    private void applyCSSPropertyFont(Object element, Grid grid, CSSValue value, String target) throws Exception {
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            int i = 0;
            while (i < length) {
                CSSValue value2 = valueList.item(i);
                if (value2.getCssValueType() == 1) {
                    String cssProp = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)((CSSPrimitiveValue)value2));
                    if (cssProp.equals("font-family")) {
                        this.applyCSSPropertyFamily(element, grid, value2, target);
                    } else if (cssProp.equals("font-size")) {
                        this.applyCSSPropertySize(element, grid, value2, target);
                    } else if (cssProp.equals("font-weight") && ("bold".equals(value2.getCssText()) || "bolder".equals(value2.getCssText()))) {
                        this.applyCSSPropertyWeight(element, grid, value2, target);
                    } else if (cssProp.equals("font-style") && ("italic".equals(value2.getCssText()) || "oblique".equals(value2.getCssText()))) {
                        this.applyCSSPropertyStyle(element, grid, value2, target);
                    }
                }
                ++i;
            }
        }
    }

    private boolean applyCSSPropertyStyle(Object element, Grid grid, CSSValue value, String target) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData((Control)grid);
            boolean modified = false;
            if ("italic".equals(value.getCssText()) || "oblique".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 2) != 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 2);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 2) == 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFD);
                }
            }
            if (modified) {
                this.applyFont(grid, fd, target);
            }
        }
        return true;
    }

    private void applyFont(Grid grid, FontData fd, String target) {
        GridColumn[] gridColumnArray = grid.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            this.applyFont(column, fd, target);
            ++n2;
        }
    }

    private void applyFont(GridColumn column, FontData fd, String target) {
        if (target.equals(HEADER)) {
            if (column.getHeaderFont() != null && !column.getHeaderFont().equals((Object)column.getDisplay().getSystemFont())) {
                column.getHeaderFont().dispose();
            }
        } else if (column.getFooterFont() != null && !column.getFooterFont().equals((Object)column.getDisplay().getSystemFont())) {
            column.getFooterFont().dispose();
        }
        Font newFont = new Font((Device)column.getDisplay(), fd);
        if (target.equals(HEADER)) {
            column.setHeaderFont(newFont);
        } else {
            column.setFooterFont(newFont);
        }
        column.getParent().addListener(12, e -> {
            if (newFont != null && !newFont.isDisposed()) {
                newFont.dispose();
            }
        });
    }

    private boolean applyCSSPropertySize(Object element, Grid grid, CSSValue value, String target) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData((Control)grid);
            Measure m = (Measure)value;
            int newSize = Math.round(m.getFloatValue((short)0));
            boolean bl = modified = fd.getHeight() != newSize;
            if (modified) {
                fd.setHeight(newSize);
                this.applyFont(grid, fd, target);
            }
        }
        return true;
    }

    private boolean applyCSSPropertyWeight(Object element, Grid grid, CSSValue value, String target) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData((Control)grid);
            boolean modified = false;
            if ("bold".equals(value.getCssText()) || "bolder".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 1) != 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 1);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 1) == 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFE);
                }
            }
            if (modified) {
                this.applyFont(grid, fd, target);
            }
        }
        return true;
    }

    private boolean applyCSSPropertyFamily(Object element, Grid grid, CSSValue value, String target) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData((Control)grid);
            boolean bl = modified = !fd.getName().equals(value.getCssText());
            if (modified) {
                fd.setName(value.getCssText());
                this.applyFont(grid, fd, target);
            }
        }
        return true;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

