/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.EventListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCombo
extends Composite {
    public static final boolean GTK = "gtk".equals(SWT.getPlatform());
    public static final boolean WIN32 = "win32".equals(SWT.getPlatform());
    Shell _shell;
    protected Text text;
    protected Shell popup;
    protected Button button;
    protected Control popupContent;
    protected Listener listener;
    protected Listener filter;
    protected boolean hasFocus;
    protected boolean showButtonOnFocus;
    protected boolean createOnDrop;

    public AbstractCombo(Composite parent, int style) {
        style = AbstractCombo.checkStyle(style);
        super(parent, style);
        this.showButtonOnFocus = false;
        this.createOnDrop = false;
        this._shell = super.getShell();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        super.setLayout((Layout)layout);
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = this.createTextControl(textStyle);
        GridData data = new GridData(1808);
        this.text.setLayoutData((Object)data);
        int buttonStyle = 1028;
        if ((style & 0x800000) != 0) {
            buttonStyle |= 0x800000;
        }
        this.button = this.createButtonControl(buttonStyle);
        this.button.setLayoutData((Object)new GridData(1040));
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractCombo.this.popup == event.widget) {
                    AbstractCombo.this.popupEvent(event);
                    return;
                }
                if (AbstractCombo.this.text == event.widget) {
                    AbstractCombo.this.textEvent(event);
                    return;
                }
                if (AbstractCombo.this.popupContent == event.widget) {
                    AbstractCombo.this.contentEvent(event);
                    return;
                }
                if (AbstractCombo.this.button == event.widget) {
                    AbstractCombo.this.buttonEvent(event);
                    return;
                }
                if (AbstractCombo.this == event.widget) {
                    AbstractCombo.this.comboEvent(event);
                    return;
                }
                if (AbstractCombo.this.getShell() == event.widget) {
                    AbstractCombo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractCombo.this.isDisposed()) {
                                return;
                            }
                            AbstractCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractCombo.this.isDisposed()) {
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == AbstractCombo.this.getShell()) {
                    AbstractCombo.this.handleFocus(16);
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(15, this.listener);
        this.addListener(10, this.listener);
        this.text.addListener(24, this.listener);
        this.text.addListener(15, this.listener);
        this.text.addListener(1, this.listener);
        this.text.addListener(31, this.listener);
        this.button.addListener(15, this.listener);
        this.button.addListener(3, this.listener);
        this.button.addListener(4, this.listener);
        this.button.addListener(13, this.listener);
    }

    static int checkStyle(int style) {
        int mask = 0x6800808;
        return 0x80000 | style & mask;
    }

    public void addModifyListener(ModifyListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{24});
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13, 14});
    }

    public void addVerifyListener(VerifyListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{25});
    }

    protected void beforeDrop() {
    }

    protected void buttonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(3, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 4: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(4, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 13: {
                this.text.setFocus();
                this.dropDown(!this.isDropped());
            }
        }
    }

    protected void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.removeListener(12, this.listener);
                this.notifyListeners(12, event);
                event.type = 0;
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popupContent.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                this.getShell().removeListener(27, this.listener);
                this.getDisplay().removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.popupContent = null;
                this.button = null;
                this._shell = null;
                break;
            }
            case 15: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.button || focusControl == this.popupContent) {
                    return;
                }
                if (this.isDropped()) {
                    this.popupContent.setFocus();
                    break;
                }
                this.text.setFocus();
                break;
            }
            case 10: {
                this.dropDown(false);
            }
        }
    }

    protected void contentEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                if (!this.doSelection()) break;
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                e.data = event.data;
                this.notifyListeners(13, e);
                event.doit = e.doit;
            }
        }
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    protected Button createButtonControl(int style) {
        Button button = new Button((Composite)this, style);
        return button;
    }

    protected void createPopup() {
        this.popup = new Shell(this.getShell(), 16388);
        this.popupContent = this.createPopupContent((Composite)this.popup);
        this.popupContent.setFont(this.text.getFont());
        this.popupContent.setBackground(this.text.getBackground());
        this.popupContent.setForeground(this.text.getForeground());
        this.popup.pack();
        this.popup.addListener(21, this.listener);
        this.popup.addListener(27, this.listener);
        this.popupContent.addListener(15, this.listener);
        this.popupContent.addListener(13, this.listener);
    }

    protected abstract Control createPopupContent(Composite var1);

    protected Text createTextControl(int style) {
        Text text = new Text((Composite)this, style);
        return text;
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    protected abstract boolean doSelection();

    protected void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            if (this.popup != null) {
                this.popup.setVisible(false);
                if (this.createOnDrop) {
                    this.popup.dispose();
                    this.popup = null;
                    this.popupContent = null;
                }
            }
            if (!this.isDisposed() && this.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.popup == null || this.getShell() != this.popup.getParent()) {
            if (this.popup != null) {
                this.popup.dispose();
                this.popup = null;
                this.popupContent = null;
            }
            this.createPopup();
        }
        this.setPopupLocation();
        this.beforeDrop();
        this.popup.setVisible(true);
        if (this.isFocusControl()) {
            this.popupContent.setFocus();
        }
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public boolean getPopupVisible() {
        this.checkWidget();
        return this.isDropped();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public Shell getShell() {
        this.checkWidget();
        Shell shell = super.getShell();
        if (shell != this._shell) {
            if (this._shell != null && !this._shell.isDisposed()) {
                this._shell.removeListener(27, this.listener);
            }
            this._shell = shell;
        }
        return this._shell;
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    protected void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                this.updateButtonDisplay();
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                this.notifyListeners(15, new Event());
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.button || this.popupContent != null && this.popupContent.isFocusControl() || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                this.updateButtonDisplay();
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                this.getDisplay().removeFilter(15, this.filter);
                this.notifyListeners(16, new Event());
            }
        }
    }

    protected boolean isDropped() {
        return this.popup != null && !this.popup.isDisposed() && this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.button.isFocusControl() || this.popupContent != null && this.popupContent.isFocusControl() || this.popup != null && this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public boolean isShowButtonOnFocus() {
        return this.showButtonOnFocus;
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    protected void popupEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.button.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.button.getSize();
                    Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                    if (rect.contains(point)) break;
                    this.dropDown(false);
                    break;
                }
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.button.redraw();
        if (this.popup.isVisible()) {
            this.popupContent.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.removeTypedListener(24, (EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
        this.removeTypedListener(14, (EventListener)listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.removeTypedListener(25, (EventListener)listener);
    }

    public void selectAll() {
        this.checkWidget();
        this.text.selectAll();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.button != null) {
            this.button.setBackground(color);
        }
        if (this.popupContent != null) {
            this.popupContent.setBackground(color);
        }
    }

    protected void setCreateOnDrop(boolean createOnDrop) {
        this.createOnDrop = createOnDrop;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
        this.button.setEnabled(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isDropped()) {
            this.dropDown(false);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
        if (this.popupContent != null) {
            this.popupContent.setFont(font);
        }
        this.pack();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.button != null) {
            this.button.setForeground(color);
        }
        if (this.popupContent != null) {
            this.popupContent.setForeground(color);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMenu(Menu menu) {
        this.text.setMenu(menu);
    }

    protected void setPopupLocation() {
        int popx;
        Display display = Display.getCurrent();
        Rectangle r = this.getBounds();
        Point p = display.map((Control)this, null, 0, r.height);
        Rectangle sb = display.getBounds();
        if (p.y + this.popup.getSize().y > sb.height) {
            p.y -= r.height + this.popup.getSize().y + this.getBorderWidth();
        }
        if (p.x + (popx = this.popup.getSize().x) > sb.width) {
            p.x -= popx - r.width + this.getBorderWidth();
        } else if (popx < r.width) {
            p.x += r.width - popx;
        }
        this.popup.setLocation(p.x, p.y);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setShowButtonOnFocus(boolean showButtonOnFocus) {
        this.showButtonOnFocus = showButtonOnFocus;
        this.updateButtonDisplay();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.button.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    protected void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 24: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 1: {
                Event keyEvent = new Event();
                keyEvent.time = event.time;
                keyEvent.character = event.character;
                keyEvent.keyCode = event.keyCode;
                keyEvent.stateMask = event.stateMask;
                this.notifyListeners(1, keyEvent);
                if ((event.stateMask & 0x10000) == 0 || event.keyCode != 0x1000002) break;
                event.doit = false;
                this.dropDown(true);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: {
                        event.doit = this.traverse(8);
                        event.detail = 0;
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }

    protected void updateButtonDisplay() {
        if (this.showButtonOnFocus) {
            GridData data = (GridData)this.button.getLayoutData();
            data.exclude = !this.hasFocus;
            this.button.setVisible(this.hasFocus);
            super.layout(false);
        }
    }
}

