/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.ITimeline;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelineFactory;
import org.eclipse.nebula.widgets.timeline.ITimelinePackage;
import org.eclipse.nebula.widgets.timeline.ITrack;

public class Timeline
extends MinimalEObjectImpl.Container
implements ITimeline {
    protected EList<ITrack> tracks;
    protected EList<ICursor> cursors;
    protected ITimelineEvent selectedEvent;

    protected Timeline() {
    }

    protected EClass eStaticClass() {
        return ITimelinePackage.Literals.TIMELINE;
    }

    @Override
    public EList<ITrack> getTracks() {
        if (this.tracks == null) {
            this.tracks = new EObjectContainmentWithInverseEList(ITrack.class, (InternalEObject)this, 0, 0);
        }
        return this.tracks;
    }

    @Override
    public EList<ICursor> getCursors() {
        if (this.cursors == null) {
            this.cursors = new EObjectContainmentWithInverseEList(ICursor.class, (InternalEObject)this, 1, 0);
        }
        return this.cursors;
    }

    @Override
    public ITimelineEvent getSelectedEvent() {
        if (this.selectedEvent != null && this.selectedEvent.eIsProxy()) {
            InternalEObject oldSelectedEvent = (InternalEObject)this.selectedEvent;
            this.selectedEvent = (ITimelineEvent)this.eResolveProxy(oldSelectedEvent);
            if (this.selectedEvent != oldSelectedEvent && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldSelectedEvent, (Object)this.selectedEvent));
            }
        }
        return this.selectedEvent;
    }

    public ITimelineEvent basicGetSelectedEvent() {
        return this.selectedEvent;
    }

    @Override
    public void setSelectedEvent(ITimelineEvent newSelectedEvent) {
        ITimelineEvent oldSelectedEvent = this.selectedEvent;
        this.selectedEvent = newSelectedEvent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSelectedEvent, (Object)this.selectedEvent));
        }
    }

    @Override
    public ITrack createTrack(String title) {
        ITrack track = ITimelineFactory.eINSTANCE.createTrack();
        track.setTitle(title);
        this.getTracks().add((Object)track);
        return track;
    }

    @Override
    public ICursor createCursor(long timestamp, TimeUnit timeUnit) {
        ICursor cursor = ITimelineFactory.eINSTANCE.createCursor();
        cursor.setTimestamp(timeUnit.toNanos(timestamp));
        this.getCursors().add((Object)cursor);
        return cursor;
    }

    @Override
    public ICursor createCursor(long timestamp) {
        return this.createCursor(timestamp, TimeUnit.NANOSECONDS);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getTracks()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getCursors()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getTracks()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getCursors()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getTracks();
            }
            case 1: {
                return this.getCursors();
            }
            case 2: {
                if (resolve) {
                    return this.getSelectedEvent();
                }
                return this.basicGetSelectedEvent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getTracks().clear();
                this.getTracks().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getCursors().clear();
                this.getCursors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setSelectedEvent((ITimelineEvent)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getTracks().clear();
                return;
            }
            case 1: {
                this.getCursors().clear();
                return;
            }
            case 2: {
                this.setSelectedEvent(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.tracks != null && !this.tracks.isEmpty();
            }
            case 1: {
                return this.cursors != null && !this.cursors.isEmpty();
            }
            case 2: {
                return this.selectedEvent != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.createTrack((String)arguments.get(0));
            }
            case 1: {
                return this.createCursor((Long)arguments.get(0), (TimeUnit)((Object)arguments.get(1)));
            }
            case 2: {
                return this.createCursor((Long)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

