/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline;

public class Timing {
    private double fTimestamp;
    private double fDuration;

    public Timing(double timestamp, double duration) {
        this.fTimestamp = timestamp;
        this.fDuration = duration;
    }

    public Timing(double timestamp) {
        this(timestamp, 0.0);
    }

    public double getTimestamp() {
        return this.fTimestamp;
    }

    public double getDuration() {
        return this.fDuration;
    }

    public double left() {
        return this.getTimestamp();
    }

    public double right() {
        return this.getTimestamp() + this.getDuration();
    }

    public Timing copy() {
        return new Timing(this.getTimestamp(), this.getDuration());
    }

    public void union(Timing timing) {
        double left = Math.min(this.left(), timing.left());
        double right = Math.max(this.right(), timing.right());
        this.fTimestamp = left;
        this.fDuration = right - left;
    }

    public void scale(double scaleFactor) {
        this.fTimestamp *= scaleFactor;
        this.fDuration *= scaleFactor;
    }

    public void translate(double offset) {
        this.fTimestamp += offset;
    }

    public boolean isEmpty() {
        return this.fDuration == 0.0;
    }

    public String toString() {
        return this.fTimestamp + " (" + this.fDuration + ")";
    }
}

