/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.exampleview;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.figures.GaugeFigure;
import org.eclipse.nebula.visualization.widgets.figures.KnobFigure;
import org.eclipse.nebula.visualization.widgets.figures.TankFigure;
import org.eclipse.nebula.visualization.widgets.figures.ThermometerFigure;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class WidgetsExampleView
extends ViewPart {
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        GridData gd = new GridData(4, 4, true, true);
        parent.setLayout((Layout)layout);
        Canvas knobCanvas = new Canvas(parent, 2048);
        knobCanvas.setLayoutData((Object)gd);
        Canvas gaugeCanvas = new Canvas(parent, 2048);
        gaugeCanvas.setLayoutData((Object)gd);
        Canvas thermoCanvas = new Canvas(parent, 2048);
        thermoCanvas.setLayoutData((Object)gd);
        Canvas tankCanvas = new Canvas(parent, 2048);
        tankCanvas.setLayoutData((Object)gd);
        Canvas xyGraphCanvas = new Canvas(parent, 2048);
        gd = new GridData(4, 4, true, true, 4, 3);
        xyGraphCanvas.setLayoutData((Object)gd);
        LightweightSystem lws = new LightweightSystem(knobCanvas);
        KnobFigure knobFigure = new KnobFigure();
        lws.setContents((IFigure)knobFigure);
        lws = new LightweightSystem(gaugeCanvas);
        final GaugeFigure gauge = new GaugeFigure();
        gauge.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(0, 0, 0));
        gauge.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        lws.setContents((IFigure)gauge);
        lws = new LightweightSystem(thermoCanvas);
        final ThermometerFigure thermo = new ThermometerFigure();
        lws.setContents((IFigure)thermo);
        lws = new LightweightSystem(tankCanvas);
        final TankFigure tank = new TankFigure();
        lws.setContents((IFigure)tank);
        lws = new LightweightSystem(xyGraphCanvas);
        XYGraph xyGraph = new XYGraph();
        xyGraph.getPrimaryXAxis().setAutoScale(true);
        lws.setContents((IFigure)xyGraph);
        final CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(true);
        traceDataProvider.setBufferSize(100);
        traceDataProvider.setUpdateMode(CircularBufferDataProvider.UpdateMode.X_OR_Y);
        Trace trace = new Trace("Trace1-XY Plot", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.POINT);
        xyGraph.addTrace(trace);
        knobFigure.addManualValueChangeListener(new IManualValueChangeListener(){

            public void manualValueChanged(double newValue) {
                gauge.setValue(newValue);
                thermo.setValue(newValue);
                tank.setValue(newValue);
                traceDataProvider.setCurrentYData(newValue);
            }
        });
    }

    public void setFocus() {
    }
}

