/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWContainer;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWGroup;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWRowGroup;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTab;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWButton;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWLabel;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PWRow
extends PWRowGroup {
    protected final List<PWWidget> widgets = new ArrayList<PWWidget>();

    @Override
    public PWContainer add(PWWidget widget) {
        this.widgets.add(widget);
        this.addColumn(widget.getNumberOfColumns());
        return this;
    }

    @Override
    public PWContainer add(PWContainer element) {
        if (element instanceof PWRow || element instanceof PWGroup) {
            return this.parent.add(element);
        }
        throw new UnsupportedOperationException("Can only add a PWGroup or a PWRow.");
    }

    @Override
    public void build(Composite parent) {
        int size = this.widgets.size();
        int columIndex = 0;
        int i = 0;
        while (i < size) {
            PWWidget widget = this.widgets.get(i);
            Control control = widget.checkAndBuild(parent);
            if (control != null && control.getLayoutData() == null) {
                boolean grabExcessSpace;
                int colSpan;
                if (size == 1) {
                    colSpan = widget.isSingleWidget() ? this.parentNumberOfColums : this.parentNumberOfColums - widget.getNumberOfColumns() + 1;
                    grabExcessSpace = true;
                } else if (i == size - 1) {
                    colSpan = this.parentNumberOfColums - columIndex;
                    grabExcessSpace = widget.isGrabExcessSpace();
                } else {
                    colSpan = 1;
                    grabExcessSpace = widget instanceof PWButton && i == 0 ? true : widget.isGrabExcessSpace();
                }
                columIndex += widget.getNumberOfColumns();
                int alignment = i == 0 && grabExcessSpace && size > 1 ? (widget instanceof PWLabel || widget instanceof PWButton ? 3 : 1) : widget.getAlignment();
                GridData gd = new GridData(alignment, 1, grabExcessSpace, false, colSpan, 1);
                gd.horizontalIndent = widget.getIndent();
                gd.minimumWidth = widget.getWidth();
                if (widget.getHeight() != -1) {
                    gd.minimumHeight = widget.getHeight();
                }
                control.setLayoutData((Object)gd);
            }
            ++i;
        }
    }

    @Override
    protected void checkParent(PWContainer parent) {
        if (parent instanceof PWTab || parent instanceof PWGroup) {
            return;
        }
        throw new UnsupportedOperationException("Bad parent, should be only PWTab or PWGroup");
    }

    @Override
    public void enableOrDisable() {
        if (this.enabler == null) {
            return;
        }
        boolean enabled = this.enabler.isEnabled();
        for (PWWidget widget : this.widgets) {
            boolean widgetEnable = widget.enableOrDisable();
            for (Control c : widget.getControls()) {
                if (c.isDisposed()) continue;
                c.setEnabled(enabled && widgetEnable);
            }
        }
    }
}

