/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaledRamp;
import org.eclipse.nebula.visualization.widgets.figures.AbstractRoundRampedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.widgets.util.PointsUtil;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GaugeFigure
extends AbstractRoundRampedFigure {
    private final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private final Color BORDER_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(100, 100, 100));
    private final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private final Color DEFAULT_NEEDLE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED);
    private final Font DEFAULT_LABEL_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Arial", 12, 1));
    private static final int BORDER_WIDTH = 2;
    private boolean effect3D = true;
    private NeedleCenter needleCenter;
    private Needle needle;
    private Label valueLabel;
    private Boolean support3D;
    private Label unitLabel;
    private String unit;
    private Label titleLabel;
    private String title;

    public GaugeFigure() {
        this.transparent = true;
        this.scale.setScaleLineVisible(false);
        this.scale.setTickLabelSide(AbstractScale.LabelSide.Secondary);
        this.ramp.setRampWidth(10);
        this.valueLabel = new Label();
        this.valueLabel.setFont(this.DEFAULT_LABEL_FONT);
        this.unitLabel = new Label();
        this.unitLabel.setFont(this.DEFAULT_LABEL_FONT);
        this.titleLabel = new Label();
        this.titleLabel.setFont(this.DEFAULT_LABEL_FONT);
        this.needle = new Needle();
        this.needle.setFill(true);
        this.needle.setOutline(false);
        this.needleCenter = new NeedleCenter();
        this.needleCenter.setOutline(false);
        this.setLayoutManager((LayoutManager)new GaugeLayout());
        this.add((IFigure)this.ramp, "ramp");
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.valueLabel, "valueLabel");
        this.add((IFigure)this.unitLabel, "unitLabel");
        this.add((IFigure)this.titleLabel, "titleLabel");
        this.add((IFigure)this.needle, "needle");
        this.add((IFigure)this.needleCenter, "needleCenter");
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                GaugeFigure.this.ramp.setDirty(true);
                GaugeFigure.this.revalidate();
            }
        });
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.valueLabel.setText(this.getValueText());
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle area = this.getClientArea();
        area.height = area.width = Math.min(area.width, area.height);
        Pattern pattern = null;
        graphics.pushState();
        graphics.setBackgroundColor(this.GRAY_COLOR);
        if (this.support3D == null) {
            this.support3D = GraphicsUtil.testPatternSupported(graphics);
        }
        if (this.effect3D && this.support3D.booleanValue()) {
            pattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), area.x, area.y, area.x + area.width, area.y + area.height, this.BORDER_COLOR, this.WHITE_COLOR);
            graphics.setBackgroundPattern(pattern);
        }
        graphics.fillOval(area);
        if (this.effect3D && this.support3D.booleanValue()) {
            pattern.dispose();
            area.shrink(2, 2);
        } else {
            area.shrink(1, 1);
        }
        graphics.popState();
        graphics.fillOval(area);
        super.paintClientArea(graphics);
        if (this.effect3D && this.support3D.booleanValue()) {
            graphics.pushState();
            graphics.setAntialias(1);
            double R = (double)area.width / 2.0;
            double UD_FILL_PART = 0.95;
            double UP_DOWN_RATIO = 0.5;
            double LR_FILL_PART = 0.85;
            double UP_ANGLE = 0.0;
            double DOWN_ANGLE = 0.6108652381980153;
            Pattern glossyPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), area.x + area.width / 2, (float)((double)(area.y + area.height / 2) - R * 0.95), area.x + area.width / 2, (float)((double)(area.y + area.height / 2) + R * 0.5), this.WHITE_COLOR, 90, this.WHITE_COLOR, 0);
            graphics.setBackgroundPattern(glossyPattern);
            Rectangle rectangle = new Rectangle((int)((double)(area.x + area.width / 2) - R * 0.85 * Math.cos(0.0)), (int)((double)(area.y + area.height / 2) - R * 0.95), (int)(2.0 * R * 0.85 * Math.cos(0.0)), (int)(R * 0.95 + R * 0.5));
            graphics.fillOval(rectangle);
            glossyPattern.dispose();
            glossyPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), area.x + area.width / 2, (float)((double)(area.y + area.height / 2) + R * 0.5 - 1.0), area.x + area.width / 2, (float)((double)(area.y + area.height / 2) + R * 0.95 + 1.0), this.WHITE_COLOR, 0, this.WHITE_COLOR, 40);
            graphics.setBackgroundPattern(glossyPattern);
            rectangle = new Rectangle((int)((double)(area.x + area.width / 2) - R * 0.85 * Math.sin(0.6108652381980153)), (int)Math.ceil((double)(area.y + area.height / 2) + R * 0.5), (int)(2.0 * R * 0.85 * Math.sin(0.6108652381980153)), (int)Math.ceil(R * 0.95 - R * 0.5));
            graphics.fillOval(rectangle);
            glossyPattern.dispose();
            graphics.popState();
        }
    }

    public void setNeedleColor(Color needleColor) {
        this.needle.setBackgroundColor(needleColor);
    }

    public Color getNeedleColor() {
        return this.needle.getBackgroundColor();
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.unitLabel.setText(unit);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
    }

    class GaugeLayout
    extends AbstractLayout {
        private static final int GAP_BTW_NEEDLE_SCALE = -1;
        public static final String SCALE = "scale";
        public static final String NEEDLE = "needle";
        public static final String RAMP = "ramp";
        public static final String NEEDLE_CENTER = "needleCenter";
        public static final String VALUE_LABEL = "valueLabel";
        public static final String UNIT_LABEL = "unitLabel";
        public static final String TITLE_LABEL = "titleLabel";
        private RoundScale scale;
        private RoundScaledRamp ramp;
        private Polygon needle;
        private NeedleCenter needleCenter;
        private Label valueLabel;
        private Label titleLabel;
        private Label unitLabel;
        private PointList needlePoints = new PointList(new int[6]);

        GaugeLayout() {
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (RoundScale)child;
            } else if (constraint.equals(RAMP)) {
                this.ramp = (RoundScaledRamp)child;
            } else if (constraint.equals(NEEDLE)) {
                this.needle = (Polygon)child;
            } else if (constraint.equals(NEEDLE_CENTER)) {
                this.needleCenter = (NeedleCenter)child;
            } else if (constraint.equals(VALUE_LABEL)) {
                this.valueLabel = (Label)child;
            } else if (constraint.equals(TITLE_LABEL)) {
                this.titleLabel = (Label)child;
            } else if (constraint.equals(UNIT_LABEL)) {
                this.unitLabel = (Label)child;
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(256, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            area.height = area.width = Math.min(area.width, area.height);
            area.shrink(2, 2);
            Point center = area.getCenter();
            if (this.scale != null) {
                this.scale.setBounds(area);
            }
            if (this.ramp != null && this.ramp.isVisible()) {
                Rectangle rampBounds = area.getCopy();
                this.ramp.setBounds(rampBounds.shrink(area.width / 4, area.height / 4));
            }
            if (this.valueLabel != null) {
                Dimension labelSize = this.valueLabel.getPreferredSize();
                this.valueLabel.setBounds(new Rectangle(area.x + area.width / 2 - labelSize.width / 2, (int)((float)area.y + (float)area.height * 6.3f / 8.0f - (float)(labelSize.height / 2)), labelSize.width, labelSize.height));
            }
            if (GaugeFigure.this.title != null) {
                Dimension titleSize = this.titleLabel.getPreferredSize();
                this.titleLabel.setBounds(new Rectangle(area.x + area.width / 2 - titleSize.width / 2, (int)((float)area.y + (float)area.height * 7.1f / 8.0f - (float)(titleSize.height / 2)), titleSize.width, titleSize.height));
            }
            if (GaugeFigure.this.unit != null) {
                Dimension unitSize = this.unitLabel.getPreferredSize();
                this.unitLabel.setBounds(new Rectangle(area.x + area.width / 2 - unitSize.width / 2, (int)((float)area.y + (float)area.height * 5.5f / 8.0f - (float)(unitSize.height / 2)), unitSize.width, unitSize.height));
            }
            if (this.needle != null && this.scale != null) {
                this.needlePoints.setPoint(new Point(center.x, center.y - 8 + 3), 0);
                this.scale.getScaleTickMarks();
                this.needlePoints.setPoint(new Point(center.x + area.width / 2 - 8 - -1, center.y), 1);
                this.needlePoints.setPoint(new Point(center.x, center.y + 8 - 3), 2);
                double valuePosition = 360.0 - this.scale.getValuePosition(GaugeFigure.this.getCoercedValue(), false);
                if (GaugeFigure.this.maximum > GaugeFigure.this.minimum) {
                    if (GaugeFigure.this.value > GaugeFigure.this.maximum) {
                        valuePosition += 10.0;
                    } else if (GaugeFigure.this.value < GaugeFigure.this.minimum) {
                        valuePosition -= 10.0;
                    }
                } else if (GaugeFigure.this.value > GaugeFigure.this.minimum) {
                    valuePosition -= 10.0;
                } else if (GaugeFigure.this.value < GaugeFigure.this.maximum) {
                    valuePosition += 10.0;
                }
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(0), valuePosition, center), 0);
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(1), valuePosition, center), 1);
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(2), valuePosition, center), 2);
                this.needle.setPoints(this.needlePoints);
            }
            if (this.needleCenter != null) {
                this.needleCenter.setBounds(new Rectangle(center.x - 8, center.y - 8, 16, 16));
            }
        }
    }

    class Needle
    extends Polygon {
        public Needle() {
            this.setBackgroundColor(GaugeFigure.this.DEFAULT_NEEDLE_COLOR);
        }

        protected void fillShape(Graphics g) {
            g.setAntialias(1);
            super.fillShape(g);
        }
    }

    class NeedleCenter
    extends Ellipse {
        public static final int DIAMETER = 16;

        NeedleCenter() {
        }

        protected void fillShape(Graphics graphics) {
            graphics.setAntialias(1);
            Pattern pattern = null;
            graphics.setBackgroundColor(GaugeFigure.this.GRAY_COLOR);
            if (GaugeFigure.this.support3D == null) {
                GaugeFigure.this.support3D = GraphicsUtil.testPatternSupported(graphics);
            }
            if (GaugeFigure.this.effect3D && GaugeFigure.this.support3D.booleanValue()) {
                pattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, GaugeFigure.this.WHITE_COLOR, GaugeFigure.this.BORDER_COLOR);
                graphics.setBackgroundPattern(pattern);
            }
            super.fillShape(graphics);
            if (GaugeFigure.this.effect3D && GaugeFigure.this.support3D.booleanValue()) {
                pattern.dispose();
            }
        }
    }
}

