/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Bulb
extends Figure {
    private Color bulbColor;
    private final Color COLOR_WHITE = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private boolean effect3D;

    public Bulb() {
        this.setBulbColor(XYGraphMediaFactory.getInstance().getColor(new RGB(150, 150, 150)));
        this.setEffect3D(true);
    }

    public boolean isOpaque() {
        return false;
    }

    public void setBounds(Rectangle rect) {
        rect.width = Math.min(rect.width, rect.height);
        if (rect.width < 3) {
            rect.width = 3;
        }
        rect.height = rect.width;
        super.setBounds(rect);
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.setAntialias(1);
        if (this.effect3D && GraphicsUtil.testPatternSupported(graphics)) {
            graphics.setBackgroundColor(this.bulbColor);
            graphics.fillOval(this.bounds);
            Pattern p = new Pattern((Device)Display.getCurrent(), (float)this.bounds.x, (float)this.bounds.y, (float)(this.bounds.x + this.getWidth()), (float)(this.bounds.y + this.getHeight()), this.COLOR_WHITE, 255, this.bulbColor, 0);
            try {
                graphics.setBackgroundPattern(p);
                graphics.fillOval(this.bounds);
                p.dispose();
            }
            catch (Exception e) {
                p.dispose();
            }
        } else {
            graphics.setBackgroundColor(this.bulbColor);
            graphics.fillOval(this.bounds);
        }
        super.paintClientArea(graphics);
    }

    public void setBulbColor(Color color) {
        if (this.bulbColor != null && this.bulbColor.equals((Object)color)) {
            return;
        }
        this.bulbColor = color;
        this.repaint();
    }

    private int getHeight() {
        return this.bounds.height;
    }

    private int getWidth() {
        return this.bounds.width;
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }
}

