/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figureparts.ColorMapRamp;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColorMapRampExample {
    private static final String INFINITY_TOOLTIP = "Infinity/-Infinity/NaN can be set and will be passed to ColorMapRamp, but the figure will ignore it.";
    private ColorMapRamp colorMapRamp;
    private Combo colorMapCombo;
    private Button customImageDataCheck;
    private Button logCheck;
    private Text minText;
    private Text maxText;

    public static void main(String[] args) {
        new ColorMapRampExample().run();
    }

    private void run() {
        Shell shell = new Shell();
        shell.setSize(500, 500);
        shell.setLayout((Layout)new GridLayout());
        Canvas colorMapRampCanvas = new Canvas((Composite)shell, 0);
        GridData gd = new GridData(0x1000000, 4, false, true);
        gd.widthHint = 100;
        colorMapRampCanvas.setLayoutData((Object)gd);
        LightweightSystem lws = new LightweightSystem(colorMapRampCanvas);
        this.colorMapRamp = new ColorMapRamp();
        this.colorMapRamp.setLog10(false);
        lws.setContents((IFigure)this.colorMapRamp);
        this.colorMapCombo = new Combo((Composite)shell, 8);
        this.colorMapCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        String[] names = ColorMap.PredefinedColorMap.getStringValues();
        names[0] = String.valueOf(names[0]) + " (Provides no color map, will NullPointerException on its own)";
        this.colorMapCombo.setItems(names);
        this.colorMapCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColorMapRampExample.this.updateRamp();
            }
        });
        this.customImageDataCheck = new Button((Composite)shell, 32);
        this.customImageDataCheck.setText("Custom Image Data");
        this.customImageDataCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorMapRampExample.this.updateRamp();
            }
        });
        this.logCheck = new Button((Composite)shell, 32);
        this.logCheck.setText("Enable Log");
        this.logCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorMapRampExample.this.updateRamp();
            }
        });
        this.logCheck.setSelection(false);
        Composite minMaxComposite = new Composite((Composite)shell, 0);
        minMaxComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        minMaxComposite.setLayout((Layout)new GridLayout(2, false));
        Label minLabel = new Label(minMaxComposite, 0);
        minLabel.setText("Min");
        minLabel.setToolTipText(INFINITY_TOOLTIP);
        this.minText = new Text(minMaxComposite, 4);
        this.minText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.minText.setText("0");
        this.minText.setToolTipText(INFINITY_TOOLTIP);
        this.minText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColorMapRampExample.this.updateRamp();
            }
        });
        Label maxLabel = new Label(minMaxComposite, 0);
        maxLabel.setText("Max");
        maxLabel.setToolTipText(INFINITY_TOOLTIP);
        this.maxText = new Text(minMaxComposite, 4);
        this.maxText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxText.setText("1");
        this.maxText.setToolTipText(INFINITY_TOOLTIP);
        this.maxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColorMapRampExample.this.updateRamp();
            }
        });
        shell.open();
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void updateRamp() {
        int selectionIndex = this.colorMapCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= ColorMap.PredefinedColorMap.values().length) {
            selectionIndex = 1;
        }
        ColorMap.PredefinedColorMap map = ColorMap.PredefinedColorMap.fromIndex(selectionIndex);
        ColorMap colorMap = new ColorMap(map, true, true);
        this.colorMapRamp.setColorMap(colorMap);
        this.colorMapRamp.setLog10(this.logCheck.getSelection());
        if (this.customImageDataCheck.getSelection()) {
            ImageData imageData = new ImageData(1, 256, 24, new PaletteData(255, 65280, 0xFF0000));
            int i = 0;
            while (i < 128) {
                imageData.setPixel(0, i, i * 2);
                imageData.setPixel(0, 256 - i - 1, i * 2);
                ++i;
            }
            this.colorMapRamp.setImageData(imageData);
        } else {
            this.colorMapRamp.setImageData(null);
        }
        try {
            double min = Double.parseDouble(this.minText.getText());
            this.colorMapRamp.setMin(min);
        }
        catch (NumberFormatException nfe) {
            System.out.println("NumberFormatException: Ignoring Min setting: " + this.minText.getText());
        }
        try {
            double max = Double.parseDouble(this.maxText.getText());
            this.colorMapRamp.setMax(max);
        }
        catch (NumberFormatException nfe) {
            System.out.println("NumberFormatException: Ignoring Max setting: " + this.maxText.getText());
        }
        this.colorMapRamp.repaint();
    }
}

