/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.opal.columnbrowser.snippets;

import org.eclipse.nebula.widgets.opal.columnbrowser.ColumnBrowserWidget;
import org.eclipse.nebula.widgets.opal.columnbrowser.ColumnItem;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnsSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(2, false));
        ColumnBrowserWidget cbw = new ColumnBrowserWidget((Composite)shell, 0);
        cbw.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ColumnItem item = ColumnsSnippet.createColors(cbw);
        ColumnsSnippet.createSports(cbw);
        ColumnsSnippet.createShowSelectionButton(shell, cbw);
        ColumnsSnippet.createForceSelection(shell, cbw, item);
        shell.setSize(640, 350);
        shell.pack();
        shell.open();
        SWTGraphicUtil.centerShell((Shell)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static ColumnItem createColors(ColumnBrowserWidget cbw) {
        ColumnItem root = new ColumnItem(cbw);
        root.setText("Colors");
        ColumnItem b = new ColumnItem(root);
        b.setText("b");
        ColumnItem bl = new ColumnItem(b);
        bl.setText("l");
        ColumnItem blu = new ColumnItem(bl);
        blu.setText("u");
        ColumnItem blue = new ColumnItem(blu);
        blue.setText("e");
        ColumnItem r = new ColumnItem(root);
        r.setText("r");
        ColumnItem re = new ColumnItem(r);
        re.setText("e");
        ColumnItem red = new ColumnItem(re);
        red.setText("d");
        ColumnItem ro = new ColumnItem(r);
        ro.setText("o");
        ColumnItem ros = new ColumnItem(ro);
        ros.setText("s");
        ColumnItem rose = new ColumnItem(ros);
        rose.setText("e");
        ColumnItem g = new ColumnItem(root);
        g.setText("g");
        ColumnItem gr = new ColumnItem(g);
        gr.setText("r");
        ColumnItem gre = new ColumnItem(gr);
        gre.setText("e");
        ColumnItem gree = new ColumnItem(gre);
        gree.setText("e");
        ColumnItem green = new ColumnItem(gree);
        green.setText("n");
        return green;
    }

    private static void createSports(ColumnBrowserWidget cbw) {
        ColumnItem root = new ColumnItem(cbw);
        root.setText("Sports");
        ColumnItem football = new ColumnItem(root);
        football.setText("Football");
        ColumnItem rugby = new ColumnItem(root);
        rugby.setText("Rugby");
        ColumnItem handball = new ColumnItem(root);
        handball.setText("Hand Ball");
    }

    private static void createShowSelectionButton(Shell shell, final ColumnBrowserWidget cbw) {
        Button button = new Button((Composite)shell, 8);
        button.setLayoutData((Object)new GridData(3, 4, true, false));
        button.setText("Show selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialog.inform((String)"Selection", (String)("You have selected " + (cbw.getSelection() == null ? "nothing" : cbw.getSelection().getText())));
            }
        });
    }

    private static void createForceSelection(Shell shell, final ColumnBrowserWidget cbw, final ColumnItem item) {
        Button button = new Button((Composite)shell, 8);
        button.setLayoutData((Object)new GridData(3, 4, false, false));
        button.setText("Force selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cbw.select(item);
            }
        });
    }
}

