/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.widgets.cdatetime.AnalogTimePicker;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Event;

class AnalogClockPainter
implements IControlPainter {
    private static final String HOUR_24 = "H";
    private static final String HOUR_12 = "h";
    private CDateTime cdt;
    private AnalogTimePicker picker;
    private boolean paintMinorTicks = true;
    private boolean paintShadows = true;

    public AnalogClockPainter(CDateTime cdt, AnalogTimePicker picker) {
        this.cdt = cdt;
        this.picker = picker;
    }

    public void dispose() {
    }

    public void paintBackground(VControl control, Event e) {
    }

    public void paintBorders(VControl control, Event e) {
    }

    public final void paintContent(VControl control, Event e) {
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        Calendar cal = this.cdt.getCalendarInstance();
        float angleS = cal.get(13) * 6;
        float angleM = cal.get(12) * 6;
        float angleH = this.picker.is24Hour ? (float)(cal.get(11) * 15 + cal.get(12) / 4) : (float)(cal.get(10) * 30 + cal.get(12) / 2);
        int lwidth = e.gc.getLineWidth();
        e.gc.setLineWidth(1);
        int lcap = e.gc.getLineCap();
        e.gc.setLineCap(2);
        this.paintFace((VPanel)control, e);
        if (this.paintShadows) {
            e.gc.setBackground(e.display.getSystemColor(16));
            e.gc.setForeground(e.display.getSystemColor(16));
            e.gc.setLineWidth(2);
            control.setAlpha(e.gc, 50);
            if (this.picker.secHand) {
                this.setTransform(e, angleS, true);
                this.paintSecondHand((VPanel)control, e, (int)angleS);
            }
            if (this.picker.minHand) {
                this.setTransform(e, angleM, true);
                this.paintMinuteHand((VPanel)control, e, (int)angleM);
            }
            if (this.picker.hourHand) {
                this.setTransform(e, angleH, true);
                this.paintHourHand((VPanel)control, e, (int)angleH);
            }
            control.setAlpha(e.gc);
            e.gc.setBackground(e.display.getSystemColor(15));
            e.gc.fillOval(this.picker.dialCenter.x + 1, this.picker.dialCenter.y + 1, 6, 6);
        }
        if (this.picker.secHand) {
            e.gc.setBackground(e.display.getSystemColor(2));
            if (this.picker.overSec) {
                e.gc.setForeground(e.display.getSystemColor(2));
                e.gc.setLineWidth(4);
            } else {
                e.gc.setForeground(e.display.getSystemColor(4));
                e.gc.setLineWidth(2);
            }
            this.setTransform(e, angleS, false);
            this.paintSecondHand((VPanel)control, e, (int)angleS);
        }
        if (this.picker.minHand) {
            if (this.picker.overMin) {
                e.gc.setBackground(e.display.getSystemColor(2));
                e.gc.setForeground(e.display.getSystemColor(2));
                e.gc.setLineWidth(4);
            } else {
                e.gc.setForeground(e.display.getSystemColor(10));
                e.gc.setLineWidth(2);
            }
            this.setTransform(e, angleM, false);
            this.paintMinuteHand((VPanel)control, e, (int)angleM);
        }
        if (this.picker.hourHand) {
            if (this.picker.overHour) {
                e.gc.setBackground(e.display.getSystemColor(2));
                e.gc.setForeground(e.display.getSystemColor(2));
                e.gc.setLineWidth(4);
            } else {
                e.gc.setForeground(e.display.getSystemColor(10));
                e.gc.setLineWidth(2);
            }
            this.setTransform(e, angleH, false);
            this.paintHourHand((VPanel)control, e, (int)angleH);
        }
        if (this.picker.overHour || this.picker.overMin || this.picker.overSec) {
            e.gc.setLineWidth(2);
        } else {
            e.gc.setLineWidth(1);
        }
        control.setAlpha(e.gc);
        e.gc.setBackground(e.display.getSystemColor(16));
        e.gc.fillOval(this.picker.dialCenter.x - 3, this.picker.dialCenter.y - 3, 6, 6);
        e.gc.setForeground(e.display.getSystemColor(2));
        e.gc.drawOval(this.picker.dialCenter.x - 3, this.picker.dialCenter.y - 3, 6, 6);
        if (this.picker.timeNow != null) {
            this.picker.timeNow.paintControl(e);
        }
        if (this.picker.timeAmPm != null) {
            this.picker.timeAmPm.paintControl(e);
        }
        e.gc.setLineWidth(lwidth);
        e.gc.setLineCap(lcap);
    }

    protected void paintFace(VPanel panel, Event e) {
        int dia = 2 * this.picker.dialRadius;
        int x = this.picker.dialCenter.x - this.picker.dialRadius;
        int y = this.picker.dialCenter.y - this.picker.dialRadius;
        Color c1 = new Color((Device)e.display, 220, 220, 225);
        Color c2 = new Color((Device)e.display, 200, 200, 200);
        Pattern p = new Pattern((Device)e.display, 0.0f, (float)y, 0.0f, (float)(y + dia), e.display.getSystemColor(1), c1);
        e.gc.setBackgroundPattern(p);
        e.gc.fillOval(x, y, dia, dia);
        e.gc.setForeground(c2);
        e.gc.drawOval(x, y, dia, dia);
        Transform o = new Transform((Device)e.display);
        e.gc.getTransform(o);
        Transform t = new Transform((Device)e.display);
        t.translate((float)this.picker.dialCenter.x, (float)this.picker.dialCenter.y);
        t.rotate(-90.0f);
        int inc = 12;
        int i = 0;
        while (i < inc) {
            e.gc.setTransform(t);
            e.gc.drawLine(this.picker.dialRadius - 15, 0, this.picker.dialRadius - 8, 0);
            t.rotate(30.0f);
            ++i;
        }
        if (this.paintMinorTicks || this.picker.is24Hour) {
            inc = this.picker.is24Hour ? 24 : 60;
            int skip = this.picker.is24Hour ? 2 : 5;
            int i2 = 0;
            while (i2 < inc) {
                if (i2 % skip != 0) {
                    e.gc.setTransform(t);
                    e.gc.drawLine(this.picker.dialRadius - 13, 0, this.picker.dialRadius - 10, 0);
                }
                t.rotate((float)(this.picker.is24Hour ? 15 : 6));
                ++i2;
            }
        }
        t.dispose();
        Calendar tmpcal = this.cdt.getCalendarInstance();
        tmpcal.set(1, 1, 1, 0, 0, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(this.picker.is24Hour ? HOUR_24 : HOUR_12);
        sdf.setTimeZone(tmpcal.getTimeZone());
        e.gc.setForeground(e.display.getSystemColor(10));
        panel.setAlpha(e.gc, 200);
        e.gc.setTransform(o);
        inc = 12;
        int i3 = 0;
        while (i3 < inc) {
            int x2 = x + this.picker.dialRadius + (int)((double)(this.picker.dialRadius - 25) * Math.cos(2.0 * (double)i3 * Math.PI / (double)inc - 1.5707963267948966));
            int y2 = y + this.picker.dialRadius + (int)((double)(this.picker.dialRadius - 25) * Math.sin(2.0 * (double)i3 * Math.PI / (double)inc - 1.5707963267948966));
            String str = sdf.format(tmpcal.getTime());
            Point ss = e.gc.stringExtent(str);
            e.gc.drawString(str, x2 - ss.x / 2, y2 - ss.y / 2);
            tmpcal.add(11, this.picker.is24Hour ? 2 : 1);
            ++i3;
        }
        p.dispose();
        c1.dispose();
        c2.dispose();
    }

    protected void paintHourHand(VPanel panel, Event e, int angle) {
        e.gc.drawLine(-15, 0, this.picker.dialRadius - 35, 0);
    }

    protected void paintMinuteHand(VPanel panel, Event e, int angle) {
        e.gc.drawLine(-15, 0, this.picker.dialRadius - 17, 0);
    }

    protected void paintSecondHand(VPanel panel, Event e, int angle) {
        e.gc.drawLine(-15, 0, this.picker.dialRadius - 12, 0);
    }

    private void setTransform(Event e, float angle, boolean shadow) {
        Transform t = new Transform((Device)e.display);
        int x = this.picker.dialCenter.x;
        int y = this.picker.dialCenter.y;
        if (shadow) {
            x += 4;
            y += 4;
        }
        t.translate((float)x, (float)y);
        t.rotate(angle - 90.0f);
        e.gc.setTransform(t);
        t.dispose();
    }
}

