/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.switchbutton;

import java.util.EventListener;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SwitchButton
extends Canvas {
    private boolean selection = false;
    private String textForSelect = "On";
    private String textForUnselect = "Off";
    private String text = "";
    private boolean round = true;
    private Color borderColor = null;
    private Color focusColor = this.getDisplay().getSystemColor(16);
    private Color selectedForegroundColor = this.getDisplay().getSystemColor(1);
    private Color selectedBackgroundColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)0, (int)112, (int)195);
    private Color unselectedForegroundColor = this.getDisplay().getSystemColor(2);
    private Color unselectedBackgroundColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)203, (int)203, (int)203);
    private Color buttonBorderColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)96, (int)96, (int)96);
    private Color buttonBackgroundColor1 = SWTGraphicUtil.getDefaultColor((Control)this, (int)254, (int)254, (int)254);
    private Color buttonBackgroundColor2 = SWTGraphicUtil.getDefaultColor((Control)this, (int)192, (int)192, (int)192);
    private int gap = 5;
    private int insideMarginX = 5;
    private int insideMarginY = 5;
    private int arc = 3;
    private GC gc;
    private boolean mouseInside;

    public SwitchButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener(event -> this.onPaint(event));
        this.addListener(4, e -> {
            boolean bl = this.selection = !this.selection;
            if (SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e)) {
                this.redraw();
            } else {
                this.selection = !this.selection;
            }
        });
        this.mouseInside = false;
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                SwitchButton.this.mouseInside = false;
                SwitchButton.this.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }
        });
    }

    private void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        this.gc = event.gc;
        this.gc.setAntialias(1);
        Point buttonSize = this.computeButtonSize();
        this.drawSwitchButton(buttonSize);
        this.drawText(buttonSize);
        if (this.borderColor != null) {
            this.drawBorder();
        }
    }

    private void drawSwitchButton(Point buttonSize) {
        this.gc.setForeground(this.buttonBorderColor);
        if (this.round) {
            this.gc.drawRoundRectangle(2, 2, buttonSize.x, buttonSize.y, this.arc, this.arc);
        } else {
            this.gc.drawRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        boolean enabled = this.isEnabled();
        this.drawRightPart(buttonSize, enabled);
        this.drawLeftPart(buttonSize, enabled);
        this.gc.setClipping(this.getClientArea());
        this.drawToggleButton(buttonSize);
    }

    private void drawRightPart(Point buttonSize, boolean enabled) {
        if (enabled) {
            this.gc.setForeground(this.selectedBackgroundColor);
            this.gc.setBackground(this.selectedBackgroundColor);
        } else {
            Color disabled = this.gc.getDevice().getSystemColor(38);
            this.gc.setForeground(disabled);
            this.gc.setBackground(disabled);
        }
        this.gc.setClipping(3, 3, buttonSize.x / 2, buttonSize.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, buttonSize.x, buttonSize.y, this.arc, this.arc);
        } else {
            this.gc.fillRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        if (enabled) {
            this.gc.setForeground(this.selectedForegroundColor);
        } else {
            this.gc.setForeground(this.gc.getDevice().getSystemColor(39));
        }
        Point textSize = this.gc.textExtent(this.textForSelect);
        this.gc.drawString(this.textForSelect, (buttonSize.x / 2 - textSize.x) / 2 + this.arc, (buttonSize.y - textSize.y) / 2 + this.arc);
    }

    private void drawLeftPart(Point buttonSize, boolean enabled) {
        if (enabled) {
            this.gc.setForeground(this.unselectedBackgroundColor);
            this.gc.setBackground(this.unselectedBackgroundColor);
        } else {
            Color disabled = this.gc.getDevice().getSystemColor(38);
            this.gc.setForeground(disabled);
            this.gc.setBackground(disabled);
        }
        this.gc.setClipping(buttonSize.x / 2 + 3, 3, buttonSize.x / 2, buttonSize.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, buttonSize.x, buttonSize.y, this.arc, this.arc);
        } else {
            this.gc.fillRectangle(2, 2, buttonSize.x, buttonSize.y);
        }
        if (enabled) {
            this.gc.setForeground(this.unselectedForegroundColor);
        } else {
            this.gc.setForeground(this.gc.getDevice().getSystemColor(39));
        }
        Point textSize = this.gc.textExtent(this.textForUnselect);
        this.gc.drawString(this.textForUnselect, buttonSize.x / 2 + (buttonSize.x / 2 - textSize.x) / 2 + this.arc, (buttonSize.y - textSize.y) / 2 + this.arc);
    }

    private void drawToggleButton(Point buttonSize) {
        this.gc.setForeground(this.buttonBackgroundColor1);
        this.gc.setBackground(this.buttonBackgroundColor2);
        if (this.selection) {
            this.gc.fillGradientRectangle(buttonSize.x / 2, this.arc, buttonSize.x / 2 + 2, buttonSize.y - 1, true);
        } else {
            this.gc.fillGradientRectangle(this.arc, this.arc, buttonSize.x / 2, buttonSize.y, true);
        }
        this.gc.setForeground(this.buttonBorderColor);
        if (this.selection) {
            this.gc.drawRoundRectangle(buttonSize.x / 2, 2, buttonSize.x / 2 + 2, buttonSize.y, this.arc, this.arc);
        } else {
            this.gc.drawRoundRectangle(2, 2, buttonSize.x / 2, buttonSize.y, this.arc, this.arc);
        }
        if (this.focusColor != null && this.mouseInside) {
            this.gc.setForeground(this.focusColor);
            this.gc.setLineWidth(2);
            if (this.selection) {
                this.gc.drawRoundRectangle(buttonSize.x / 2 + 1, 3, buttonSize.x / 2, buttonSize.y - 2, 3, 3);
            } else {
                this.gc.drawRoundRectangle(3, 3, buttonSize.x / 2, buttonSize.y - 1, 3, 3);
            }
            this.gc.setLineWidth(1);
        }
    }

    private Point computeButtonSize() {
        Point sizeForLeftPart = this.gc.stringExtent(this.textForSelect);
        Point sizeForRightPart = this.gc.stringExtent(this.textForUnselect);
        int width = Math.max(sizeForLeftPart.x, sizeForRightPart.x) * 2 + 2 * this.insideMarginX;
        int height = Math.max(sizeForLeftPart.y, sizeForRightPart.y) + 2 * this.insideMarginY;
        return new Point(width, height);
    }

    private void drawText(Point buttonSize) {
        this.gc.setForeground(this.getForeground());
        this.gc.setBackground(this.getBackground());
        int widgetHeight = this.computeSize((int)0, (int)0, (boolean)true).y;
        int textHeight = this.gc.stringExtent((String)this.text).y;
        int x = 2 + buttonSize.x + this.gap;
        this.gc.drawString(this.text, x, (widgetHeight - textHeight) / 2);
    }

    private void drawBorder() {
        if (this.borderColor == null) {
            return;
        }
        this.gc.setForeground(this.borderColor);
        Point temp = this.computeSize(0, 0, false);
        if (this.round) {
            this.gc.drawRoundRectangle(0, 0, temp.x - 2, temp.y - 2, 3, 3);
        } else {
            this.gc.drawRectangle(0, 0, temp.x - 2, temp.y - 2);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        boolean disposeGC = false;
        if (this.gc == null || this.gc.isDisposed()) {
            this.gc = new GC((Drawable)this);
            disposeGC = true;
        }
        Point buttonSize = this.computeButtonSize();
        int width = buttonSize.x;
        int height = buttonSize.y;
        if (this.text != null && this.text.trim().length() > 0) {
            Point textSize = this.gc.textExtent(this.text);
            width += textSize.x + this.gap + 1;
        }
        width += 4;
        height += 6;
        if (disposeGC) {
            this.gc.dispose();
        }
        return new Point(width, height);
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.checkWidget();
        this.selection = selection;
        this.redraw();
    }

    public String getTextForSelect() {
        this.checkWidget();
        return this.textForSelect;
    }

    public void setTextForSelect(String textForSelect) {
        this.checkWidget();
        this.textForSelect = textForSelect;
        this.redraw();
    }

    public String getTextForUnselect() {
        this.checkWidget();
        return this.textForUnselect;
    }

    public void setTextForUnselect(String textForUnselect) {
        this.checkWidget();
        this.textForUnselect = textForUnselect;
        this.redraw();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
        this.redraw();
    }

    public boolean isRound() {
        this.checkWidget();
        return this.round;
    }

    public void setRound(boolean round) {
        this.checkWidget();
        this.round = round;
        this.redraw();
    }

    public Color getBorderColor() {
        this.checkWidget();
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.checkWidget();
        this.borderColor = borderColor;
        this.redraw();
    }

    public Color getFocusColor() {
        this.checkWidget();
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.checkWidget();
        this.focusColor = focusColor;
        this.redraw();
    }

    public Color getSelectedForegroundColor() {
        this.checkWidget();
        return this.selectedForegroundColor;
    }

    public void setSelectedForegroundColor(Color selectedForegroundColor) {
        this.checkWidget();
        this.selectedForegroundColor = selectedForegroundColor;
        this.redraw();
    }

    public Color getSelectedBackgroundColor() {
        this.checkWidget();
        return this.selectedBackgroundColor;
    }

    public void setSelectedBackgroundColor(Color selectedBackgroundColor) {
        this.checkWidget();
        this.selectedBackgroundColor = selectedBackgroundColor;
        this.redraw();
    }

    public Color getUnselectedForegroundColor() {
        this.checkWidget();
        return this.unselectedForegroundColor;
    }

    public void setUnselectedForegroundColor(Color unselectedForegroundColor) {
        this.checkWidget();
        this.unselectedForegroundColor = unselectedForegroundColor;
        this.redraw();
    }

    public Color getUnselectedBackgroundColor() {
        this.checkWidget();
        return this.unselectedBackgroundColor;
    }

    public void setUnselectedBackgroundColor(Color unselectedBackgroundColor) {
        this.checkWidget();
        this.unselectedBackgroundColor = unselectedBackgroundColor;
        this.redraw();
    }

    public Color getButtonBorderColor() {
        this.checkWidget();
        return this.buttonBorderColor;
    }

    public void setButtonBorderColor(Color buttonBorderColor) {
        this.checkWidget();
        this.buttonBorderColor = buttonBorderColor;
        this.redraw();
    }

    public Color getButtonBackgroundColor1() {
        this.checkWidget();
        return this.buttonBackgroundColor1;
    }

    public void setButtonBackgroundColor1(Color buttonBackgroundColor1) {
        this.checkWidget();
        this.buttonBackgroundColor1 = buttonBackgroundColor1;
        this.redraw();
    }

    public Color getButtonBackgroundColor2() {
        this.checkWidget();
        return this.buttonBackgroundColor2;
    }

    public void setButtonBackgroundColor2(Color buttonBackgroundColor2) {
        this.checkWidget();
        this.buttonBackgroundColor2 = buttonBackgroundColor2;
        this.redraw();
    }

    public int getGap() {
        this.checkWidget();
        return this.gap;
    }

    public void setGap(int gap) {
        this.checkWidget();
        this.gap = gap;
        this.redraw();
    }

    public Point getInsideMargin() {
        this.checkWidget();
        return new Point(this.insideMarginX, this.insideMarginY);
    }

    public void setInsideMargin(int insideMarginX, int insideMarginY) {
        this.checkWidget();
        this.insideMarginX = insideMarginX;
        this.insideMarginY = insideMarginY;
        this.redraw();
    }

    public void setInsideMargin(Point insideMargin) {
        this.checkWidget();
        this.insideMarginX = insideMargin.x;
        this.insideMarginY = insideMargin.y;
        this.redraw();
    }

    public int getArc() {
        this.checkWidget();
        return this.arc;
    }

    public void setArc(int arc) {
        this.checkWidget();
        this.arc = arc;
        this.redraw();
    }
}

