/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.splitbutton;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class SplitButton
extends Button {
    private static final int EXTRA_WIDTH = 60;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private int splitButtonAreaLeft = -1;
    private int splitButtonAreaTop = -1;
    private int splitButtonAreaRight = -1;
    private int splitButtonAreaBottom = -1;
    private Menu menu;

    public SplitButton(Composite parent, int style) {
        super(parent, SplitButton.checkStyle(style));
        this.setText("");
        this.addPaintListener();
        this.addMouseDownListener();
        this.menu = new Menu((Decorations)this.getShell(), 8);
    }

    private static int checkStyle(int style) {
        return SplitButton.checkBits(style, 0, 8, 2);
    }

    private static int checkBits(int style, int int0, int int1, int int2) {
        int mask = int0 | int1 | int2;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        return style;
    }

    private void addPaintListener() {
        super.addPaintListener(new PaintListener(){
            private PaintEvent e;
            private int deltaX;
            private int deltaY;

            public void paintControl(PaintEvent e) {
                this.e = e;
                Rectangle rect = SplitButton.this.getBounds();
                Color oldForeground = e.gc.getForeground();
                Color oldBackground = e.gc.getBackground();
                SplitButton.this.splitButtonAreaLeft = e.x + rect.width - 20;
                SplitButton.this.splitButtonAreaTop = e.y;
                SplitButton.this.splitButtonAreaRight = e.x + rect.width;
                SplitButton.this.splitButtonAreaBottom = e.y + rect.height;
                String osName = System.getProperty("os.name");
                boolean isMac = osName.toLowerCase().indexOf("mac os") > -1;
                int macDelta = isMac ? 2 : 0;
                this.deltaX = -e.gc.getClipping().x - macDelta;
                this.deltaY = -e.gc.getClipping().y - macDelta;
                this.drawLine();
                this.drawTriangle();
                e.gc.setForeground(oldForeground);
                e.gc.setBackground(oldBackground);
            }

            private void drawLine() {
                Rectangle rect = SplitButton.this.getBounds();
                this.e.gc.setForeground(SplitButton.this.getDisplay().getSystemColor(18));
                this.e.gc.setBackground(SplitButton.this.getDisplay().getSystemColor(18));
                this.e.gc.setLineWidth(1);
                this.e.gc.drawLine(this.e.x + rect.width - 20 + this.deltaX, this.e.y + 6 + this.deltaY, this.e.x + rect.width - 20 + this.deltaX, this.e.y + rect.height - 6 + this.deltaY);
            }

            private void drawTriangle() {
                Rectangle rect = SplitButton.this.getBounds();
                this.e.gc.setForeground(SplitButton.this.getDisplay().getSystemColor(2));
                this.e.gc.setBackground(SplitButton.this.getDisplay().getSystemColor(2));
                this.e.gc.fillPolygon(new int[]{this.e.x + rect.width - 15 + this.deltaX, this.e.y + rect.height / 2 - 1 + this.deltaY, this.e.x + rect.width - 8 + this.deltaX, this.e.y + rect.height / 2 - 1 + this.deltaY, this.e.x + rect.width - 12 + this.deltaX, this.e.y + rect.height / 2 + 3 + this.deltaY});
            }
        });
    }

    private void addMouseDownListener() {
        super.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (this.shouldShowMenu(event.x, event.y)) {
                    Button button = (Button)event.widget;
                    Rectangle rect = button.getBounds();
                    Point p = button.toDisplay(rect.x, rect.y + rect.height);
                    SplitButton.this.getMenu().setLocation(p.x - rect.x, p.y - rect.y);
                    SplitButton.this.getMenu().setVisible(true);
                } else {
                    for (Listener listener : SplitButton.this.listeners) {
                        Event evt = new Event();
                        evt.widget = SplitButton.this;
                        evt.display = SplitButton.this.getDisplay();
                        evt.type = 13;
                        listener.handleEvent(evt);
                    }
                }
            }

            private boolean shouldShowMenu(int x, int y) {
                return x >= SplitButton.this.splitButtonAreaLeft && y >= SplitButton.this.splitButtonAreaTop && x <= SplitButton.this.splitButtonAreaRight && y <= SplitButton.this.splitButtonAreaBottom;
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.listeners.add((Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        Iterator<Listener> it = this.listeners.iterator();
        while (it.hasNext()) {
            TypedListener tl;
            Listener current = it.next();
            if (!(current instanceof TypedListener) || (tl = (TypedListener)current).getEventListener() == null || !tl.getEventListener().equals(listener)) continue;
            it.remove();
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (eventType == 13) {
            this.listeners.add(listener);
            return;
        }
        super.addListener(eventType, listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (eventType == 13) {
            this.listeners.add(listener);
            return;
        }
        super.removeListener(eventType, listener);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        this.menu = menu;
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point point = super.computeSize(wHint, hHint, changed);
        point.x += 60;
        return point;
    }
}

