/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    void destroyHandle() {
        super.destroyWidget();
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0) {
            return this.gtk_widget_get_sensitive(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_step_increment(this.adjustmentHandle);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_upper(this.adjustmentHandle);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_lower(this.adjustmentHandle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_page_increment(this.adjustmentHandle);
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_value(this.adjustmentHandle);
    }

    public Point getSize() {
        this.checkWidget();
        if (this.handle == 0) {
            return new Point(0, 0);
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.handle, gtkRequisition);
        return new Point(gtkRequisition.width, gtkRequisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        return (int)this.gtk_adjustment_get_page_size(this.adjustmentHandle);
    }

    public Rectangle getThumbBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gtk_range_get_slider_range(this.handle, nArray, nArray2);
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, gtkAllocation);
        if ((this.style & 0x200) != 0) {
            n4 = gtkAllocation.x;
            n3 = nArray[0];
            n2 = gtkAllocation.width;
            n = nArray2[0] - nArray[0];
        } else {
            n4 = nArray[0];
            n3 = gtkAllocation.y;
            n2 = nArray2[0] - nArray[0];
            n = gtkAllocation.height;
        }
        Rectangle rectangle = new Rectangle(n4, n3, n2, n);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n5 = this.gtk_widget_get_window(this.parent.scrolledHandle);
        if (n5 != 0) {
            OS.gdk_window_get_origin(n5, nArray3, nArray4);
        }
        rectangle.x += nArray3[0];
        rectangle.y += nArray4[0];
        n5 = this.gtk_widget_get_window(this.parent.handle);
        if (n5 != 0) {
            OS.gdk_window_get_origin(n5, nArray3, nArray4);
        }
        rectangle.x -= nArray3[0];
        rectangle.y -= nArray4[0];
        return rectangle;
    }

    public Rectangle getThumbTrackBounds() {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2;
        int n3;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        int[] nArray3 = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.has_backward_stepper, nArray3, 0);
        boolean bl = nArray3[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_secondary_backward_stepper, nArray3, 0);
        boolean bl2 = nArray3[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_forward_stepper, nArray3, 0);
        boolean bl3 = nArray3[0] != 0;
        OS.gtk_widget_style_get(this.handle, OS.has_secondary_forward_stepper, nArray3, 0);
        boolean bl4 = nArray3[0] != 0;
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, gtkAllocation);
        if ((this.style & 0x200) != 0) {
            n3 = gtkAllocation.width;
            n4 = gtkAllocation.x;
            if (bl) {
                n5 += n3;
            }
            if (bl2) {
                n5 += n3;
            }
            n2 = gtkAllocation.width;
            n = gtkAllocation.height - n5;
            if (bl3) {
                n -= n3;
            }
            if (bl4) {
                n -= n3;
            }
            if (n < 0) {
                nArray2 = new int[1];
                nArray = new int[1];
                this.gtk_range_get_slider_range(this.handle, nArray2, nArray);
                n5 = nArray2[0];
                n = 0;
            }
        } else {
            n3 = gtkAllocation.height;
            if (bl) {
                n4 += n3;
            }
            if (bl2) {
                n4 += n3;
            }
            n5 = gtkAllocation.y;
            n2 = gtkAllocation.width - n4;
            if (bl3) {
                n2 -= n3;
            }
            if (bl4) {
                n2 -= n3;
            }
            n = gtkAllocation.height;
            if (n2 < 0) {
                nArray2 = new int[1];
                nArray = new int[1];
                this.gtk_range_get_slider_range(this.handle, nArray2, nArray);
                n4 = nArray2[0];
                n2 = 0;
            }
        }
        Rectangle rectangle = new Rectangle(n4, n5, n2, n);
        nArray2 = new int[1];
        nArray = new int[1];
        int n6 = this.gtk_widget_get_window(this.parent.scrolledHandle);
        if (n6 != 0) {
            OS.gdk_window_get_origin(n6, nArray2, nArray);
        }
        rectangle.x += nArray2[0];
        rectangle.y += nArray[0];
        n6 = this.gtk_widget_get_window(this.parent.handle);
        if (n6 != 0) {
            OS.gdk_window_get_origin(n6, nArray2, nArray);
        }
        rectangle.x -= nArray2[0];
        rectangle.y -= nArray[0];
        return rectangle;
    }

    public boolean getVisible() {
        this.checkWidget();
        int n = this.parent.scrolledHandle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_scrolled_window_get_policy(n, nArray, nArray2);
        if ((this.style & 0x100) != 0) {
            return nArray[0] != 2 && this.gtk_widget_get_visible(this.handle);
        }
        return nArray2[0] != 2 && this.gtk_widget_get_visible(this.handle);
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        this.detail = 0;
        this.dragSent = false;
        return n3;
    }

    int gtk_change_value(int n, int n2, int n3, int n4) {
        this.detail = n2;
        return 0;
    }

    void gtk_range_get_slider_range(int n, int[] nArray, int[] nArray2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            OS.gtk_range_get_slider_range(n, nArray, nArray2);
        } else {
            nArray[0] = OS.GTK_RANGE_SLIDER_START(n);
            nArray2[0] = OS.GTK_RANGE_SLIDER_END(n);
        }
    }

    int gtk_value_changed(int n) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        this.parent.updateScrollBarValue(this);
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
                break;
            }
        }
        return super.gtk_event_after(n, n2);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.closures[7], false);
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void register() {
        super.register();
        if (this.adjustmentHandle != 0) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.handle != 0) {
            OS.gtk_widget_set_sensitive(this.handle, bl);
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_set_step_increment(this.adjustmentHandle, n);
        } else {
            GtkAdjustment gtkAdjustment = new GtkAdjustment();
            OS.memmove(gtkAdjustment, this.adjustmentHandle);
            gtkAdjustment.step_increment = n;
            OS.memmove(this.adjustmentHandle, gtkAdjustment);
            OS.gtk_adjustment_changed(this.adjustmentHandle);
        }
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        int n2 = (int)gtkAdjustment.lower;
        if (n <= n2) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n2);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        int n2 = (int)gtkAdjustment.upper;
        if (n >= n2) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n2 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!((this.parent.style & 0x8000000) == 0 && bl || (this.parent.state & 2) == 0 || (this.style & 0x100) == 0)) {
            OS.gtk_range_set_inverted(this.handle, (this.parent.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_set_page_increment(this.adjustmentHandle, n);
        } else {
            GtkAdjustment gtkAdjustment = new GtkAdjustment();
            OS.memmove(gtkAdjustment, this.adjustmentHandle);
            gtkAdjustment.page_increment = n;
            OS.memmove(this.adjustmentHandle, gtkAdjustment);
            OS.gtk_adjustment_changed(this.adjustmentHandle);
        }
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = Math.min(n, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        OS.gtk_adjustment_set_value(this.adjustmentHandle, n);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment);
        OS.gtk_adjustment_value_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 57);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, bl)) {
            this.sendEvent(bl ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }
}

