/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.poi;

import java.util.HashMap;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.extension.poi.PoiExcelExporter;

public class XSSFExcelExporter
extends PoiExcelExporter {
    private HashMap<org.eclipse.swt.graphics.Color, XSSFColor> colorIndex = new HashMap();

    public XSSFExcelExporter() {
        super((IOutputStreamProvider)new FileOutputStreamProvider("table_export.xlsx", new String[]{"Excel Workbook (*.xlsx)"}, new String[]{"*.xlsx"}));
    }

    public XSSFExcelExporter(IOutputStreamProvider outputStreamProvider) {
        super(outputStreamProvider);
    }

    @Override
    protected Workbook createWorkbook() {
        this.colorIndex = new HashMap();
        return new XSSFWorkbook();
    }

    @Override
    protected void setFillForegroundColor(CellStyle xlCellStyle, org.eclipse.swt.graphics.Color swtColor) {
        xlCellStyle.setFillForegroundColor((Color)this.getColor(swtColor));
    }

    @Override
    protected void setFontColor(Font xlFont, org.eclipse.swt.graphics.Color swtColor) {
        ((XSSFFont)xlFont).setColor(this.getColor(swtColor));
    }

    private XSSFColor getColor(org.eclipse.swt.graphics.Color swtColor) {
        return this.colorIndex.computeIfAbsent(swtColor, c -> {
            byte[] rgb = new byte[]{(byte)swtColor.getRed(), (byte)swtColor.getGreen(), (byte)swtColor.getBlue()};
            XSSFColor xc = new XSSFColor(rgb, null);
            return xc;
        });
    }
}

