/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ResourceLoaderUtil {
    private static final ClassLoader CLASSLOADER = ResourceLoaderUtil.class.getClassLoader();

    public static String readTextContent(String resource) {
        try {
            return ResourceLoaderUtil.readTextChecked(resource);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Failed to read: " + resource, e);
        }
    }

    private static String readTextChecked(String resource) throws URISyntaxException, IOException {
        URL url = CLASSLOADER.getResource("org/eclipse/nebula/widgets/nattable/" + resource);
        Bundle bundle = FrameworkUtil.getBundle(ResourceLoaderUtil.class);
        if (bundle != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("Resource file not found: " + resource);
        }
        Path path = Paths.get(url.toURI());
        Throwable throwable = null;
        Object var5_7 = null;
        try (Stream<String> lines = Files.lines(path);){
            return lines.collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

