// Copyright 2025 Ben Manes. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;

/**
 * <em>WARNING: GENERATED CODE</em>
 *
 * <p>A cache that provides the following features:
 *
 * <ul>
 *   <li>StrongKeys
 *   <li>InfirmValues
 * </ul>
 *
 * @author ben.manes@gmail.com (Ben Manes)
 */
@SuppressWarnings("unchecked")
class SI<K, V> extends BoundedLocalCache<K, V> {
  static final LocalCacheFactory FACTORY = SI::new;

  final ReferenceQueue<V> valueReferenceQueue = new ReferenceQueue<V>();

  SI(Caffeine<K, V> builder, AsyncCacheLoader<? super K, V> cacheLoader, boolean async) {
    super(builder, (AsyncCacheLoader<K, V>) cacheLoader, async);
  }

  protected final ReferenceQueue<V> valueReferenceQueue() {
    return valueReferenceQueue;
  }

  protected final boolean collectValues() {
    return true;
  }
}
