/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class HideQueryAction
extends BaseSelectionListenerAction {
    public HideQueryAction() {
        super(Messages.HideQueryAction_Hidden_Label);
        this.setChecked(false);
        this.setEnabled(false);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        boolean hidden = true;
        for (Object element : selection.toList()) {
            if (element instanceof IRepositoryQuery) {
                hidden &= Boolean.parseBoolean(((IRepositoryQuery)element).getAttribute("task.common.hidden"));
                continue;
            }
            return false;
        }
        this.setChecked(hidden);
        return true;
    }

    public void run() {
        for (Object element : this.getStructuredSelection().toList()) {
            if (!(element instanceof IRepositoryQuery)) continue;
            try {
                IRepositoryQuery query = (IRepositoryQuery)element;
                TasksUiPlugin.getTaskList().run(monitor -> query.setAttribute("task.common.hidden", Boolean.toString(this.isChecked())));
                TasksUiPlugin.getTaskList().notifyElementsChanged(Collections.singleton((IRepositoryElement)query));
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to set hidden status for query", (Throwable)e));
            }
        }
    }
}

