/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.externalization.AttributesWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.ContentHandlerWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxCategoryWriter;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxOrphanWriter;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxQueryWriter;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementWriter;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskWriter;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SaxTaskListWriter {
    private static final String ATTRIBUTE_VERSION = "Version";
    private static final String VALUE_VERSION = "2.0";
    private OutputStream outputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeTaskListToStream(ITransferList taskList, Document orphans) throws IOException {
        if (this.outputStream == null) {
            throw new IOException("OutputStream not set");
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new TaskListWriter(), new TaskListInputSource(taskList, orphans)), new StreamResult(this.outputStream));
        }
        catch (TransformerException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not write task list", (Throwable)e));
            throw new IOException(e.getMessage(), e);
        }
    }

    private static class TaskListInputSource
    extends InputSource {
        private final ITransferList taskList;
        private final Document orphans;

        public TaskListInputSource(ITransferList taskList, Document orphans) {
            this.taskList = taskList;
            this.orphans = orphans;
        }

        public ITransferList getTaskList() {
            return this.taskList;
        }

        public Document getOrphans() {
            return this.orphans;
        }
    }

    private static class TaskListWriter
    implements XMLReader {
        private ContentHandlerWrapper handler;
        private ErrorHandler errorHandler;

        private TaskListWriter() {
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.handler = new ContentHandlerWrapper(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.handler.getHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            void taskListInputSource;
            if (!(input instanceof TaskListInputSource)) {
                throw new SAXException("Can only parse writable input sources");
            }
            TaskListInputSource taskListInputSource2 = (TaskListInputSource)input;
            this.handler.getHandler().startDocument();
            this.writeTaskList(taskListInputSource.getTaskList(), taskListInputSource.getOrphans());
            this.handler.getHandler().endDocument();
        }

        private void writeTaskList(ITransferList taskList, Document orphanDocument) throws IOException, SAXException {
            AttributesWrapper attributes = new AttributesWrapper();
            attributes.addAttribute(SaxTaskListWriter.ATTRIBUTE_VERSION, SaxTaskListWriter.VALUE_VERSION);
            this.handler.startElement("TaskList", attributes);
            this.writeTaskListElements(new SaxTaskWriter(this.handler), taskList.getAllTasks());
            this.writeTaskListElements(new SaxCategoryWriter(this.handler), taskList.getCategories());
            this.writeTaskListElements(new SaxQueryWriter(this.handler), taskList.getQueries());
            this.writeOrphans(orphanDocument);
            this.handler.endElement("TaskList");
        }

        private <T extends IRepositoryElement> void writeTaskListElements(SaxTaskListElementWriter<T> writer, Collection<T> elements) throws SAXException {
            for (IRepositoryElement element : elements) {
                writer.writeElement(element);
            }
            if (!writer.getErrors().isOK()) {
                StatusHandler.log((IStatus)writer.getErrors());
            }
        }

        private void writeOrphans(Document orphanDocument) throws SAXException {
            if (orphanDocument != null) {
                SaxOrphanWriter writer = new SaxOrphanWriter(this.handler);
                NodeList orphanNodes = orphanDocument.getChildNodes();
                if (orphanNodes.getLength() == 1) {
                    writer.writeOrphans(orphanNodes.item(0).getChildNodes());
                }
            }
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            throw new SAXException("Can only parse writable input sources");
        }
    }
}

