/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.team.ui.actions.TaskFinder;

public class TaskFinderTest
extends TestCase {
    public void test07LegacyMatching() {
        String label = "Progress on: 123: foo \nhttps://bugs.eclipse.org";
        String id = TaskFinder.getTaskIdFromLegacy07Label((String)label);
        TaskFinderTest.assertEquals((String)"123", (String)id);
    }

    public void testUrlMatching() {
        String label = "bla bla\nhttp://foo.bar-123 bla bla";
        String id = TaskFinder.getUrlFromComment((String)label);
        TaskFinderTest.assertEquals((String)"http://foo.bar-123", (String)id);
        label = "bla bla\nhttp://foo.bar-1234\n- bla bla";
        id = TaskFinder.getUrlFromComment((String)label);
        TaskFinderTest.assertEquals((String)"http://foo.bar-1234", (String)id);
    }

    public void testExtractTaskId() throws Exception {
        TaskFinderTest.assertNull((Object)TaskFinder.extractTaskId((String)"http://example.com/tasks/123", (String)"", (String)""));
        TaskFinderTest.assertNull((Object)TaskFinder.extractTaskId((String)"http://example.com/tasks/123", (String)"prefix", (String)"postfix"));
        TaskFinderTest.assertNull((Object)TaskFinder.extractTaskId((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/", (String)"postfix"));
        TaskFinderTest.assertEquals((String)"123", (String)TaskFinder.extractTaskId((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/", (String)""));
        TaskFinderTest.assertEquals((String)"123", (String)TaskFinder.extractTaskId((String)"http://example.com/tasks/123/viewtask.asp", (String)"http://example.com/tasks/", (String)"/viewtask.asp"));
        TaskFinderTest.assertNull((Object)TaskFinder.extractTaskId((String)"http://example.com/tasks/123/viewtask.asp", (String)"http://example.com/tasks/", (String)"/viewtask.cgi"));
    }

    public void testGuessTaskKey() throws Exception {
        TaskFinderTest.assertNull((Object)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123", (String)"", (String)""));
        TaskFinderTest.assertNull((Object)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/45", (String)"123"));
        TaskFinderTest.assertNull((Object)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/45", (String)"450"));
        TaskFinderTest.assertNull((Object)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/45", (String)"045"));
        TaskFinderTest.assertEquals((String)"123", (String)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123", (String)"http://example.com/tasks/45", (String)"45"));
        TaskFinderTest.assertEquals((String)"123", (String)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123/viewtask.asp", (String)"http://example.com/tasks/45/viewtask.asp", (String)"45"));
        TaskFinderTest.assertNull((Object)TaskFinder.guessTaskKey((String)"http://example.com/tasks/123/viewtask.asp", (String)"http://example.com/tasks/45", (String)"/viewtask.cgi"));
    }
}

