/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.Test;

public class CopyCommitMessageHandlerTest
extends TestCase {
    private Clipboard clipboard;
    private TaskRepository repository;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.clipboard = new Clipboard(display);
        FocusedTeamUiPlugin.getDefault().getPreferenceStore().setToDefault("org.eclipse.mylyn.team.commit.template");
    }

    protected void tearDown() throws Exception {
        this.clipboard.dispose();
        TaskTestUtil.resetTaskListAndRepositories();
    }

    @Test
    public void testCopyCommitMessage() throws Exception {
        String contents = this.getClipboardContents();
        this.executeCommand();
        CopyCommitMessageHandlerTest.assertEquals((String)contents, (String)this.getClipboardContents());
        this.addAndSelectTask();
        this.executeCommand();
        CopyCommitMessageHandlerTest.assertEquals((String)"1: My Task\n\nTask-Url: http://url", (String)this.getClipboardContents());
    }

    private void addAndSelectTask() throws Exception {
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, "1");
        task.setTaskKey("1");
        task.setSummary("My Task");
        task.setUrl("http://url");
        TaskTestUtil.addAndSelectTask((ITask)task);
    }

    private String getClipboardContents() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return (String)this.clipboard.getContents((Transfer)textTransfer);
    }

    public void executeCommand() throws Exception {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.mylyn.team.ui.commands.CopyCommitMessage");
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ExecutionEvent event = handlerService.createExecutionEvent(command, null);
        command.executeWithChecks(event);
    }
}

