/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.tests;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.templates.CommitTemplateManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class CommitTemplateTest
extends TestCase {
    public void testCreateTemplate() {
        String template = "${task.status} - ${connector.task.prefix} ${task.key}: ${task.description}";
        String taskId = "12345678";
        TaskTask testTask = new TaskTask("no url", taskId, "summary");
        testTask.setTaskKey(taskId);
        String commitComment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)testTask, template);
        CommitTemplateTest.assertTrue((boolean)commitComment.contains(taskId));
        testTask.setTaskKey(null);
        commitComment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)testTask, template);
        CommitTemplateTest.assertFalse((boolean)commitComment.contains(taskId));
    }

    public void testTemplateNullKeyTrailingCharacters() {
        String template = "${task.status} - ${connector.task.prefix} ${task.key}: ${task.description}";
        TaskTask testTask = this.createTask();
        String commitComment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)testTask, template);
        CommitTemplateTest.assertTrue((boolean)commitComment.contains(testTask.getSummary()));
        CommitTemplateTest.assertTrue((boolean)commitComment.contains(":"));
        CommitTemplateTest.assertEquals((String)"Incomplete - : TestSummary", (String)commitComment);
    }

    public void testTemplateCollapseWhitespace() {
        String template = "${task.status} - ${connector.task.prefix} ${task.key} ${task.key} : ${task.description}";
        TaskTask testTask = this.createTask();
        String commitComment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)testTask, template);
        CommitTemplateTest.assertTrue((boolean)commitComment.contains(testTask.getSummary()));
        CommitTemplateTest.assertFalse((boolean)commitComment.contains("  "));
        CommitTemplateTest.assertEquals((String)"Incomplete - : TestSummary", (String)commitComment);
    }

    public void testTemplateWithTab() {
        String template = "${task.status} - \t${connector.task.prefix} ${task.key} ${task.key} : ${task.description}";
        TaskTask testTask = this.createTask();
        String commitComment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)testTask, template);
        CommitTemplateTest.assertTrue((boolean)commitComment.contains(testTask.getSummary()));
        CommitTemplateTest.assertTrue((boolean)commitComment.contains("\t"));
        CommitTemplateTest.assertEquals((String)"Incomplete - \t : TestSummary", (String)commitComment);
    }

    public void testTemplateVariableWithParameters() {
        CommitTemplateManager manager = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager();
        TaskTask testTask = this.createTask();
        CommitTemplateTest.assertEquals((String)"ABC", (String)manager.generateComment((ITask)testTask, "${TestVar(\"ABC\")}"));
        CommitTemplateTest.assertEquals((String)"one ABC two", (String)manager.generateComment((ITask)testTask, "one ${TestVar(\"ABC\")} two"));
        CommitTemplateTest.assertEquals((String)"oneABCtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\")}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEFtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\",\"DEF\")}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEFtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\", \"DEF\")}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEFtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\" ,\"DEF\")}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEFtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\" , \"DEF\")}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEFtwo", (String)manager.generateComment((ITask)testTask, "one${TestVar( \"ABC\" , \"DEF\" )}two"));
        CommitTemplateTest.assertEquals((String)"oneABC-DEF-GHItwo", (String)manager.generateComment((ITask)testTask, "one${TestVar(\"ABC\", \"DEF\", \"GHI\")}two"));
        CommitTemplateTest.assertEquals((String)"Incomplete x-y TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( \"x\" , \"y\" )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"one ABC DEF two", (String)manager.generateComment((ITask)testTask, "one ${TestVar(\"ABC\")} ${TestVar(\"DEF\")} two"));
        CommitTemplateTest.assertEquals((String)"one two", (String)manager.generateComment((ITask)testTask, "one ${TestVar(\"\")} two"));
        CommitTemplateTest.assertEquals((String)"Incomplete TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar()} ${task.description}"));
    }

    public void testTemplateVariableWithParametersIncorrectSyntax() {
        CommitTemplateManager manager = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager();
        TaskTask testTask = this.createTask();
        CommitTemplateTest.assertEquals((String)"Incomplete x , \"y TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( \"x , \"y\" )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"Incomplete x\" \"y TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( \"x\" \"y\" )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"Incomplete TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( \"x , )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"Incomplete TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( \"x\" , )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"Incomplete TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${TestVar( x )} ${task.description}"));
        CommitTemplateTest.assertEquals((String)"Incomplete TestSummary", (String)manager.generateComment((ITask)testTask, "${task.status} ${noexist( \"x\" )} ${task.description}"));
    }

    private TaskTask createTask() {
        String taskId = "12345678";
        TaskTask testTask = new TaskTask("no url", taskId, "summary");
        testTask.setTaskKey(null);
        testTask.setSummary("TestSummary");
        return testTask;
    }

    public void testRepositoryTaskCommentParsing() {
        String template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
        MockTask task = new MockTask("12345");
        String comment = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)task, template);
        String taskId = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().getTaskIdFromCommentOrLabel(comment);
        CommitTemplateTest.assertEquals((String)"12345", (String)taskId);
    }

    public void testRepositoryTaskCommentParsingMultiline() {
        String template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
        MockTask task = new MockTask("12345");
        String comment = String.valueOf(FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment((ITask)task, template)) + "\n";
        String taskId = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().getTaskIdFromCommentOrLabel(comment);
        CommitTemplateTest.assertEquals((String)"12345", (String)taskId);
    }

    public void testRegex() {
        String comment = "task 123: label for handle-123";
        String regex = ".*\\ (\\d+):\\ .*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(comment);
        CommitTemplateTest.assertTrue((boolean)matcher.find());
    }
}

