/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractTaskEditorPageTest {
    private TaskRepository repository;
    private ITask task;
    private TaskData taskData;
    private AbstractTaskEditorPage page;
    private IManagedForm form;
    private TaskAttribute attribute;

    @Before
    public void setUp() {
        this.repository = TaskTestUtil.createMockRepository();
        this.task = TaskTestUtil.createMockTask((String)"1");
        this.taskData = TaskTestUtil.createMockTaskData((String)"1");
        this.attribute = this.taskData.getRoot().createAttribute("test");
        this.page = (AbstractTaskEditorPage)Mockito.spy((Object)((Object)new TestAbstractTaskEditorPage((TaskEditor)Mockito.mock(TaskEditor.class), this.task.getConnectorKind())));
        this.form = (IManagedForm)Mockito.mock(IManagedForm.class);
        Mockito.when((Object)this.page.getManagedForm()).thenReturn((Object)this.form);
        this.page.init(this.createSite(), (IEditorInput)new TaskEditorInput(this.repository, this.task));
    }

    private IEditorSite createSite() {
        IEditorSite site = (IEditorSite)Mockito.mock(IEditorSite.class);
        IHandlerService service = (IHandlerService)Mockito.mock(IHandlerService.class);
        Mockito.when((Object)site.getService((Class)ArgumentMatchers.any())).thenReturn((Object)service);
        return site;
    }

    @Test
    public void testInitModelListener() {
        this.page.getModel().attributeChanged(this.attribute);
        ((IManagedForm)Mockito.verify((Object)this.form)).dirtyStateChanged();
    }

    @Test
    public void testInitModelListenerDirtyForm() {
        Mockito.when((Object)this.form.isDirty()).thenReturn((Object)true);
        this.page.getModel().attributeChanged(this.attribute);
        ((IManagedForm)Mockito.verify((Object)this.form, (VerificationMode)Mockito.never())).dirtyStateChanged();
    }

    public class TestAbstractTaskEditorPage
    extends AbstractTaskEditorPage {
        private TestAbstractTaskEditorPage(TaskEditor editor, String connectorKind) {
            super(editor, connectorKind);
        }

        protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
            TaskDataModel model = (TaskDataModel)Mockito.spy((Object)new TaskDataModel(input.getTaskRepository(), input.getTask(), (ITaskDataWorkingCopy)Mockito.mock(ITaskDataWorkingCopy.class)));
            Mockito.when((Object)model.getTaskData()).thenReturn((Object)AbstractTaskEditorPageTest.this.taskData);
            return model;
        }
    }
}

