/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationUi;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.DefaultTasksState;
import org.eclipse.mylyn.internal.tasks.ui.migrator.JobListener;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class ConnectorMigratorTest {
    private final ImmutableMap<String, String> kinds = ImmutableMap.of((Object)"mock", (Object)"mock.new");
    private final TaskRepository repository = new TaskRepository("mock", "http://mock");
    private final ImmutableSet<TaskRepository> singleRepository = ImmutableSet.of((Object)this.repository);
    private TaskRepository migratedRepository = new TaskRepository("mock.new", "http://mock");
    private final AuthenticationCredentials repoCreds = new AuthenticationCredentials("u1", "p1");
    private final AuthenticationCredentials proxyCreds = new AuthenticationCredentials("u2", "p2");
    private final AuthenticationCredentials httpCreds = new AuthenticationCredentials("u3", "p3");
    private final AuthenticationCredentials certCreds = new AuthenticationCredentials("u4", "p4");
    private final AbstractRepositoryConnector connector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
    private final AbstractRepositoryConnector newConnector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
    private final TaskListView taskList = (TaskListView)Mockito.mock(TaskListView.class);
    private final TaskListBackupManager backupManager = (TaskListBackupManager)Mockito.mock(TaskListBackupManager.class);
    DefaultTasksState tasksState = (DefaultTasksState)Mockito.spy((Object)((Object)new SpyTasksState()));
    private TaskRepositoryManager manager = this.tasksState.getRepositoryManager();
    private final ConnectorMigrationUi migrationUi = (ConnectorMigrationUi)Mockito.spy((Object)new ConnectorMigrationUi(this.taskList, this.backupManager, (TasksState)this.tasksState));

    @Before
    public void setUp() {
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).warnOfValidationFailure((List)ArgumentMatchers.any(List.class));
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).notifyMigrationComplete();
    }

    @After
    public void tearDown() throws Exception {
        TestFixture.resetTaskList();
        new File("test-context.zip").delete();
    }

    @Test
    public void setConnectorsToMigrate() throws Exception {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new", (Object)"kind", (Object)"kind.new"), (Set<TaskRepository>)ImmutableSet.of((Object)this.repository, (Object)new TaskRepository("kind", "http://mock")), true);
        try {
            migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"foo"));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"kind"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"kind", (Object)"kind.new"), (Object)migrator.getSelectedConnectors());
    }

    @Test
    public void migrateConnectors() throws Exception {
        this.assertMigrateConnectors();
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi, (VerificationMode)Mockito.never())).warnOfValidationFailure((List)ArgumentMatchers.any());
    }

    @Test
    public void migrateConnectorsValidationFailure() throws Exception {
        Mockito.when((Object)this.newConnector.validateRepository((TaskRepository)ArgumentMatchers.any(TaskRepository.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class))).thenThrow(new Throwable[]{new CoreException((IStatus)new Status(0, "org.eclipse.mylyn.tasks.ui.tests", 0, "Error", (Throwable)new Exception()))});
        this.assertMigrateConnectors();
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).warnOfValidationFailure((List)ImmutableList.of((Object)this.migratedRepository));
    }

    @Test
    public void cancelMigration() throws Exception {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true));
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        IProgressMonitor spyMonitor = (IProgressMonitor)Mockito.spy((Object)monitor);
        try {
            migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"mock"));
            migrator.migrateConnectors(spyMonitor);
            Assert.fail((String)"Expected OperationCanceledException");
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        ((IProgressMonitor)Mockito.verify((Object)spyMonitor)).beginTask("Migrating repositories", 2);
        ((IProgressMonitor)Mockito.verify((Object)spyMonitor)).isCanceled();
        ((TaskRepositoryManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).getRepositoryConnector((String)ArgumentMatchers.any(String.class));
        ((TaskRepositoryManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).addRepository((TaskRepository)ArgumentMatchers.any(TaskRepository.class));
        ((ConnectorMigrator)Mockito.verify((Object)migrator, (VerificationMode)Mockito.never())).getMigratedRepository((String)ArgumentMatchers.any(String.class), (TaskRepository)ArgumentMatchers.any(TaskRepository.class));
    }

    private ConnectorMigrator assertMigrateConnectors() throws CoreException, IOException {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true));
        IProgressMonitor monitor = this.migrateConnectors(migrator);
        Assert.assertTrue((boolean)this.repository.isOffline());
        Assert.assertEquals((Object)"http://mock (Unsupported, do not delete)", (Object)this.repository.getRepositoryLabel());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.manager, this.newConnector, this.migrationUi, migrator, monitor});
        ((IProgressMonitor)inOrder.verify((Object)monitor)).beginTask("Migrating repositories", 2);
        ((ConnectorMigrationUi)inOrder.verify((Object)this.migrationUi)).backupTaskList(monitor);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).subTask("Backing up task list");
        ((IProgressMonitor)inOrder.verify((Object)monitor)).worked(1);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).subTask("Migrating http://mock");
        ((ConnectorMigrator)inOrder.verify((Object)migrator)).migrateRepository("mock.new", "http://mock", this.repository);
        ((TaskRepositoryManager)inOrder.verify((Object)this.manager)).addRepository(this.migratedRepository);
        ((ConnectorMigrator)inOrder.verify((Object)migrator)).disconnect(this.repository);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).worked(1);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).beginTask("Validating repository connections", 1);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).subTask("Validating connection to http://mock");
        ((AbstractRepositoryConnector)inOrder.verify((Object)this.newConnector)).validateRepository(this.migratedRepository, monitor);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).done();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.newConnector});
        return migrator;
    }

    private IProgressMonitor migrateConnectors(ConnectorMigrator migrator) throws IOException {
        IProgressMonitor monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        migrator.setConnectorsToMigrate((List)ImmutableList.of((Object)"mock"));
        migrator.migrateConnectors(monitor);
        return monitor;
    }

    @Test
    public void migrateRepository() throws Exception {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        this.populateRepository();
        this.migratedRepository = migrator.getMigratedRepository("mock.new", this.repository);
        Assert.assertEquals((Object)"foovalue", (Object)this.migratedRepository.getProperty("foo"));
        Assert.assertEquals((Object)"barvalue", (Object)this.migratedRepository.getProperty("bar"));
        Assert.assertNull((Object)this.migratedRepository.getProperty("lastsynctimestamp"));
        Assert.assertEquals((Object)"My Label", (Object)this.migratedRepository.getRepositoryLabel());
        Assert.assertEquals((Object)"mock.new", (Object)this.migratedRepository.getConnectorKind());
        Assert.assertEquals((Object)this.repoCreds, (Object)this.migratedRepository.getCredentials(AuthenticationType.REPOSITORY));
        Assert.assertEquals((Object)this.proxyCreds, (Object)this.migratedRepository.getCredentials(AuthenticationType.PROXY));
        Assert.assertEquals((Object)this.httpCreds, (Object)this.migratedRepository.getCredentials(AuthenticationType.HTTP));
        Assert.assertEquals((Object)this.certCreds, (Object)this.migratedRepository.getCredentials(AuthenticationType.CERTIFICATE));
        Assert.assertTrue((boolean)this.migratedRepository.getSavePassword(AuthenticationType.REPOSITORY));
        Assert.assertTrue((boolean)this.migratedRepository.getSavePassword(AuthenticationType.PROXY));
        Assert.assertFalse((boolean)this.migratedRepository.getSavePassword(AuthenticationType.HTTP));
        Assert.assertFalse((boolean)this.migratedRepository.getSavePassword(AuthenticationType.CERTIFICATE));
    }

    @Test
    public void migrateExistingRepositoryDoesNothing() throws Exception {
        this.migratedRepository.setRepositoryLabel("My Old Label");
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        Mockito.when((Object)this.manager.getRepository("mock.new", "http://mock")).thenReturn((Object)this.migratedRepository);
        this.populateRepository();
        Assert.assertSame((Object)this.migratedRepository, (Object)migrator.getMigratedRepository("mock.new", this.repository));
        Assert.assertNull((Object)this.migratedRepository.getProperty("foo"));
        Assert.assertNull((Object)this.migratedRepository.getProperty("bar"));
        Assert.assertNull((Object)this.migratedRepository.getProperty("lastsynctimestamp"));
        Assert.assertEquals((Object)"My Old Label", (Object)this.migratedRepository.getRepositoryLabel());
        Assert.assertEquals((Object)"mock.new", (Object)this.migratedRepository.getConnectorKind());
        Assert.assertNull((Object)this.migratedRepository.getCredentials(AuthenticationType.REPOSITORY));
        Assert.assertNull((Object)this.migratedRepository.getCredentials(AuthenticationType.PROXY));
        Assert.assertNull((Object)this.migratedRepository.getCredentials(AuthenticationType.HTTP));
        Assert.assertNull((Object)this.migratedRepository.getCredentials(AuthenticationType.CERTIFICATE));
    }

    private void populateRepository() {
        this.repository.setProperty("foo", "foovalue");
        this.repository.setProperty("bar", "barvalue");
        this.repository.setProperty("lastsynctimestamp", "123");
        this.repository.setRepositoryLabel("My Label");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, this.repoCreds, true);
        this.repository.setCredentials(AuthenticationType.PROXY, this.proxyCreds, true);
        this.repository.setCredentials(AuthenticationType.HTTP, this.httpCreds, false);
        this.repository.setCredentials(AuthenticationType.CERTIFICATE, this.certCreds, false);
    }

    @Test
    public void needsMigrationEmptyKinds() {
        try {
            this.createMigrator(true, true, (Map<String, String>)ImmutableMap.of(), (Set<TaskRepository>)this.singleRepository, true);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void needsMigrationNoRepositories() {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of(), true);
        Assert.assertFalse((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationNoConnectors() {
        ConnectorMigrator migrator = this.createMigrator(false, false, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        Assert.assertFalse((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationNoNewConnector() {
        ConnectorMigrator migrator = this.createMigrator(true, false, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        Assert.assertFalse((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationNoOldConnector() {
        ConnectorMigrator migrator = this.createMigrator(false, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        Assert.assertFalse((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationOneRepository() {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)this.singleRepository, true);
        Assert.assertTrue((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationMultipleRepositories() {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository, (Object)new TaskRepository("mock", "http://mock2")), true);
        Assert.assertTrue((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationMultiKindsOneRepository() {
        ImmutableMap multiKinds = ImmutableMap.of((Object)"mock", (Object)"mock.new", (Object)"kind", (Object)"kind.new");
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)multiKinds, (Set<TaskRepository>)this.singleRepository, true);
        Assert.assertTrue((boolean)migrator.needsMigration());
        migrator = this.createMigrator(true, true, (Map<String, String>)multiKinds, (Set<TaskRepository>)ImmutableSet.of((Object)new TaskRepository("kind", "http://mock")), true);
        Assert.assertTrue((boolean)migrator.needsMigration());
    }

    @Test
    public void needsMigrationMultiKindsMultiRepositories() {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)ImmutableMap.of((Object)"mock", (Object)"mock.new", (Object)"kind", (Object)"kind.new"), (Set<TaskRepository>)ImmutableSet.of((Object)this.repository, (Object)new TaskRepository("kind", "http://mock")), true);
        Assert.assertTrue((boolean)migrator.needsMigration());
    }

    @Test
    public void migrateTasksWaitsForSyncJobs() throws Exception {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        JobListener listener = (JobListener)Mockito.mock(JobListener.class);
        Mockito.when((Object)listener.isComplete()).thenReturn((Object)false, (Object[])new Boolean[]{false, true});
        Mockito.when((Object)migrator.getSyncTaskJobListener()).thenReturn((Object)listener);
        migrator.migrateTasks((IProgressMonitor)new NullProgressMonitor());
        ((JobListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)3))).isComplete();
    }

    @Test
    public void migrateTasks() throws Exception {
        Mockito.when((Object)this.newConnector.getConnectorKind()).thenReturn((Object)"mock.new");
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        TaskData taskData2 = new TaskData((TaskAttributeMapper)Mockito.mock(TaskAttributeMapper.class), "mock.new", this.repository.getRepositoryUrl(), "2.migrated");
        ((ConnectorMigrator)Mockito.doReturn((Object)taskData2).when((Object)migrator)).getTaskData((String)ArgumentMatchers.eq((Object)"key2"), (AbstractRepositoryConnector)ArgumentMatchers.eq((Object)this.newConnector), (TaskRepository)ArgumentMatchers.any(TaskRepository.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        TaskTask task1 = new TaskTask("mock", "http://mock", "1");
        task1.setTaskKey("key1");
        ((AbstractTask)task1).setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
        TaskTask task2 = new TaskTask("mock", "http://mock", "2");
        task2.setTaskKey("key2");
        ((AbstractTask)task2).setSynchronizationState(ITask.SynchronizationState.INCOMING);
        TaskTask task1Migrated = new TaskTask("mock.new", "http://mock", "1.migrated");
        task1Migrated.setTaskKey("key1");
        TaskTask taskOtherRepo = new TaskTask("mock", "http://other-mock", "1");
        this.tasksState.getTaskList().addTask((ITask)task1);
        this.tasksState.getTaskList().addTask((ITask)task1Migrated);
        this.tasksState.getTaskList().addTask((ITask)taskOtherRepo);
        this.tasksState.getTaskList().addTask((ITask)task2);
        RepositoryQuery query = new RepositoryQuery("mock", "mock");
        query.setRepositoryUrl("http://mock");
        this.tasksState.getTaskList().addQuery(query);
        this.migrateConnectors(migrator);
        NullProgressMonitor monitor = new NullProgressMonitor();
        migrator.migrateTasks((IProgressMonitor)monitor);
        ((TaskActivityManager)Mockito.verify((Object)this.tasksState.getTaskActivityManager())).deactivateActiveTask();
        TaskRepository newRepository = this.manager.getRepository("mock.new", "http://mock");
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migrateTasks((Set)ImmutableSet.of((Object)task1, (Object)task2), this.repository, newRepository, this.manager.getRepositoryConnector("mock.new"), (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator, (VerificationMode)Mockito.never())).getTaskData("key1", this.newConnector, newRepository, (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator, (VerificationMode)Mockito.never())).createTask((TaskData)MockitoHamcrest.argThat((Matcher)CoreMatchers.not((Object)taskData2)), (TaskRepository)ArgumentMatchers.any(TaskRepository.class));
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).getTaskData("key2", this.newConnector, newRepository, (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).createTask(taskData2, newRepository);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migratePrivateData((AbstractTask)task1, (AbstractTask)task1Migrated, (IProgressMonitor)monitor);
        TaskTask task2Migrated = new TaskTask("mock.new", "http://mock", "2.migrated");
        task2Migrated.setTaskKey("key2");
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migratePrivateData((AbstractTask)task2, (AbstractTask)task2Migrated, (IProgressMonitor)monitor);
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).delete((Set)ImmutableSet.of((Object)task1, (Object)task2), this.repository, newRepository, (IProgressMonitor)monitor);
        Assert.assertEquals((Object)ITask.SynchronizationState.INCOMING_NEW, (Object)this.tasksState.getTaskList().getTask(this.repository.getRepositoryUrl(), "1.migrated").getSynchronizationState());
        Assert.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)this.tasksState.getTaskList().getTask(this.repository.getRepositoryUrl(), "2.migrated").getSynchronizationState());
        Assert.assertEquals((Object)ImmutableSet.of((Object)taskOtherRepo, (Object)task1Migrated, (Object)task2Migrated), (Object)ImmutableSet.copyOf((Collection)this.tasksState.getTaskList().getAllTasks()));
        ((TaskRepositoryManager)Mockito.verify((Object)this.tasksState.getRepositoryManager())).removeRepository(this.repository);
        Assert.assertTrue((boolean)this.tasksState.getTaskList().getQueries().isEmpty());
        Assert.assertEquals((Object)ImmutableSet.of((Object)newRepository), (Object)this.tasksState.getRepositoryManager().getRepositories("mock.new"));
    }

    @Test
    public void migrateTasksSameId() throws Exception {
        Mockito.when((Object)this.newConnector.getConnectorKind()).thenReturn((Object)"mock.new");
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        TaskData taskData1 = new TaskData((TaskAttributeMapper)Mockito.mock(TaskAttributeMapper.class), "mock.new", this.repository.getRepositoryUrl(), "1");
        ((ConnectorMigrator)Mockito.doReturn((Object)taskData1).when((Object)migrator)).getTaskData((String)ArgumentMatchers.eq((Object)"key1"), (AbstractRepositoryConnector)ArgumentMatchers.eq((Object)this.newConnector), (TaskRepository)ArgumentMatchers.any(TaskRepository.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        TaskData taskData2 = new TaskData((TaskAttributeMapper)Mockito.mock(TaskAttributeMapper.class), "mock.new", this.repository.getRepositoryUrl(), "2");
        ((ConnectorMigrator)Mockito.doReturn((Object)taskData2).when((Object)migrator)).getTaskData((String)ArgumentMatchers.eq((Object)"key2"), (AbstractRepositoryConnector)ArgumentMatchers.eq((Object)this.newConnector), (TaskRepository)ArgumentMatchers.any(TaskRepository.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class));
        TaskTask task1 = new TaskTask("mock", "http://mock", "1");
        task1.setTaskKey("key1");
        ((AbstractTask)task1).setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
        TaskTask task2 = new TaskTask("mock", "http://mock", "2");
        task2.setTaskKey("key2");
        ((AbstractTask)task2).setSynchronizationState(ITask.SynchronizationState.INCOMING);
        TaskTask task1Migrated = new TaskTask("mock.new", "http://mock", "1");
        task1Migrated.setTaskKey("key1");
        TaskTask taskOtherRepo = new TaskTask("mock", "http://other-mock", "1");
        this.tasksState.getTaskList().addTask((ITask)task1);
        this.tasksState.getTaskList().addTask((ITask)task1Migrated);
        this.tasksState.getTaskList().addTask((ITask)taskOtherRepo);
        this.tasksState.getTaskList().addTask((ITask)task2);
        RepositoryQuery query = new RepositoryQuery("mock", "mock");
        query.setRepositoryUrl("http://mock");
        this.tasksState.getTaskList().addQuery(query);
        this.migrateConnectors(migrator);
        NullProgressMonitor monitor = new NullProgressMonitor();
        migrator.migrateTasks((IProgressMonitor)monitor);
        ((TaskActivityManager)Mockito.verify((Object)this.tasksState.getTaskActivityManager())).deactivateActiveTask();
        TaskRepository newRepository = this.manager.getRepository("mock.new", "http://mock");
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migrateTasks((Set)ImmutableSet.of((Object)task1, (Object)task2), this.repository, newRepository, this.manager.getRepositoryConnector("mock.new"), (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).getTaskData("key1", this.newConnector, newRepository, (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).getTaskData("key2", this.newConnector, newRepository, (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).createTask(taskData2, newRepository);
        TaskTask task2Migrated = new TaskTask("mock.new", "http://mock", "2");
        task2Migrated.setTaskKey("key2");
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migratePrivateData((AbstractTask)task2, (AbstractTask)task2Migrated, (IProgressMonitor)monitor);
        ((ConnectorMigrator)Mockito.verify((Object)migrator)).migratePrivateData((AbstractTask)task1, (AbstractTask)task1Migrated, (IProgressMonitor)monitor);
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).delete((Set)ImmutableSet.of((Object)task1, (Object)task2), this.repository, newRepository, (IProgressMonitor)monitor);
        Assert.assertEquals((Object)ITask.SynchronizationState.INCOMING_NEW, (Object)this.tasksState.getTaskList().getTask(this.repository.getRepositoryUrl(), "1").getSynchronizationState());
        Assert.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)this.tasksState.getTaskList().getTask(this.repository.getRepositoryUrl(), "2").getSynchronizationState());
        Assert.assertEquals((Object)ImmutableSet.of((Object)taskOtherRepo, (Object)task1Migrated, (Object)task2Migrated), (Object)ImmutableSet.copyOf((Collection)this.tasksState.getTaskList().getAllTasks()));
        ((TaskRepositoryManager)Mockito.verify((Object)this.tasksState.getRepositoryManager())).removeRepository(this.repository);
        Assert.assertTrue((boolean)this.tasksState.getTaskList().getQueries().isEmpty());
        Assert.assertEquals((Object)ImmutableSet.of((Object)newRepository), (Object)this.tasksState.getRepositoryManager().getRepositories("mock.new"));
    }

    @Test
    public void migratePrivateData() throws Exception {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false);
        TaskTask oldTask = new TaskTask("mock", "http://mock", "1");
        TaskTask newTask = new TaskTask("mock.new", "http://mock", "1.migrated");
        oldTask.setNotes("some notes");
        DateRange scheduledDate = new DateRange(this.createCalendar(3));
        Calendar dueDate = this.createCalendar(5);
        this.tasksState.getTaskActivityManager().setScheduledFor((AbstractTask)oldTask, scheduledDate);
        this.tasksState.getTaskActivityManager().setDueDate((ITask)oldTask, dueDate.getTime());
        oldTask.setEstimatedTimeHours(7);
        migrator.migratePrivateData((AbstractTask)oldTask, (AbstractTask)newTask, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)"some notes", (Object)newTask.getNotes());
        Assert.assertEquals((Object)scheduledDate, (Object)newTask.getScheduledForDate());
        Assert.assertEquals((Object)dueDate.getTime(), (Object)newTask.getDueDate());
        Assert.assertEquals((long)7L, (long)newTask.getEstimatedTimeHours());
    }

    @Test
    public void migrateCategories() throws Exception {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false);
        TaskTask oldTask1 = new TaskTask("mock", "http://mock", "1");
        TaskTask oldTask2 = new TaskTask("mock", "http://mock", "2");
        TaskTask newTask1 = new TaskTask("mock.new", "http://mock", "1.migrated");
        TaskTask newTask2 = new TaskTask("mock.new", "http://mock", "2.migrated");
        TaskCategory category1 = new TaskCategory("category1");
        TaskCategory category2 = new TaskCategory("category2");
        this.tasksState.getTaskList().addCategory(category1);
        this.tasksState.getTaskList().addCategory(category2);
        this.tasksState.getTaskList().addTask((ITask)oldTask1, (AbstractTaskContainer)category1);
        this.tasksState.getTaskList().addTask((ITask)oldTask2, (AbstractTaskContainer)category2);
        migrator.migratePrivateData((AbstractTask)oldTask1, (AbstractTask)newTask1, (IProgressMonitor)new NullProgressMonitor());
        migrator.migratePrivateData((AbstractTask)oldTask2, (AbstractTask)newTask2, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)category1, (Object)this.getCategory((AbstractTask)newTask1));
        Assert.assertEquals((Object)category2, (Object)this.getCategory((AbstractTask)newTask2));
    }

    @Test
    public void getCategories() throws Exception {
        ConnectorMigrator migrator = this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false);
        TaskTask oldTask1 = new TaskTask("mock", "http://mock", "1");
        TaskTask oldTask2 = new TaskTask("mock", "http://mock", "2");
        TaskTask newTask1 = new TaskTask("mock.new", "http://mock", "1.migrated");
        TaskTask newTask2 = new TaskTask("mock.new", "http://mock", "2.migrated");
        TaskCategory category1 = new TaskCategory("category1");
        TaskCategory category2 = new TaskCategory("category2");
        this.tasksState.getTaskList().addCategory(category1);
        this.tasksState.getTaskList().addCategory(category2);
        this.tasksState.getTaskList().addTask((ITask)oldTask1, (AbstractTaskContainer)category1);
        this.tasksState.getTaskList().addTask((ITask)newTask1, (AbstractTaskContainer)category1);
        this.tasksState.getTaskList().addTask((ITask)oldTask2, (AbstractTaskContainer)category2);
        this.tasksState.getTaskList().addTask((ITask)newTask2, (AbstractTaskContainer)category2);
        this.tasksState.getTaskList().addTask((ITask)new TaskTask("mock.new", "http://mock", "not categorized"));
        ImmutableMap expected = ImmutableMap.of((Object)oldTask1, (Object)category1, (Object)oldTask2, (Object)category2, (Object)newTask1, (Object)category1, (Object)newTask2, (Object)category2);
        Assert.assertEquals((Object)expected, (Object)migrator.getCategories());
        this.tasksState.getTaskList().addTask((ITask)new TaskTask("mock.new", "http://mock", "3"), (AbstractTaskContainer)category1);
        Assert.assertEquals((Object)expected, (Object)migrator.getCategories());
    }

    @Test
    public void migrateNoQueries() {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        RepositoryQuery q1 = this.createQuery("q1", this.repository, migrator, false);
        RepositoryQuery q2 = this.createQuery("q2", this.repository, migrator, false);
        migrator.migrateQueries(this.repository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)migrator.anyQueriesMigrated());
        Assert.assertFalse((boolean)migrator.allQueriesMigrated());
    }

    @Test
    public void migrateSomeQueries() {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        RepositoryQuery q1 = this.createQuery("q1", this.repository, migrator, true);
        RepositoryQuery q2 = this.createQuery("q2", this.repository, migrator, false);
        Assert.assertFalse((boolean)migrator.anyQueriesMigrated());
        Assert.assertTrue((boolean)migrator.allQueriesMigrated());
        migrator.migrateQueries(this.repository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)migrator.anyQueriesMigrated());
        Assert.assertFalse((boolean)migrator.allQueriesMigrated());
    }

    @Test
    public void migrateAllQueries() {
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        RepositoryQuery q1 = this.createQuery("q1", this.repository, migrator, true);
        RepositoryQuery q2 = this.createQuery("q2", this.repository, migrator, true);
        migrator.migrateQueries(this.repository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)migrator.anyQueriesMigrated());
        Assert.assertTrue((boolean)migrator.allQueriesMigrated());
    }

    @Test
    public void migrateSomeQueriesMultipleRepositories() {
        TaskRepository otherRepository = new TaskRepository("mock", "http://other-mock");
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository, (Object)otherRepository), false));
        RepositoryQuery q1 = this.createQuery("q1", this.repository, migrator, true);
        RepositoryQuery q2 = this.createQuery("q2", this.repository, migrator, true);
        RepositoryQuery q3 = this.createQuery("q3", otherRepository, migrator, false);
        RepositoryQuery q4 = this.createQuery("q4", otherRepository, migrator, false);
        migrator.migrateQueries(this.repository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        migrator.migrateQueries(otherRepository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)migrator.anyQueriesMigrated());
        Assert.assertFalse((boolean)migrator.allQueriesMigrated());
    }

    @Test
    public void migrateAllQueriesMultipleRepositories() {
        TaskRepository otherRepository = new TaskRepository("mock", "http://other-mock");
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)this.kinds, (Set<TaskRepository>)ImmutableSet.of((Object)this.repository), false));
        RepositoryQuery q1 = this.createQuery("q1", this.repository, migrator, true);
        RepositoryQuery q2 = this.createQuery("q2", this.repository, migrator, true);
        RepositoryQuery q3 = this.createQuery("q3", otherRepository, migrator, true);
        RepositoryQuery q4 = this.createQuery("q4", otherRepository, migrator, true);
        migrator.migrateQueries(this.repository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        migrator.migrateQueries(otherRepository, this.migratedRepository, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)migrator.anyQueriesMigrated());
        Assert.assertTrue((boolean)migrator.allQueriesMigrated());
    }

    private RepositoryQuery createQuery(String handle, TaskRepository repository, ConnectorMigrator migrator, boolean shouldMigrate) {
        RepositoryQuery query = new RepositoryQuery(repository.getConnectorKind(), handle);
        query.setRepositoryUrl(repository.getRepositoryUrl());
        this.tasksState.getTaskList().addQuery(query);
        if (shouldMigrate) {
            RepositoryQuery migratedQuery = new RepositoryQuery(repository.getConnectorKind(), String.valueOf(handle) + ".migrated");
            migratedQuery.setRepositoryUrl(String.valueOf(repository.getRepositoryUrl()) + "/migrated");
            Mockito.when((Object)migrator.migrateQuery((RepositoryQuery)ArgumentMatchers.eq((Object)query), (TaskRepository)ArgumentMatchers.any(TaskRepository.class), (TaskRepository)ArgumentMatchers.any(TaskRepository.class), (IProgressMonitor)ArgumentMatchers.any(IProgressMonitor.class))).thenReturn((Object)migratedQuery);
        }
        return query;
    }

    private AbstractTaskCategory getCategory(AbstractTask newTask) {
        for (AbstractTaskCategory category : this.tasksState.getTaskList().getCategories()) {
            Optional task = Iterables.tryFind((Iterable)category.getChildren(), (Predicate)Predicates.equalTo((Object)newTask));
            if (!task.isPresent()) continue;
            return category;
        }
        return null;
    }

    private Calendar createCalendar(int daysInFuture) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, daysInFuture);
        return cal;
    }

    private ConnectorMigrator createMigrator(boolean hasOldConnector, boolean hasNewConnector, Map<String, String> kinds, Set<TaskRepository> repositories, boolean mockManager) {
        if (mockManager) {
            this.manager = (TaskRepositoryManager)Mockito.mock(TaskRepositoryManager.class);
        }
        Mockito.when((Object)this.tasksState.getRepositoryManager()).thenReturn((Object)this.manager);
        ConnectorMigrator migrator = new ConnectorMigrator(kinds, "", (TasksState)this.tasksState, this.migrationUi);
        Mockito.when((Object)this.manager.getRepositories("mock")).thenReturn(repositories);
        if (hasOldConnector) {
            Mockito.when((Object)this.manager.getRepositoryConnector("mock")).thenReturn((Object)this.connector);
            Mockito.when((Object)this.manager.getRepositoryConnector("kind")).thenReturn((Object)this.connector);
        }
        if (hasNewConnector) {
            Mockito.when((Object)this.manager.getRepositoryConnector("mock.new")).thenReturn((Object)this.newConnector);
            Mockito.when((Object)this.manager.getRepositoryConnector("kind.new")).thenReturn((Object)this.newConnector);
        }
        return migrator;
    }

    public class SpyTasksState
    extends DefaultTasksState {
        TaskActivityManager taskActivityManager = (TaskActivityManager)Mockito.spy((Object)super.getTaskActivityManager());
        TaskDataManager taskDataManager = (TaskDataManager)Mockito.spy((Object)super.getTaskDataManager());
        RepositoryModel repositoryModel = (RepositoryModel)Mockito.spy((Object)super.getRepositoryModel());
        TaskList taskList = (TaskList)Mockito.spy((Object)super.getTaskList());
        AbstractTaskContextStore contextStore = (AbstractTaskContextStore)Mockito.spy((Object)super.getContextStore());
        TaskJobFactory taskJobFactory = (TaskJobFactory)Mockito.spy((Object)super.getTaskJobFactory());
        TaskRepositoryManager repositoryManager = (TaskRepositoryManager)Mockito.spy((Object)super.getRepositoryManager());

        public TaskActivityManager getTaskActivityManager() {
            return this.taskActivityManager;
        }

        public TaskDataManager getTaskDataManager() {
            return this.taskDataManager;
        }

        public RepositoryModel getRepositoryModel() {
            return this.repositoryModel;
        }

        public TaskList getTaskList() {
            return this.taskList;
        }

        public AbstractTaskContextStore getContextStore() {
            return this.contextStore;
        }

        public TaskJobFactory getTaskJobFactory() {
            return this.taskJobFactory;
        }

        public TaskRepositoryManager getRepositoryManager() {
            return this.repositoryManager;
        }
    }
}

