/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationUi;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.DefaultTasksState;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListServiceMessageControl;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConnectorMigrationUiTest {
    private ConnectorMigrator migrator;
    private final TaskListView taskList = (TaskListView)Mockito.mock(TaskListView.class);
    private final TaskListBackupManager backupManager = (TaskListBackupManager)Mockito.mock(TaskListBackupManager.class);
    private final ConnectorMigrationUi migrationUi = (ConnectorMigrationUi)Mockito.spy((Object)new ConnectorMigrationUi(this.taskList, this.backupManager, (TasksState)new DefaultTasksState()));
    private ConnectorMigrationUi.CompleteMigrationJob completeMigrationJob;

    @Before
    public void setUp() {
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).warnOfValidationFailure((List)ArgumentMatchers.any(List.class));
        ((ConnectorMigrationUi)Mockito.doNothing().when((Object)this.migrationUi)).notifyMigrationComplete();
    }

    @After
    public void tearDown() {
        if (this.completeMigrationJob != null) {
            this.completeMigrationJob.dispose();
        }
    }

    @Test
    public void promptToMigrate() {
        ServiceMessage message = this.openMigrationPrompt(0);
        Assert.assertEquals((Object)"End of Connector Support", (Object)message.getTitle());
        Assert.assertTrue((boolean)message.getDescription().contains("<a href=\"migrate\">Click here</a>"));
        Assert.assertEquals((Object)"dialog_messasge_info_image", (Object)message.getImage());
        Assert.assertFalse((boolean)message.openLink("foo"));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi, (VerificationMode)Mockito.never())).createMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi, (VerificationMode)Mockito.never())).createPromptToCompleteMigrationJob((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        message.openLink("migrate");
    }

    @Test
    public void finishMigrationWizard() throws Exception {
        ServiceMessage message = this.openMigrationPrompt(0);
        Assert.assertTrue((boolean)message.openLink("migrate"));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).createPromptToCompleteMigrationJob((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
    }

    @Test
    public void cancelMigrationWizard() throws Exception {
        ServiceMessage message = this.openMigrationPrompt(1);
        Assert.assertFalse((boolean)message.openLink("migrate"));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi, (VerificationMode)Mockito.never())).createPromptToCompleteMigrationJob((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
    }

    @Test
    public void promptToMigrateOpensSecondMessage() {
        ServiceMessage message = this.openMigrationPrompt(0);
        Job job = (Job)Mockito.mock(Job.class);
        ((ConnectorMigrationUi)Mockito.doReturn((Object)job).when((Object)this.migrationUi)).createPromptToCompleteMigrationJob((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        message.openLink("migrate");
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).createMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).createPromptToCompleteMigrationJob((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        ((Job)Mockito.verify((Object)job)).schedule();
    }

    @Test
    public void promptToCompleteMigration() throws InterruptedException {
        ServiceMessage message = this.openCompleteMigrationPrompt(0);
        Assert.assertEquals((Object)"Connector Migration", (Object)message.getTitle());
        Assert.assertTrue((boolean)message.getDescription().contains("<a href=\"complete-migration\">complete migration</a>"));
        Assert.assertEquals((Object)"dialog_messasge_warning_image", (Object)message.getImage());
        Assert.assertFalse((boolean)message.openLink("foo"));
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi, (VerificationMode)Mockito.never())).createCompleteMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        message.openLink("complete-migration");
        ((ConnectorMigrationUi)Mockito.verify((Object)this.migrationUi)).createCompleteMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
    }

    @Test
    public void finishCompleteMigrationWizard() throws Exception {
        ServiceMessage message = this.openCompleteMigrationPrompt(0);
        Assert.assertTrue((boolean)message.openLink("complete-migration"));
    }

    @Test
    public void cancelCompleteMigrationWizard() throws Exception {
        ServiceMessage message = this.openCompleteMigrationPrompt(1);
        Assert.assertFalse((boolean)message.openLink("complete-migration"));
    }

    @Test
    public void secondMessageReopensAfterDelay() throws Exception {
        ServiceMessage message = this.openCompleteMigrationPrompt(0);
        TaskListServiceMessageControl messageControl = this.createMessageControl();
        Thread.sleep(2100L);
        ServiceMessage message2 = this.captureMessage(messageControl);
        Assert.assertTrue((message2 != message ? 1 : 0) != 0);
        Thread.sleep(2100L);
        ServiceMessage message3 = this.captureMessage(messageControl);
        Assert.assertTrue((message3 != message2 ? 1 : 0) != 0);
        message3.openLink("complete-migration");
        Thread.sleep(2100L);
        ServiceMessage message4 = this.captureMessage(messageControl);
        Assert.assertTrue((message4 == message3 ? 1 : 0) != 0);
    }

    @Test
    public void backupTaskList() throws Exception {
        ImmutableMap kinds = ImmutableMap.of((Object)"mock", (Object)"mock.new");
        TaskRepository repository = new TaskRepository("mock", "http://mock");
        ConnectorMigrator migrator = (ConnectorMigrator)Mockito.spy((Object)this.createMigrator(true, true, (Map<String, String>)kinds, (Set<TaskRepository>)ImmutableSet.of((Object)repository)));
        IProgressMonitor monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        this.migrationUi.backupTaskList(monitor);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.backupManager, this.migrationUi, migrator, monitor});
        ((IProgressMonitor)inOrder.verify((Object)monitor)).subTask("Backing up task list");
        ((ConnectorMigrationUi)inOrder.verify((Object)this.migrationUi)).getBackupFileName((Date)ArgumentMatchers.any(Date.class));
        ((TaskListBackupManager)inOrder.verify((Object)this.backupManager)).backupNow(true);
        ((IProgressMonitor)inOrder.verify((Object)monitor)).worked(1);
    }

    @Test
    public void getBackupFileName() throws Exception {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        date = cal.getTime();
        String fileName = this.migrationUi.getBackupFileName(date);
        Matcher m = Pattern.compile("connector-migration-(\\d{4}_\\d{2}_\\d{2}_\\d{6}).zip").matcher(fileName);
        Matcher dateFormatMatcher = Pattern.compile("\\d{4}-\\d{2}-\\d{2}-\\d{6}.zip").matcher(fileName);
        Matcher oldDateFormatMatcher = Pattern.compile("\\d{4}-\\d{2}-\\d{2}").matcher(fileName);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertFalse((boolean)dateFormatMatcher.find());
        Assert.assertFalse((boolean)oldDateFormatMatcher.find());
        Date fileNameTime = new SimpleDateFormat("yyyy_MM_dd_HHmmss").parse(m.group(1));
        Assert.assertEquals((Object)date, (Object)fileNameTime);
    }

    private ServiceMessage openMigrationPrompt(int returnCode) {
        TaskListServiceMessageControl messageControl = this.createMessageControl();
        this.migrator = (ConnectorMigrator)Mockito.spy((Object)new ConnectorMigrator((Map)ImmutableMap.of((Object)"mock", (Object)"mock.new"), "", (TasksState)new DefaultTasksState(), this.migrationUi));
        WizardDialog wizard = (WizardDialog)Mockito.mock(WizardDialog.class);
        Mockito.when((Object)wizard.open()).thenReturn((Object)returnCode);
        ((ConnectorMigrationUi)Mockito.doReturn((Object)wizard).when((Object)this.migrationUi)).createMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        this.migrationUi.promptToMigrate(this.migrator);
        return this.captureMessage(messageControl);
    }

    private ServiceMessage openCompleteMigrationPrompt(int returnCode) throws InterruptedException {
        TaskListServiceMessageControl messageControl = this.createMessageControl();
        this.migrator = (ConnectorMigrator)Mockito.spy((Object)new ConnectorMigrator((Map)ImmutableMap.of((Object)"mock", (Object)"mock.new"), "", (TasksState)new DefaultTasksState(), this.migrationUi));
        Mockito.when((Object)this.migrationUi.getCompletionPromptFrequency()).thenReturn((Object)2);
        WizardDialog wizard = (WizardDialog)Mockito.mock(WizardDialog.class);
        Mockito.when((Object)wizard.open()).thenReturn((Object)returnCode);
        ((ConnectorMigrationUi)Mockito.doReturn((Object)wizard).when((Object)this.migrationUi)).createCompleteMigrationWizard((ConnectorMigrator)ArgumentMatchers.any(ConnectorMigrator.class));
        this.completeMigrationJob = (ConnectorMigrationUi.CompleteMigrationJob)this.migrationUi.createPromptToCompleteMigrationJob(this.migrator);
        Assert.assertTrue((boolean)this.completeMigrationJob.isSystem());
        Assert.assertFalse((boolean)this.completeMigrationJob.isUser());
        this.completeMigrationJob.schedule();
        this.completeMigrationJob.join();
        return this.captureMessage(messageControl);
    }

    private TaskListServiceMessageControl createMessageControl() {
        TaskListServiceMessageControl messageControl = (TaskListServiceMessageControl)Mockito.mock(TaskListServiceMessageControl.class);
        Mockito.when((Object)this.taskList.getServiceMessageControl()).thenReturn((Object)messageControl);
        return messageControl;
    }

    private ServiceMessage captureMessage(TaskListServiceMessageControl messageControl) {
        this.spinEventLoop();
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(ServiceMessage.class);
        ((TaskListServiceMessageControl)Mockito.verify((Object)messageControl, (VerificationMode)Mockito.atLeastOnce())).setMessage((ServiceMessage)messageCaptor.capture());
        ServiceMessage message = (ServiceMessage)messageCaptor.getValue();
        return message;
    }

    private void spinEventLoop() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    private ConnectorMigrator createMigrator(boolean hasOldConnector, boolean hasNewConnector, Map<String, String> kinds, Set<TaskRepository> repositories) {
        IRepositoryManager manager = (IRepositoryManager)Mockito.mock(IRepositoryManager.class);
        AbstractRepositoryConnector connector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
        ConnectorMigrator migrator = new ConnectorMigrator(kinds, "", (TasksState)new DefaultTasksState(), this.migrationUi);
        Mockito.when((Object)manager.getRepositories("mock")).thenReturn(repositories);
        if (hasOldConnector) {
            Mockito.when((Object)manager.getRepositoryConnector("mock")).thenReturn((Object)connector);
            Mockito.when((Object)manager.getRepositoryConnector("kind")).thenReturn((Object)connector);
        }
        if (hasNewConnector) {
            Mockito.when((Object)manager.getRepositoryConnector("mock.new")).thenReturn((Object)connector);
            Mockito.when((Object)manager.getRepositoryConnector("kind.new")).thenReturn((Object)connector);
        }
        return migrator;
    }
}

