/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.util.TestUtils;

public class TaskRepositoryCredentialsTest
extends TestCase {
    private static final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    private static final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    private static final String AUTH_CERT = "org.eclipse.mylyn.tasklist.repositories.certauth";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    private static final String PASSWORD = ".password";
    private TaskRepository taskRepository;
    private ILocationService service;

    private static String getKeyPrefix(AuthenticationType type) {
        switch (type) {
            case HTTP: {
                return AUTH_HTTP;
            }
            case CERTIFICATE: {
                return AUTH_CERT;
            }
            case PROXY: {
                return AUTH_PROXY;
            }
            case REPOSITORY: {
                return AUTH_REPOSITORY;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + type);
    }

    private String getPassword(AuthenticationType authType) {
        ICredentialsStore store = this.service.getCredentialsStore(this.taskRepository.getRepositoryUrl());
        String password = store.get(String.valueOf(TaskRepositoryCredentialsTest.getKeyPrefix(authType)) + PASSWORD, null);
        return password;
    }

    protected void setUp() throws Exception {
        this.service = LocationService.getDefault();
        this.taskRepository = new TaskRepository("kind", "http://url");
    }

    protected void tearDown() throws Exception {
        this.taskRepository.flushAuthenticationCredentials();
    }

    public void testPlatformAuthHandlerAvailable() throws Exception {
        if (!TestUtils.isCompatibilityAuthInstalled()) {
            System.err.println("Skipping TaskRepositoryCredentialsTest.testPlatformAuthHandlerAvailable()");
            return;
        }
        URL url = new URL("http://mylyn");
        AuthorizationHandler.addAuthorizationInfo((URL)url, (String)"", (String)"", (Map)Collections.EMPTY_MAP);
        TaskRepositoryCredentialsTest.assertNotNull((String)"Tests require org.eclipse.core.runtime.compatibility.auth", (Object)AuthorizationHandler.getAuthorizationInfo((URL)url, (String)"", (String)""));
    }

    public void testLabel() {
        TaskRepository repository = new TaskRepository("kind", "http://foo.bar");
        TaskRepositoryCredentialsTest.assertTrue((boolean)repository.getRepositoryLabel().equals(repository.getRepositoryUrl()));
        repository.setProperty("label", "label");
        TaskRepositoryCredentialsTest.assertTrue((boolean)repository.getRepositoryLabel().equals("label"));
    }

    public void testPassword() throws Exception {
        this.assertCredentials(AuthenticationType.REPOSITORY);
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)this.taskRepository.getUserName());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getPassword());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)this.taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)this.taskRepository.getHttpPassword());
    }

    public void testHttpPassword() throws Exception {
        this.assertCredentials(AuthenticationType.HTTP);
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)taskRepository.getHttpPassword());
    }

    public void testProxyPassword() throws Exception {
        this.assertCredentials(AuthenticationType.PROXY);
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.PROXY, new AuthenticationCredentials("user", "pwd"), false);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)taskRepository.getProxyUsername());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)taskRepository.getProxyPassword());
    }

    public void testFlushCredentials() throws Exception {
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), false);
        taskRepository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("user", "pwd"), true);
        taskRepository.setCredentials(AuthenticationType.PROXY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertNotNull((Object)taskRepository.getCredentials(AuthenticationType.REPOSITORY));
        TaskRepositoryCredentialsTest.assertNotNull((Object)taskRepository.getCredentials(AuthenticationType.HTTP));
        TaskRepositoryCredentialsTest.assertNotNull((Object)taskRepository.getCredentials(AuthenticationType.PROXY));
        taskRepository.flushAuthenticationCredentials();
        TaskRepositoryCredentialsTest.assertNotNull((Object)taskRepository.getUserName());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getPassword());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getHttpPassword());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getProxyUsername());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getProxyPassword());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.REPOSITORY));
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.HTTP));
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.PROXY));
    }

    public void testPlatformIsRunning() {
        TaskRepositoryCredentialsTest.assertTrue((boolean)Platform.isRunning());
    }

    public void assertCredentials(AuthenticationType authType) throws Exception {
        TaskRepositoryCredentialsTest.assertNull((Object)this.getPassword(authType));
        try {
            this.taskRepository.flushAuthenticationCredentials();
            TaskRepositoryCredentialsTest.assertNull((Object)this.taskRepository.getCredentials(authType));
            TaskRepositoryCredentialsTest.assertTrue((boolean)this.taskRepository.getSavePassword(authType));
            this.taskRepository.setCredentials(authType, new AuthenticationCredentials("user", "pwd"), true);
            AuthenticationCredentials credentials = this.taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)credentials.getPassword());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.getPassword(authType));
            this.taskRepository.setCredentials(authType, new AuthenticationCredentials("user1", "pwd1"), false);
            TaskRepositoryCredentialsTest.assertFalse((boolean)this.taskRepository.getSavePassword(authType));
            credentials = this.taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user1", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd1", (String)credentials.getPassword());
            TaskRepositoryCredentialsTest.assertNull((Object)this.getPassword(authType));
            this.taskRepository.setCredentials(authType, new AuthenticationCredentials("user2", "pwd2"), true);
            TaskRepositoryCredentialsTest.assertTrue((boolean)this.taskRepository.getSavePassword(authType));
            credentials = this.taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user2", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd2", (String)credentials.getPassword());
        }
        finally {
            this.taskRepository.flushAuthenticationCredentials();
        }
    }

    public void testConfigUpdateStoring() throws Exception {
        Date stamp = this.taskRepository.getConfigurationDate();
        TaskRepositoryCredentialsTest.assertNull((String)"unset configuration date returns null", (Object)stamp);
        stamp = new Date();
        stamp.setTime(stamp.getTime() - 35000L);
        this.taskRepository.setConfigurationDate(stamp);
        TaskRepositoryCredentialsTest.assertEquals((String)"Time stamp set", (long)stamp.getTime(), (long)this.taskRepository.getConfigurationDate().getTime());
    }

    public void testDoNotPersistCredentials() throws Exception {
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        this.taskRepository.setShouldPersistCredentials(false);
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "newpwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"newpwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        this.taskRepository.setShouldPersistCredentials(true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
    }

    public void testSetCredentialsDoesNotAffectExistingRepositoryWhenShouldNotPersistIsSetToTrue() throws Exception {
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepository newRepository = new TaskRepository("kind", "http://url");
        newRepository.setShouldPersistCredentials(false);
        newRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("newuser", "newpwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepositoryCredentialsTest.assertEquals((String)"newpwd", (String)newRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd2"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd2", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepositoryCredentialsTest.assertEquals((String)"newpwd", (String)newRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
    }

    public void testSetCredentialsAffectExistingRepository() throws Exception {
        this.taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepository newRepository = new TaskRepository("kind", "http://url");
        newRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("newuser", "newpwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"newpwd", (String)this.taskRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        TaskRepositoryCredentialsTest.assertEquals((String)"newpwd", (String)newRepository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
    }
}

