/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.tests.ui;

import junit.framework.TestCase;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.reviews.ui.compare.Direction;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareAnnotationSupport;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class ReviewCompareAnnotationSupportTest
extends TestCase {
    @Spy
    private final ReviewCompareAnnotationSupport rcaSupportspy = new ReviewCompareAnnotationSupport((Viewer)Mockito.mock(ListViewer.class));

    public void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        ((ReviewCompareAnnotationSupport)Mockito.doNothing().when((Object)this.rcaSupportspy)).moveToAnnotation((MergeSourceViewer)ArgumentMatchers.any(), (MergeSourceViewer)ArgumentMatchers.any(), (Position)ArgumentMatchers.any());
    }

    @Test
    public void testNextAnnotFwdLeftBeforeRightOffsetAfterBoth() throws Exception {
        this.assertSide(Direction.FORWARDS, 5, 8, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftAfterRightOffsetAfterBoth() throws Exception {
        this.assertSide(Direction.FORWARDS, 5, 3, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftBeforeRightOffsetBeforeBoth() throws Exception {
        this.assertSide(Direction.FORWARDS, 15, 16, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftAfterRightOffsetBeforeBoth() throws Exception {
        this.assertSide(Direction.FORWARDS, 20, 15, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftBeforeRightOffsetAfterLeftBeforeRightAfter() throws Exception {
        this.assertSide(Direction.FORWARDS, 5, 15, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftAfterRightOffsetBeforeLeftAfterRight() throws Exception {
        this.assertSide(Direction.FORWARDS, 10, 0, 1, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftAfterRightOffsetEqualLeftAfterRight() throws Exception {
        this.assertSide(Direction.FORWARDS, 10, 0, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftAfterRightOffsetBeforeLeftEqualRight() throws Exception {
        this.assertSide(Direction.FORWARDS, 10, 0, 0, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftBeforeRightOffsetEqualLeftBeforeRight() throws Exception {
        this.assertSide(Direction.FORWARDS, 0, 10, 0, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotFwdLeftBeforeRightOffsetAfterLeftEqualRight() throws Exception {
        this.assertSide(Direction.FORWARDS, 0, 10, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftAfterRightOffsetBeforeBoth() throws Exception {
        this.assertSide(Direction.BACKWARDS, 20, 15, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftBeforeRightOffsetBeforeBoth() throws Exception {
        this.assertSide(Direction.BACKWARDS, 20, 25, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftAfterRightOffsetAfterBoth() throws Exception {
        this.assertSide(Direction.BACKWARDS, 10, 0, 15, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftBeforeRightOffsetAfterBoth() throws Exception {
        this.assertSide(Direction.BACKWARDS, 5, 8, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftAfterRightOffsetLeftAfterRightBefore() throws Exception {
        this.assertSide(Direction.BACKWARDS, 10, 0, 1, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftBeforeRightOffsetLeftBeforeRightAfter() throws Exception {
        this.assertSide(Direction.BACKWARDS, 5, 15, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftAfterRightOffsetEqualLeftAfterRight() throws Exception {
        this.assertSide(Direction.BACKWARDS, 10, 0, 10, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftAfterRightOffsetBeforeLeftEqualRight() throws Exception {
        this.assertSide(Direction.BACKWARDS, 10, 0, 0, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftBeforeRightOffsetEqualLeftBeforeRight() throws Exception {
        this.assertSide(Direction.BACKWARDS, 0, 10, 0, ReviewCompareAnnotationSupport.Side.RIGHT_SIDE);
    }

    @Test
    public void testNextAnnotBwdLeftBeforeRightOffsetAfterLeftEqualRight() throws Exception {
        this.assertSide(Direction.BACKWARDS, 0, 10, 10, ReviewCompareAnnotationSupport.Side.LEFT_SIDE);
    }

    private void assertSide(Direction direction, int left, int right, int currentLeftOffset, ReviewCompareAnnotationSupport.Side expectedSide) {
        Position nextLeftPosition = new Position(left, 0);
        Position nextRightPosition = new Position(right, 0);
        ReviewCompareAnnotationSupport.Side side = this.rcaSupportspy.calculateNextAnnotation(direction, nextLeftPosition, nextRightPosition, Integer.valueOf(currentLeftOffset));
        ReviewCompareAnnotationSupportTest.assertEquals((Object)expectedSide, (Object)side);
    }
}

